/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.knownlist.AttackableKnownList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuardKnownList
extends AttackableKnownList {
    private static final Logger LOG = LoggerFactory.getLogger(GuardKnownList.class);

    public GuardKnownList(L2GuardInstance activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        if (object.isPlayer()) {
            if (object.getActingPlayer().getKarma() > 0) {
                if (Configuration.general().debug()) {
                    LOG.debug("{}: PK {} entered scan range", (Object)this.getActiveChar().getObjectId(), (Object)object.getObjectId());
                }
                if (this.getActiveChar().getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                    this.getActiveChar().getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
                }
            }
        } else if (Configuration.npc().guardAttackAggroMob() && this.getActiveChar().isInActiveRegion() && object.isMonster() && ((L2MonsterInstance)object).isAggressive()) {
            if (Configuration.general().debug()) {
                LOG.debug("{}: Aggressive mob {} entered scan range", (Object)this.getActiveChar().getObjectId(), (Object)object.getObjectId());
            }
            if (this.getActiveChar().getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                this.getActiveChar().getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
            }
        }
        return true;
    }

    @Override
    protected boolean removeKnownObject(L2Object object, boolean forget) {
        if (!super.removeKnownObject(object, forget)) {
            return false;
        }
        if (this.getActiveChar().getAggroList().isEmpty() && this.getActiveChar().hasAI() && !this.getActiveChar().isWalker()) {
            this.getActiveChar().getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
        }
        return true;
    }

    @Override
    public final L2GuardInstance getActiveChar() {
        return (L2GuardInstance)super.getActiveChar();
    }
}

