/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.stat;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.json.ExperienceData;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.stat.CharStat;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.playable.PlayableExpChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerLevelChanged;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.model.zone.type.L2SwampZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayableStat
extends CharStat {
    protected static final Logger LOG = LoggerFactory.getLogger(PlayableStat.class);
    private final AtomicLong _exp = new AtomicLong();
    private final AtomicInteger _sp = new AtomicInteger();

    public PlayableStat(L2Playable activeChar) {
        super(activeChar);
    }

    public long getExp() {
        return this._exp.get();
    }

    public int getSp() {
        return this._sp.get();
    }

    public void setExp(long exp) {
        this._exp.set(exp);
    }

    public void setSp(int sp) {
        this._sp.set(sp);
    }

    public boolean removeExp(long exp) {
        long currentExp = this.getExp();
        if (currentExp < exp) {
            this._exp.addAndGet(-currentExp);
        } else {
            this._exp.addAndGet(-exp);
        }
        this.syncExpLevel(false);
        return true;
    }

    public boolean removeSp(int sp) {
        int currentSp = this.getSp();
        if (currentSp < sp) {
            this._sp.addAndGet(-currentSp);
        } else {
            this._sp.addAndGet(-sp);
        }
        return true;
    }

    public boolean addExp(long value) {
        long currentExp = this.getExp();
        long totalExp = currentExp + value;
        TerminateReturn term = EventDispatcher.getInstance().notifyEvent(new PlayableExpChanged(this.getActiveChar(), currentExp, totalExp), this.getActiveChar(), TerminateReturn.class);
        if (term != null && term.terminate()) {
            return false;
        }
        if (totalExp < 0L || value > 0L && currentExp == this.getExpForLevel(this.getMaxExpLevel()) - 1L) {
            return true;
        }
        if (totalExp >= this.getExpForLevel(this.getMaxExpLevel())) {
            value = this.getExpForLevel(this.getMaxExpLevel()) - 1L - currentExp;
        }
        if (this._exp.addAndGet(value) >= this.getExpForLevel(this.getLevel() + 1)) {
            this.syncExpLevel(true);
        }
        return true;
    }

    private void syncExpLevel(boolean isExpIncreased) {
        int minimumLevel = this.getActiveChar().getMinLevel();
        long currentExp = this.getExp();
        int maxLevel = this.getMaxLevel();
        int currentLevel = this.getLevel();
        if (isExpIncreased) {
            for (int tmp = currentLevel; tmp <= maxLevel; ++tmp) {
                if (currentExp < this.getExpForLevel(tmp) || currentExp >= this.getExpForLevel(tmp + 1)) continue;
                if (tmp < minimumLevel) {
                    tmp = minimumLevel;
                }
                if (tmp == currentLevel) break;
                int newLevel = tmp - currentLevel;
                EventDispatcher.getInstance().notifyEventAsync(new PlayerLevelChanged(this.getActiveChar().getActingPlayer(), currentLevel, newLevel), this.getActiveChar());
                this.getActiveChar().addLevel(newLevel);
                break;
            }
        } else {
            for (int tmp = currentLevel; tmp >= minimumLevel; --tmp) {
                if (currentExp >= this.getExpForLevel(tmp) || currentExp < this.getExpForLevel(tmp - 1)) continue;
                if (--tmp < minimumLevel) {
                    tmp = minimumLevel;
                }
                if (tmp == currentLevel) break;
                int newLevel = tmp - currentLevel;
                EventDispatcher.getInstance().notifyEventAsync(new PlayerLevelChanged(this.getActiveChar().getActingPlayer(), currentLevel, newLevel), this.getActiveChar());
                this.getActiveChar().addLevel(newLevel);
                break;
            }
        }
    }

    public boolean addSp(int sp) {
        if (sp < 0) {
            LOG.warn("addSp accepts only positive numbers!");
            return false;
        }
        int currentSp = this.getSp();
        if (currentSp == Integer.MAX_VALUE) {
            return false;
        }
        if (sp > Integer.MAX_VALUE - currentSp) {
            this._sp.set(Integer.MAX_VALUE);
        } else {
            this._sp.addAndGet(sp);
        }
        return true;
    }

    public boolean addLevel(int value) {
        int currentLevel = this.getLevel();
        if (currentLevel + value > this.getMaxLevel()) {
            if (currentLevel < this.getMaxLevel()) {
                value = this.getMaxLevel() - currentLevel;
            } else {
                return false;
            }
        }
        boolean levelIncreased = currentLevel + value > currentLevel;
        this.setLevel(value += currentLevel);
        if (this.getExp() >= this.getExpForLevel(this.getLevel() + 1) || this.getExpForLevel(this.getLevel()) > this.getExp()) {
            this.setExp(this.getExpForLevel(this.getLevel()));
        }
        if (!levelIncreased) {
            return false;
        }
        this.getActiveChar().getStatus().setCurrentHp(this.getActiveChar().getStat().getMaxHp());
        this.getActiveChar().getStatus().setCurrentMp(this.getActiveChar().getStat().getMaxMp());
        return true;
    }

    public long getExpForLevel(int level) {
        return ExperienceData.getInstance().getExpForLevel(level);
    }

    public int getMaxLevel() {
        return Configuration.character().getMaxPlayerLevel();
    }

    public int getMaxExpLevel() {
        return Configuration.character().getMaxPlayerLevel() + 1;
    }

    @Override
    public L2Playable getActiveChar() {
        return (L2Playable)super.getActiveChar();
    }

    @Override
    public double getRunSpeed() {
        L2SwampZone zone;
        if (this.getActiveChar().isInsideZone(ZoneId.SWAMP) && (zone = ZoneManager.getInstance().getZone(this.getActiveChar(), L2SwampZone.class)) != null) {
            return super.getRunSpeed() * zone.getMoveBonus();
        }
        return super.getRunSpeed();
    }

    @Override
    public double getWalkSpeed() {
        L2SwampZone zone;
        if (this.getActiveChar().isInsideZone(ZoneId.SWAMP) && (zone = ZoneManager.getInstance().getZone(this.getActiveChar(), L2SwampZone.class)) != null) {
            return super.getWalkSpeed() * zone.getMoveBonus();
        }
        return super.getWalkSpeed();
    }
}

