/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.announce;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AnnouncementType {
    NORMAL,
    CRITICAL,
    EVENT,
    AUTO_NORMAL,
    AUTO_CRITICAL;

    private static final Logger LOG;

    public static AnnouncementType findById(int id) {
        for (AnnouncementType type : AnnouncementType.values()) {
            if (type.ordinal() != id) continue;
            return type;
        }
        LOG.warn("Nonexistent id specified: {}!", (Object)id, (Object)new IllegalStateException());
        return NORMAL;
    }

    public static AnnouncementType findByName(String name) {
        for (AnnouncementType type : AnnouncementType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        LOG.warn("Nonexistent name specified: {}!", (Object)name, (Object)new IllegalStateException());
        return NORMAL;
    }

    static {
        LOG = LoggerFactory.getLogger(AnnouncementType.class);
    }
}

