/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.announce;

import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.announce.AnnouncementType;
import com.l2jserver.gameserver.model.announce.IAnnouncement;
import com.l2jserver.gameserver.script.DateRange;
import java.util.Date;

public class EventAnnouncement
implements IAnnouncement {
    private final int _id = IdFactory.getInstance().getNextId();
    private final DateRange _range;
    private String _content;

    public EventAnnouncement(DateRange range, String content) {
        this._range = range;
        this._content = content;
    }

    @Override
    public int getId() {
        return this._id;
    }

    @Override
    public AnnouncementType getType() {
        return AnnouncementType.EVENT;
    }

    @Override
    public void setType(AnnouncementType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid() {
        return this._range.isWithinRange(new Date());
    }

    @Override
    public String getContent() {
        return this._content;
    }

    @Override
    public void setContent(String content) {
        this._content = content;
    }

    @Override
    public String getAuthor() {
        return "N/A";
    }

    @Override
    public void setAuthor(String author) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deleteMe() {
        IdFactory.getInstance().releaseId(this._id);
        return true;
    }

    @Override
    public boolean storeMe() {
        return true;
    }

    @Override
    public boolean updateMe() {
        throw new UnsupportedOperationException();
    }
}

