/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.base;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.Race;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.ClassLevel;
import com.l2jserver.gameserver.model.base.ClassType;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;

public enum PlayerClass {
    HumanFighter(Race.HUMAN, ClassType.Fighter, ClassLevel.First),
    Warrior(Race.HUMAN, ClassType.Fighter, ClassLevel.Second),
    Gladiator(Race.HUMAN, ClassType.Fighter, ClassLevel.Third),
    Warlord(Race.HUMAN, ClassType.Fighter, ClassLevel.Third),
    HumanKnight(Race.HUMAN, ClassType.Fighter, ClassLevel.Second),
    Paladin(Race.HUMAN, ClassType.Fighter, ClassLevel.Third),
    DarkAvenger(Race.HUMAN, ClassType.Fighter, ClassLevel.Third),
    Rogue(Race.HUMAN, ClassType.Fighter, ClassLevel.Second),
    TreasureHunter(Race.HUMAN, ClassType.Fighter, ClassLevel.Third),
    Hawkeye(Race.HUMAN, ClassType.Fighter, ClassLevel.Third),
    HumanMystic(Race.HUMAN, ClassType.Mystic, ClassLevel.First),
    HumanWizard(Race.HUMAN, ClassType.Mystic, ClassLevel.Second),
    Sorceror(Race.HUMAN, ClassType.Mystic, ClassLevel.Third),
    Necromancer(Race.HUMAN, ClassType.Mystic, ClassLevel.Third),
    Warlock(Race.HUMAN, ClassType.Mystic, ClassLevel.Third),
    Cleric(Race.HUMAN, ClassType.Priest, ClassLevel.Second),
    Bishop(Race.HUMAN, ClassType.Priest, ClassLevel.Third),
    Prophet(Race.HUMAN, ClassType.Priest, ClassLevel.Third),
    ElvenFighter(Race.ELF, ClassType.Fighter, ClassLevel.First),
    ElvenKnight(Race.ELF, ClassType.Fighter, ClassLevel.Second),
    TempleKnight(Race.ELF, ClassType.Fighter, ClassLevel.Third),
    Swordsinger(Race.ELF, ClassType.Fighter, ClassLevel.Third),
    ElvenScout(Race.ELF, ClassType.Fighter, ClassLevel.Second),
    Plainswalker(Race.ELF, ClassType.Fighter, ClassLevel.Third),
    SilverRanger(Race.ELF, ClassType.Fighter, ClassLevel.Third),
    ElvenMystic(Race.ELF, ClassType.Mystic, ClassLevel.First),
    ElvenWizard(Race.ELF, ClassType.Mystic, ClassLevel.Second),
    Spellsinger(Race.ELF, ClassType.Mystic, ClassLevel.Third),
    ElementalSummoner(Race.ELF, ClassType.Mystic, ClassLevel.Third),
    ElvenOracle(Race.ELF, ClassType.Priest, ClassLevel.Second),
    ElvenElder(Race.ELF, ClassType.Priest, ClassLevel.Third),
    DarkElvenFighter(Race.DARK_ELF, ClassType.Fighter, ClassLevel.First),
    PalusKnight(Race.DARK_ELF, ClassType.Fighter, ClassLevel.Second),
    ShillienKnight(Race.DARK_ELF, ClassType.Fighter, ClassLevel.Third),
    Bladedancer(Race.DARK_ELF, ClassType.Fighter, ClassLevel.Third),
    Assassin(Race.DARK_ELF, ClassType.Fighter, ClassLevel.Second),
    AbyssWalker(Race.DARK_ELF, ClassType.Fighter, ClassLevel.Third),
    PhantomRanger(Race.DARK_ELF, ClassType.Fighter, ClassLevel.Third),
    DarkElvenMystic(Race.DARK_ELF, ClassType.Mystic, ClassLevel.First),
    DarkElvenWizard(Race.DARK_ELF, ClassType.Mystic, ClassLevel.Second),
    Spellhowler(Race.DARK_ELF, ClassType.Mystic, ClassLevel.Third),
    PhantomSummoner(Race.DARK_ELF, ClassType.Mystic, ClassLevel.Third),
    ShillienOracle(Race.DARK_ELF, ClassType.Priest, ClassLevel.Second),
    ShillienElder(Race.DARK_ELF, ClassType.Priest, ClassLevel.Third),
    OrcFighter(Race.ORC, ClassType.Fighter, ClassLevel.First),
    OrcRaider(Race.ORC, ClassType.Fighter, ClassLevel.Second),
    Destroyer(Race.ORC, ClassType.Fighter, ClassLevel.Third),
    OrcMonk(Race.ORC, ClassType.Fighter, ClassLevel.Second),
    Tyrant(Race.ORC, ClassType.Fighter, ClassLevel.Third),
    OrcMystic(Race.ORC, ClassType.Mystic, ClassLevel.First),
    OrcShaman(Race.ORC, ClassType.Mystic, ClassLevel.Second),
    Overlord(Race.ORC, ClassType.Mystic, ClassLevel.Third),
    Warcryer(Race.ORC, ClassType.Mystic, ClassLevel.Third),
    DwarvenFighter(Race.DWARF, ClassType.Fighter, ClassLevel.First),
    DwarvenScavenger(Race.DWARF, ClassType.Fighter, ClassLevel.Second),
    BountyHunter(Race.DWARF, ClassType.Fighter, ClassLevel.Third),
    DwarvenArtisan(Race.DWARF, ClassType.Fighter, ClassLevel.Second),
    Warsmith(Race.DWARF, ClassType.Fighter, ClassLevel.Third),
    dummyEntry1(null, null, null),
    dummyEntry2(null, null, null),
    dummyEntry3(null, null, null),
    dummyEntry4(null, null, null),
    dummyEntry5(null, null, null),
    dummyEntry6(null, null, null),
    dummyEntry7(null, null, null),
    dummyEntry8(null, null, null),
    dummyEntry9(null, null, null),
    dummyEntry10(null, null, null),
    dummyEntry11(null, null, null),
    dummyEntry12(null, null, null),
    dummyEntry13(null, null, null),
    dummyEntry14(null, null, null),
    dummyEntry15(null, null, null),
    dummyEntry16(null, null, null),
    dummyEntry17(null, null, null),
    dummyEntry18(null, null, null),
    dummyEntry19(null, null, null),
    dummyEntry20(null, null, null),
    dummyEntry21(null, null, null),
    dummyEntry22(null, null, null),
    dummyEntry23(null, null, null),
    dummyEntry24(null, null, null),
    dummyEntry25(null, null, null),
    dummyEntry26(null, null, null),
    dummyEntry27(null, null, null),
    dummyEntry28(null, null, null),
    dummyEntry29(null, null, null),
    dummyEntry30(null, null, null),
    duelist(Race.HUMAN, ClassType.Fighter, ClassLevel.Fourth),
    dreadnought(Race.HUMAN, ClassType.Fighter, ClassLevel.Fourth),
    phoenixKnight(Race.HUMAN, ClassType.Fighter, ClassLevel.Fourth),
    hellKnight(Race.HUMAN, ClassType.Fighter, ClassLevel.Fourth),
    sagittarius(Race.HUMAN, ClassType.Fighter, ClassLevel.Fourth),
    adventurer(Race.HUMAN, ClassType.Fighter, ClassLevel.Fourth),
    archmage(Race.HUMAN, ClassType.Mystic, ClassLevel.Fourth),
    soultaker(Race.HUMAN, ClassType.Mystic, ClassLevel.Fourth),
    arcanaLord(Race.HUMAN, ClassType.Mystic, ClassLevel.Fourth),
    cardinal(Race.HUMAN, ClassType.Priest, ClassLevel.Fourth),
    hierophant(Race.HUMAN, ClassType.Priest, ClassLevel.Fourth),
    evaTemplar(Race.ELF, ClassType.Fighter, ClassLevel.Fourth),
    swordMuse(Race.ELF, ClassType.Fighter, ClassLevel.Fourth),
    windRider(Race.ELF, ClassType.Fighter, ClassLevel.Fourth),
    moonlightSentinel(Race.ELF, ClassType.Fighter, ClassLevel.Fourth),
    mysticMuse(Race.ELF, ClassType.Mystic, ClassLevel.Fourth),
    elementalMaster(Race.ELF, ClassType.Mystic, ClassLevel.Fourth),
    evaSaint(Race.ELF, ClassType.Priest, ClassLevel.Fourth),
    shillienTemplar(Race.DARK_ELF, ClassType.Fighter, ClassLevel.Fourth),
    spectralDancer(Race.DARK_ELF, ClassType.Fighter, ClassLevel.Fourth),
    ghostHunter(Race.DARK_ELF, ClassType.Fighter, ClassLevel.Fourth),
    ghostSentinel(Race.DARK_ELF, ClassType.Fighter, ClassLevel.Fourth),
    stormScreamer(Race.DARK_ELF, ClassType.Mystic, ClassLevel.Fourth),
    spectralMaster(Race.DARK_ELF, ClassType.Mystic, ClassLevel.Fourth),
    shillienSaint(Race.DARK_ELF, ClassType.Priest, ClassLevel.Fourth),
    titan(Race.ORC, ClassType.Fighter, ClassLevel.Fourth),
    grandKhavatari(Race.ORC, ClassType.Fighter, ClassLevel.Fourth),
    dominator(Race.ORC, ClassType.Mystic, ClassLevel.Fourth),
    doomcryer(Race.ORC, ClassType.Mystic, ClassLevel.Fourth),
    fortuneSeeker(Race.DWARF, ClassType.Fighter, ClassLevel.Fourth),
    maestro(Race.DWARF, ClassType.Fighter, ClassLevel.Fourth),
    dummyEntry31(null, null, null),
    dummyEntry32(null, null, null),
    dummyEntry33(null, null, null),
    dummyEntry34(null, null, null),
    maleSoldier(Race.KAMAEL, ClassType.Fighter, ClassLevel.First),
    femaleSoldier(Race.KAMAEL, ClassType.Fighter, ClassLevel.First),
    trooper(Race.KAMAEL, ClassType.Fighter, ClassLevel.Second),
    warder(Race.KAMAEL, ClassType.Fighter, ClassLevel.Second),
    berserker(Race.KAMAEL, ClassType.Fighter, ClassLevel.Third),
    maleSoulbreaker(Race.KAMAEL, ClassType.Fighter, ClassLevel.Third),
    femaleSoulbreaker(Race.KAMAEL, ClassType.Fighter, ClassLevel.Third),
    arbalester(Race.KAMAEL, ClassType.Fighter, ClassLevel.Third),
    doombringer(Race.KAMAEL, ClassType.Fighter, ClassLevel.Fourth),
    maleSoulhound(Race.KAMAEL, ClassType.Fighter, ClassLevel.Fourth),
    femaleSoulhound(Race.KAMAEL, ClassType.Fighter, ClassLevel.Fourth),
    trickster(Race.KAMAEL, ClassType.Fighter, ClassLevel.Fourth),
    inspector(Race.KAMAEL, ClassType.Fighter, ClassLevel.Third),
    judicator(Race.KAMAEL, ClassType.Fighter, ClassLevel.Fourth);

    private final Race _race;
    private final ClassLevel _level;
    private final ClassType _type;
    private static final Set<PlayerClass> mainSubclassSet;
    private static final Set<PlayerClass> neverSubclassed;
    private static final Set<PlayerClass> subclasseSet1;
    private static final Set<PlayerClass> subclasseSet2;
    private static final Set<PlayerClass> subclasseSet3;
    private static final Set<PlayerClass> subclasseSet4;
    private static final Set<PlayerClass> subclasseSet5;
    private static final EnumMap<PlayerClass, Set<PlayerClass>> subclassSetMap;

    private PlayerClass(Race race, ClassType pType, ClassLevel pLevel) {
        this._race = race;
        this._level = pLevel;
        this._type = pType;
    }

    public final Set<PlayerClass> getAvailableSubclasses(L2PcInstance player) {
        EnumSet<PlayerClass> subclasses = null;
        if (this._level == ClassLevel.Third) {
            if (player.getRace() != Race.KAMAEL) {
                subclasses = EnumSet.copyOf(mainSubclassSet);
                subclasses.remove((Object)this);
                switch (player.getRace()) {
                    case ELF: {
                        subclasses.removeAll(PlayerClass.getSet(Race.DARK_ELF, ClassLevel.Third));
                        break;
                    }
                    case DARK_ELF: {
                        subclasses.removeAll(PlayerClass.getSet(Race.ELF, ClassLevel.Third));
                    }
                }
                subclasses.removeAll(PlayerClass.getSet(Race.KAMAEL, ClassLevel.Third));
                Set<PlayerClass> unavailableClasses = subclassSetMap.get((Object)this);
                if (unavailableClasses != null) {
                    subclasses.removeAll(unavailableClasses);
                }
            } else {
                subclasses = PlayerClass.getSet(Race.KAMAEL, ClassLevel.Third);
                subclasses.remove((Object)this);
                if (Configuration.character().getMaxSubclass() <= 3) {
                    if (player.getAppearance().getSex()) {
                        subclasses.removeAll(EnumSet.of(femaleSoulbreaker));
                    } else {
                        subclasses.removeAll(EnumSet.of(maleSoulbreaker));
                    }
                }
                if (!player.getSubClasses().containsKey(2) || player.getSubClasses().get(2).getLevel() < 75) {
                    subclasses.removeAll(EnumSet.of(inspector));
                }
            }
        }
        return subclasses;
    }

    public static EnumSet<PlayerClass> getSet(Race race, ClassLevel level) {
        EnumSet<PlayerClass> allOf = EnumSet.noneOf(PlayerClass.class);
        for (PlayerClass playerClass : EnumSet.allOf(PlayerClass.class)) {
            if (race != null && !playerClass.isOfRace(race) || level != null && !playerClass.isOfLevel(level)) continue;
            allOf.add(playerClass);
        }
        return allOf;
    }

    public final boolean isOfRace(Race pRace) {
        return this._race == pRace;
    }

    public final boolean isOfType(ClassType pType) {
        return this._type == pType;
    }

    public final boolean isOfLevel(ClassLevel pLevel) {
        return this._level == pLevel;
    }

    public final ClassLevel getLevel() {
        return this._level;
    }

    static {
        neverSubclassed = EnumSet.of(Overlord, Warsmith);
        subclasseSet1 = EnumSet.of(DarkAvenger, Paladin, TempleKnight, ShillienKnight);
        subclasseSet2 = EnumSet.of(TreasureHunter, AbyssWalker, Plainswalker);
        subclasseSet3 = EnumSet.of(Hawkeye, SilverRanger, PhantomRanger);
        subclasseSet4 = EnumSet.of(Warlock, ElementalSummoner, PhantomSummoner);
        subclasseSet5 = EnumSet.of(Sorceror, Spellsinger, Spellhowler);
        subclassSetMap = new EnumMap(PlayerClass.class);
        EnumSet<PlayerClass> subclasses = PlayerClass.getSet(null, ClassLevel.Third);
        subclasses.removeAll(neverSubclassed);
        mainSubclassSet = subclasses;
        subclassSetMap.put(DarkAvenger, subclasseSet1);
        subclassSetMap.put(Paladin, subclasseSet1);
        subclassSetMap.put(TempleKnight, subclasseSet1);
        subclassSetMap.put(ShillienKnight, subclasseSet1);
        subclassSetMap.put(TreasureHunter, subclasseSet2);
        subclassSetMap.put(AbyssWalker, subclasseSet2);
        subclassSetMap.put(Plainswalker, subclasseSet2);
        subclassSetMap.put(Hawkeye, subclasseSet3);
        subclassSetMap.put(SilverRanger, subclasseSet3);
        subclassSetMap.put(PhantomRanger, subclasseSet3);
        subclassSetMap.put(Warlock, subclasseSet4);
        subclassSetMap.put(ElementalSummoner, subclasseSet4);
        subclassSetMap.put(PhantomSummoner, subclasseSet4);
        subclassSetMap.put(Sorceror, subclasseSet5);
        subclassSetMap.put(Spellsinger, subclasseSet5);
        subclassSetMap.put(Spellhowler, subclasseSet5);
    }
}

