/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;

public class ConditionOpResurrection
extends Condition {
    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        if (effected == null || !effected.isPlayer() && !effected.isPet() || !effected.isDead()) {
            return false;
        }
        if (effected.isResurrectionBlocked()) {
            effector.sendPacket(SystemMessageId.REJECT_RESURRECTION);
            return false;
        }
        L2PcInstance player = effected.getActingPlayer();
        if (effected.isPlayer() && player.isReviveRequested()) {
            effector.sendPacket(SystemMessageId.RES_HAS_ALREADY_BEEN_PROPOSED);
            return false;
        }
        if (effected.isPet() && player.isRevivingPet()) {
            effector.sendPacket(SystemMessageId.RES_HAS_ALREADY_BEEN_PROPOSED);
            return false;
        }
        if (player.isInsideZone(ZoneId.SIEGE) && !player.isInSiege()) {
            effector.sendPacket(SystemMessageId.CANNOT_BE_RESURRECTED_DURING_SIEGE);
            return false;
        }
        if (player.isFestivalParticipant()) {
            effector.sendMessage("You may not resurrect participants in a festival.");
            return false;
        }
        return true;
    }
}

