/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public class ConditionPlayerCanTakeCastle
extends Condition {
    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        if (effector == null || !effector.isPlayer()) {
            return false;
        }
        L2PcInstance player = effector.getActingPlayer();
        if (player.isAlikeDead() || player.isCursedWeaponEquipped() || !player.isClanLeader()) {
            return false;
        }
        Castle castle = CastleManager.getInstance().getCastle(player);
        if (castle == null || castle.getResidenceId() <= 0 || !castle.getSiege().isInProgress() || castle.getSiege().getAttackerClan(player.getClan()) == null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
            player.sendPacket(sm);
            return false;
        }
        if (!castle.getArtefacts().contains(effected)) {
            player.sendPacket(SystemMessageId.INCORRECT_TARGET);
            return false;
        }
        if (!Util.checkIfInRange(skill.getCastRange(), player, effected, true)) {
            player.sendPacket(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED);
            return false;
        }
        castle.getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.OPPONENT_STARTED_ENGRAVING), false);
        return true;
    }
}

