/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;

public class ConditionPlayerCanTransform
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanTransform(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        boolean canTransform = true;
        L2PcInstance player = effector.getActingPlayer();
        if (player == null || player.isAlikeDead() || player.isCursedWeaponEquipped()) {
            canTransform = false;
        } else if (player.isSitting()) {
            player.sendPacket(SystemMessageId.CANNOT_TRANSFORM_WHILE_SITTING);
            canTransform = false;
        } else if (player.isTransformed() || player.isInStance()) {
            player.sendPacket(SystemMessageId.YOU_ALREADY_POLYMORPHED_AND_CANNOT_POLYMORPH_AGAIN);
            canTransform = false;
        } else if (player.isInWater()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_POLYMORPH_INTO_THE_DESIRED_FORM_IN_WATER);
            canTransform = false;
        } else if (player.isFlyingMounted() || player.isMounted()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_POLYMORPH_WHILE_RIDING_A_PET);
            canTransform = false;
        }
        return this._val == canTransform;
    }
}

