/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import java.util.List;

public class ConditionPlayerHasPet
extends Condition {
    private final List<Integer> _controlItemIds;

    public ConditionPlayerHasPet(List<Integer> itemIds) {
        this._controlItemIds = itemIds.size() == 1 && itemIds.get(0) == 0 ? null : itemIds;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        if (effector.getActingPlayer() == null || !(effector.getActingPlayer().getSummon() instanceof L2PetInstance)) {
            return false;
        }
        if (this._controlItemIds == null) {
            return true;
        }
        L2ItemInstance controlItem = ((L2PetInstance)effector.getActingPlayer().getSummon()).getControlItem();
        return controlItem != null && this._controlItemIds.contains(controlItem.getId());
    }
}

