/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.util.Util;

public class ConditionPlayerRangeFromNpc
extends Condition {
    private final int[] _npcIds;
    private final int _radius;
    private final boolean _val;

    public ConditionPlayerRangeFromNpc(int[] npcIds, int radius, boolean val) {
        this._npcIds = npcIds;
        this._radius = radius;
        this._val = val;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        boolean existNpc = false;
        if (this._npcIds != null && this._npcIds.length > 0 && this._radius > 0) {
            for (L2Character target : effector.getKnownList().getKnownCharactersInRadius(this._radius)) {
                if (!target.isNpc() || !Util.contains(this._npcIds, target.getId())) continue;
                existNpc = true;
                break;
            }
        }
        return existNpc == this._val;
    }
}

