/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.drops.strategy.IAmountMultiplierStrategy;
import com.l2jserver.gameserver.model.drops.strategy.IChanceMultiplierStrategy;
import com.l2jserver.gameserver.model.drops.strategy.IDropCalculationStrategy;
import com.l2jserver.gameserver.model.drops.strategy.IKillerChanceModifierStrategy;
import com.l2jserver.gameserver.model.drops.strategy.INonGroupedKillerChanceModifierStrategy;
import com.l2jserver.gameserver.model.drops.strategy.IPreciseDeterminationStrategy;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import java.util.List;

public final class GeneralDropItem
implements IDropItem {
    private final int _itemId;
    private final long _min;
    private final long _max;
    private final double _chance;
    protected final IAmountMultiplierStrategy _amountStrategy;
    protected final IChanceMultiplierStrategy _chanceStrategy;
    protected final IPreciseDeterminationStrategy _preciseStrategy;
    protected final INonGroupedKillerChanceModifierStrategy _killerStrategy;
    protected final IDropCalculationStrategy _dropCalculationStrategy;

    public GeneralDropItem(int itemId, long min, long max, double chance) {
        this(itemId, min, max, chance, 1.0, 1.0);
    }

    public GeneralDropItem(int itemId, long min, long max, double chance, double defaultAmountMultiplier, double defaultChanceMultiplier) {
        this(itemId, min, max, defaultChanceMultiplier, IAmountMultiplierStrategy.DEFAULT_STRATEGY(defaultAmountMultiplier), IChanceMultiplierStrategy.DEFAULT_STRATEGY(defaultChanceMultiplier));
    }

    public GeneralDropItem(int itemId, long min, long max, double chance, IAmountMultiplierStrategy amountMultiplierStrategy, IChanceMultiplierStrategy chanceMultiplierStrategy) {
        this(itemId, min, max, chance, amountMultiplierStrategy, chanceMultiplierStrategy, IPreciseDeterminationStrategy.DEFAULT, IKillerChanceModifierStrategy.DEFAULT_NONGROUP_STRATEGY);
    }

    public GeneralDropItem(int itemId, long min, long max, double chance, IAmountMultiplierStrategy amountMultiplierStrategy, IChanceMultiplierStrategy chanceMultiplierStrategy, IPreciseDeterminationStrategy preciseStrategy, INonGroupedKillerChanceModifierStrategy killerStrategy) {
        this(itemId, min, max, chance, amountMultiplierStrategy, chanceMultiplierStrategy, preciseStrategy, killerStrategy, IDropCalculationStrategy.DEFAULT_STRATEGY);
    }

    public GeneralDropItem(int itemId, long min, long max, double chance, IAmountMultiplierStrategy amountMultiplierStrategy, IChanceMultiplierStrategy chanceMultiplierStrategy, IPreciseDeterminationStrategy preciseStrategy, INonGroupedKillerChanceModifierStrategy killerStrategy, IDropCalculationStrategy dropCalculationStrategy) {
        this._itemId = itemId;
        this._min = min;
        this._max = max;
        this._chance = chance;
        this._amountStrategy = amountMultiplierStrategy;
        this._chanceStrategy = chanceMultiplierStrategy;
        this._preciseStrategy = preciseStrategy;
        this._killerStrategy = killerStrategy;
        this._dropCalculationStrategy = dropCalculationStrategy;
    }

    public IAmountMultiplierStrategy getAmountStrategy() {
        return this._amountStrategy;
    }

    public IChanceMultiplierStrategy getChanceStrategy() {
        return this._chanceStrategy;
    }

    public IPreciseDeterminationStrategy getPreciseStrategy() {
        return this._preciseStrategy;
    }

    public INonGroupedKillerChanceModifierStrategy getKillerChanceModifierStrategy() {
        return this._killerStrategy;
    }

    public IDropCalculationStrategy getDropCalculationStrategy() {
        return this._dropCalculationStrategy;
    }

    public int getItemId() {
        return this._itemId;
    }

    public long getMin() {
        return this._min;
    }

    public long getMin(L2Character victim) {
        return (long)((double)this.getMin() * this.getAmountMultiplier(victim));
    }

    public long getMax() {
        return this._max;
    }

    public long getMax(L2Character victim) {
        return (long)((double)this.getMax() * this.getAmountMultiplier(victim));
    }

    public double getChance() {
        return this._chance;
    }

    public double getChance(L2Character victim) {
        return this.getChance() * this.getChanceMultiplier(victim);
    }

    public double getChance(L2Character victim, L2Character killer) {
        return this.getKillerChanceModifier(victim, killer) * this.getChance(victim);
    }

    @Override
    public List<ItemHolder> calculateDrops(L2Character victim, L2Character killer) {
        return this._dropCalculationStrategy.calculateDrops(this, victim, killer);
    }

    public boolean isPreciseCalculated() {
        return this._preciseStrategy.isPreciseCalculated(this);
    }

    protected double getKillerChanceModifier(L2Character victim, L2Character killer) {
        return this._killerStrategy.getKillerChanceModifier(this, victim, killer);
    }

    protected double getAmountMultiplier(L2Character victim) {
        return this._amountStrategy.getAmountMultiplier(this, victim);
    }

    protected double getChanceMultiplier(L2Character victim) {
        return this._chanceStrategy.getChanceMultiplier(this, victim);
    }
}

