/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.drops.strategy.IAmountMultiplierStrategy;
import com.l2jserver.gameserver.model.drops.strategy.IChanceMultiplierStrategy;
import com.l2jserver.gameserver.model.drops.strategy.IGroupedItemDropCalculationStrategy;
import com.l2jserver.gameserver.model.drops.strategy.IKillerChanceModifierStrategy;
import com.l2jserver.gameserver.model.drops.strategy.IPreciseDeterminationStrategy;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GroupedGeneralDropItem
implements IDropItem {
    private final double _chance;
    private List<GeneralDropItem> _items;
    protected final IGroupedItemDropCalculationStrategy _dropCalculationStrategy;
    protected final IKillerChanceModifierStrategy _killerChanceModifierStrategy;
    protected final IPreciseDeterminationStrategy _preciseStrategy;

    public GroupedGeneralDropItem(double chance) {
        this(chance, Configuration.general().preciseDropMultipleGroupRolls() ? IGroupedItemDropCalculationStrategy.PRECISE_MULTIPLE_GROUP_ROLLS : IGroupedItemDropCalculationStrategy.DEFAULT_STRATEGY, IKillerChanceModifierStrategy.DEFAULT_STRATEGY, IPreciseDeterminationStrategy.DEFAULT);
    }

    public GroupedGeneralDropItem(double chance, IGroupedItemDropCalculationStrategy dropStrategy, IKillerChanceModifierStrategy killerStrategy, IPreciseDeterminationStrategy preciseStrategy) {
        this._chance = chance;
        this._dropCalculationStrategy = dropStrategy;
        this._killerChanceModifierStrategy = killerStrategy;
        this._preciseStrategy = preciseStrategy;
    }

    public double getChance() {
        return this._chance;
    }

    public List<GeneralDropItem> getItems() {
        return this._items;
    }

    public IGroupedItemDropCalculationStrategy getDropCalculationStrategy() {
        return this._dropCalculationStrategy;
    }

    public IKillerChanceModifierStrategy getKillerChanceModifierStrategy() {
        return this._killerChanceModifierStrategy;
    }

    public IPreciseDeterminationStrategy getPreciseStrategy() {
        return this._preciseStrategy;
    }

    public void setItems(List<GeneralDropItem> items) {
        this._items = Collections.unmodifiableList(items);
    }

    public List<GeneralDropItem> extractMe() {
        ArrayList<GeneralDropItem> items = new ArrayList<GeneralDropItem>();
        for (GeneralDropItem item : this.getItems()) {
            items.add(new GeneralDropItem(item.getItemId(), item.getMin(), item.getMax(), item.getChance() * this.getChance() / 100.0, item.getAmountStrategy(), item.getChanceStrategy(), this.getPreciseStrategy(), this.getKillerChanceModifierStrategy(), item.getDropCalculationStrategy()));
        }
        return items;
    }

    public GroupedGeneralDropItem normalizeMe() {
        double sumchance = 0.0;
        for (GeneralDropItem item : this.getItems()) {
            sumchance += item.getChance() * this.getChance() / 100.0;
        }
        double sumchance1 = sumchance;
        GroupedGeneralDropItem group = new GroupedGeneralDropItem(sumchance1, this.getDropCalculationStrategy(), IKillerChanceModifierStrategy.NO_RULES, this.getPreciseStrategy());
        ArrayList<GeneralDropItem> items = new ArrayList<GeneralDropItem>();
        for (GeneralDropItem item : this.getItems()) {
            items.add(new GeneralDropItem(item.getItemId(), item.getMin(), item.getMax(), item.getChance() * this.getChance() / sumchance1, item.getAmountStrategy(), item.getChanceStrategy(), item.getPreciseStrategy(), item.getKillerChanceModifierStrategy(), item.getDropCalculationStrategy()));
        }
        group.setItems(items);
        return group;
    }

    public GroupedGeneralDropItem normalizeMe(L2Character victim, L2Character killer) {
        return this.normalizeMe(victim, killer, true, 1.0);
    }

    public GroupedGeneralDropItem normalizeMe(L2Character victim, L2Character killer, double chanceModifier) {
        return this.normalizeMe(victim, killer, true, chanceModifier);
    }

    public GroupedGeneralDropItem normalizeMe(L2Character victim) {
        return this.normalizeMe(victim, null, false, 1.0);
    }

    public GroupedGeneralDropItem normalizeMe(L2Character victim, double chanceModifier) {
        return this.normalizeMe(victim, null, false, chanceModifier);
    }

    private GroupedGeneralDropItem normalizeMe(L2Character victim, L2Character killer, boolean applyKillerModifier, double chanceModifier) {
        if (applyKillerModifier) {
            chanceModifier *= this.getKillerChanceModifier(victim, killer);
        }
        double sumchance = 0.0;
        for (GeneralDropItem item : this.getItems()) {
            sumchance += item.getChance(victim) * this.getChance() * chanceModifier / 100.0;
        }
        GroupedGeneralDropItem group = new GroupedGeneralDropItem(sumchance, this.getDropCalculationStrategy(), IKillerChanceModifierStrategy.NO_RULES, this.getPreciseStrategy());
        ArrayList<GeneralDropItem> items = new ArrayList<GeneralDropItem>();
        for (GeneralDropItem item : this.getItems()) {
            items.add(new GeneralDropItem(item.getItemId(), item.getMin(victim), item.getMax(victim), item.getChance(victim) * this.getChance() * chanceModifier / sumchance, IAmountMultiplierStrategy.STATIC, IChanceMultiplierStrategy.STATIC, this.getPreciseStrategy(), IKillerChanceModifierStrategy.NO_RULES, item.getDropCalculationStrategy()));
        }
        group.setItems(items);
        return group;
    }

    @Override
    public List<ItemHolder> calculateDrops(L2Character victim, L2Character killer) {
        return this._dropCalculationStrategy.calculateDrops(this, victim, killer);
    }

    public double getKillerChanceModifier(L2Character victim, L2Character killer) {
        return this._killerChanceModifierStrategy.getKillerChanceModifier(this, victim, killer);
    }

    public boolean isPreciseCalculated() {
        return this._preciseStrategy.isPreciseCalculated(this);
    }
}

