/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops.strategy;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;

public interface IAmountMultiplierStrategy {
    public static final IAmountMultiplierStrategy DROP = IAmountMultiplierStrategy.DEFAULT_STRATEGY(Configuration.rates().getDeathDropAmountMultiplier());
    public static final IAmountMultiplierStrategy SPOIL = IAmountMultiplierStrategy.DEFAULT_STRATEGY(Configuration.rates().getCorpseDropAmountMultiplier());
    public static final IAmountMultiplierStrategy STATIC = (item, victim) -> 1.0;
    public static final IAmountMultiplierStrategy QUEST = IAmountMultiplierStrategy.DEFAULT_STRATEGY(Configuration.rates().getQuestDropAmountMultiplier());

    public static IAmountMultiplierStrategy DEFAULT_STRATEGY(double defaultMultiplier) {
        return (item, victim) -> {
            Float dropAmountMultiplier;
            double multiplier = 1.0;
            if (victim.isChampion()) {
                multiplier *= item.getItemId() != 57 ? Configuration.customs().getChampionRewardsAmount() : Configuration.customs().getChampionAdenasRewardsAmount();
            }
            multiplier = (dropAmountMultiplier = Configuration.rates().getDropAmountMultiplierByItemId().get(item.getItemId())) != null ? (multiplier *= (double)dropAmountMultiplier.floatValue()) : (ItemTable.getInstance().getTemplate(item.getItemId()).hasExImmediateEffect() ? (multiplier *= Configuration.rates().getHerbDropAmountMultiplier()) : (victim.isRaid() ? (multiplier *= Configuration.rates().getRaidDropAmountMultiplier()) : (multiplier *= defaultMultiplier)));
            return multiplier;
        };
    }

    public double getAmountMultiplier(GeneralDropItem var1, L2Character var2);
}

