/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops.strategy;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;

public interface IChanceMultiplierStrategy {
    public static final IChanceMultiplierStrategy DROP = IChanceMultiplierStrategy.DEFAULT_STRATEGY(Configuration.rates().getDeathDropChanceMultiplier());
    public static final IChanceMultiplierStrategy SPOIL = IChanceMultiplierStrategy.DEFAULT_STRATEGY(Configuration.rates().getCorpseDropChanceMultiplier());
    public static final IChanceMultiplierStrategy STATIC = (item, victim) -> 1.0;
    public static final IChanceMultiplierStrategy QUEST = (item, victim) -> {
        double championmult = item.getItemId() == 57 || item.getItemId() == 5575 ? Configuration.customs().getChampionAdenasRewardsChance() : Configuration.customs().getChampionRewardsChance();
        return Configuration.customs().championEnable() && victim != null && victim.isChampion() ? (double)Configuration.rates().getQuestDropChanceMultiplier() * championmult : (double)Configuration.rates().getQuestDropChanceMultiplier();
    };

    public static IChanceMultiplierStrategy DEFAULT_STRATEGY(double defaultMultiplier) {
        return (item, victim) -> {
            Float dropChanceMultiplier;
            float multiplier = 1.0f;
            if (victim.isChampion()) {
                multiplier = (float)((double)multiplier * (item.getItemId() != 57 ? Configuration.customs().getChampionRewardsChance() : Configuration.customs().getChampionAdenasRewardsChance()));
            }
            multiplier = (dropChanceMultiplier = Configuration.rates().getDropChanceMultiplierByItemId().get(item.getItemId())) != null ? (multiplier *= dropChanceMultiplier.floatValue()) : (ItemTable.getInstance().getTemplate(item.getItemId()).hasExImmediateEffect() ? (float)((double)multiplier * Configuration.rates().getHerbDropChanceMultiplier()) : (victim.isRaid() ? (float)((double)multiplier * Configuration.rates().getRaidDropChanceMultiplier()) : (float)((double)multiplier * defaultMultiplier)));
            return multiplier;
        };
    }

    public double getChanceMultiplier(GeneralDropItem var1, L2Character var2);
}

