/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity.clanhall;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.instancemanager.ClanHallSiegeManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Siegable;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.entity.clanhall.SiegeStatus;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClanHallSiegeEngine
extends Quest
implements Siegable {
    public static final Logger _log = LoggerFactory.getLogger(ClanHallSiegeEngine.class);
    private static final String SQL_LOAD_ATTACKERS = "SELECT attacker_id FROM clanhall_siege_attackers WHERE clanhall_id = ?";
    private static final String SQL_SAVE_ATTACKERS = "INSERT INTO clanhall_siege_attackers VALUES (?,?)";
    private static final String SQL_LOAD_GUARDS = "SELECT * FROM clanhall_siege_guards WHERE clanHallId = ?";
    public static final int FORTRESS_RESSISTANCE = 21;
    public static final int DEVASTATED_CASTLE = 34;
    public static final int BANDIT_STRONGHOLD = 35;
    public static final int RAINBOW_SPRINGS = 62;
    public static final int BEAST_FARM = 63;
    public static final int FORTRESS_OF_DEAD = 64;
    private final Map<Integer, L2SiegeClan> _attackers = new ConcurrentHashMap<Integer, L2SiegeClan>();
    private List<L2Spawn> _guards;
    public SiegableHall _hall;
    public ScheduledFuture<?> _siegeTask;
    public boolean _missionAccomplished = false;

    public ClanHallSiegeEngine(String name, String descr, int hallId) {
        super(-1, name, descr);
        this._hall = ClanHallSiegeManager.getInstance().getSiegableHall(hallId);
        this._hall.setSiege(this);
        this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new PrepareOwner(), this._hall.getNextSiegeTime() - System.currentTimeMillis() - 3600000L);
        _log.info("{} siege scheduled for {}.", (Object)this._hall.getName(), (Object)this.getSiegeDate().getTime());
        this.loadAttackers();
    }

    public void loadAttackers() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SQL_LOAD_ATTACKERS);){
            ps.setInt(1, this._hall.getId());
            try (ResultSet rset = ps.executeQuery();){
                while (rset.next()) {
                    int id = rset.getInt("attacker_id");
                    L2SiegeClan clan = new L2SiegeClan(id, L2SiegeClan.SiegeClanType.ATTACKER);
                    this._attackers.put(id, clan);
                }
            }
        }
        catch (Exception e) {
            _log.warn("Could not load siege attackers!", e);
        }
    }

    public final void saveAttackers() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM clanhall_siege_attackers WHERE clanhall_id = ?");){
            ps.setInt(1, this._hall.getId());
            ps.execute();
            if (this._attackers.size() > 0) {
                try (PreparedStatement insert = con.prepareStatement(SQL_SAVE_ATTACKERS);){
                    for (L2SiegeClan clan : this._attackers.values()) {
                        insert.setInt(1, this._hall.getId());
                        insert.setInt(2, clan.getClanId());
                        insert.execute();
                        insert.clearParameters();
                    }
                }
            }
            _log.info("Successfully saved attackers to database.");
        }
        catch (Exception e) {
            _log.warn("Couldn't save attacker list!", e);
        }
    }

    public final void loadGuards() {
        if (this._guards == null) {
            this._guards = new ArrayList<L2Spawn>();
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement(SQL_LOAD_GUARDS);){
                ps.setInt(1, this._hall.getId());
                try (ResultSet rset = ps.executeQuery();){
                    while (rset.next()) {
                        L2Spawn spawn = new L2Spawn(rset.getInt("npcId"));
                        spawn.setX(rset.getInt("x"));
                        spawn.setY(rset.getInt("y"));
                        spawn.setZ(rset.getInt("z"));
                        spawn.setHeading(rset.getInt("heading"));
                        spawn.setRespawnDelay(rset.getInt("respawnDelay"));
                        spawn.setAmount(1);
                        this._guards.add(spawn);
                    }
                }
            }
            catch (Exception e) {
                _log.warn("Couldn't load siege guards!", e);
            }
        }
    }

    private void spawnSiegeGuards() {
        for (L2Spawn guard : this._guards) {
            guard.init();
        }
    }

    private void unSpawnSiegeGuards() {
        if (this._guards != null) {
            for (L2Spawn guard : this._guards) {
                guard.stopRespawn();
                if (guard.getLastSpawn() == null) continue;
                guard.getLastSpawn().deleteMe();
            }
        }
    }

    @Override
    public List<L2Npc> getFlag(L2Clan clan) {
        List<L2Npc> result = null;
        L2SiegeClan sClan = this.getAttackerClan(clan);
        if (sClan != null) {
            result = sClan.getFlag();
        }
        return result;
    }

    public final Map<Integer, L2SiegeClan> getAttackers() {
        return this._attackers;
    }

    @Override
    public boolean checkIsAttacker(L2Clan clan) {
        if (clan == null) {
            return false;
        }
        return this._attackers.containsKey(clan.getId());
    }

    @Override
    public boolean checkIsDefender(L2Clan clan) {
        return false;
    }

    @Override
    public L2SiegeClan getAttackerClan(int clanId) {
        return this._attackers.get(clanId);
    }

    @Override
    public L2SiegeClan getAttackerClan(L2Clan clan) {
        return this.getAttackerClan(clan.getId());
    }

    @Override
    public List<L2SiegeClan> getAttackerClans() {
        return new ArrayList<L2SiegeClan>(this._attackers.values());
    }

    @Override
    public List<L2PcInstance> getAttackersInZone() {
        ArrayList<L2PcInstance> attackers = new ArrayList<L2PcInstance>();
        for (L2PcInstance pc : this._hall.getSiegeZone().getPlayersInside()) {
            L2Clan clan = pc.getClan();
            if (clan == null || !this._attackers.containsKey(clan.getId())) continue;
            attackers.add(pc);
        }
        return attackers;
    }

    @Override
    public L2SiegeClan getDefenderClan(int clanId) {
        return null;
    }

    @Override
    public L2SiegeClan getDefenderClan(L2Clan clan) {
        return null;
    }

    @Override
    public List<L2SiegeClan> getDefenderClans() {
        return null;
    }

    public void prepareOwner() {
        if (this._hall.getOwnerId() > 0) {
            L2SiegeClan clan = new L2SiegeClan(this._hall.getOwnerId(), L2SiegeClan.SiegeClanType.ATTACKER);
            this._attackers.put(clan.getClanId(), new L2SiegeClan(clan.getClanId(), L2SiegeClan.SiegeClanType.ATTACKER));
        }
        this._hall.free();
        this._hall.banishForeigners();
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.REGISTRATION_TERM_FOR_S1_ENDED);
        msg.addString(this.getName());
        Broadcast.toAllOnlinePlayers(msg);
        this._hall.updateSiegeStatus(SiegeStatus.WAITING_BATTLE);
        this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new SiegeStarts(), 3600000L);
    }

    @Override
    public void startSiege() {
        if (this._attackers.size() < 1 && this._hall.getId() != 21) {
            this.onSiegeEnds();
            this._attackers.clear();
            this._hall.updateNextSiege();
            this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new PrepareOwner(), this._hall.getSiegeDate().getTimeInMillis());
            this._hall.updateSiegeStatus(SiegeStatus.WAITING_BATTLE);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_OF_S1_HAS_BEEN_CANCELED_DUE_TO_LACK_OF_INTEREST);
            sm.addString(this._hall.getName());
            Broadcast.toAllOnlinePlayers(sm);
            return;
        }
        this._hall.spawnDoor();
        this.loadGuards();
        this.spawnSiegeGuards();
        this._hall.updateSiegeZone(true);
        boolean state = true;
        for (L2SiegeClan sClan : this._attackers.values()) {
            L2Clan clan = ClanTable.getInstance().getClan(sClan.getClanId());
            if (clan == null) continue;
            for (L2PcInstance pc : clan.getOnlineMembers(0)) {
                pc.setSiegeState((byte)1);
                pc.broadcastUserInfo();
                pc.setIsInHideoutSiege(true);
            }
        }
        this._hall.updateSiegeStatus(SiegeStatus.RUNNING);
        this.onSiegeStarts();
        this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new SiegeEnds(), this._hall.getSiegeLength());
    }

    @Override
    public void endSiege() {
        SystemMessage end = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_OF_S1_HAS_ENDED);
        end.addString(this._hall.getName());
        Broadcast.toAllOnlinePlayers(end);
        L2Clan winner = this.getWinner();
        if (this._missionAccomplished && winner != null) {
            this._hall.setOwner(winner);
            winner.setHideoutId(this._hall.getId());
            finalMsg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_VICTORIOUS_OVER_S2_S_SIEGE);
            finalMsg.addString(winner.getName());
            finalMsg.addString(this._hall.getName());
            Broadcast.toAllOnlinePlayers(finalMsg);
        } else {
            finalMsg = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_S1_DRAW);
            finalMsg.addString(this._hall.getName());
            Broadcast.toAllOnlinePlayers(finalMsg);
        }
        this._missionAccomplished = false;
        this._hall.updateSiegeZone(false);
        this._hall.updateNextSiege();
        this._hall.spawnDoor(false);
        this._hall.banishForeigners();
        boolean state = false;
        for (L2SiegeClan sClan : this._attackers.values()) {
            L2Clan clan = ClanTable.getInstance().getClan(sClan.getClanId());
            if (clan == null) continue;
            for (L2PcInstance player : clan.getOnlineMembers(0)) {
                player.setSiegeState((byte)0);
                player.broadcastUserInfo();
                player.setIsInHideoutSiege(false);
            }
        }
        for (L2Character chr : this._hall.getSiegeZone().getCharactersInside()) {
            if (chr == null || !chr.isPlayer()) continue;
            chr.getActingPlayer().startPvPFlag();
        }
        this._attackers.clear();
        this.onSiegeEnds();
        this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new PrepareOwner(), this._hall.getNextSiegeTime() - System.currentTimeMillis() - 3600000L);
        _log.info("Siege of {} scheduled for {}.", (Object)this._hall.getName(), (Object)this._hall.getSiegeDate().getTime());
        this._hall.updateSiegeStatus(SiegeStatus.REGISTERING);
        this.unSpawnSiegeGuards();
    }

    @Override
    public void updateSiege() {
        this.cancelSiegeTask();
        this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new PrepareOwner(), this._hall.getNextSiegeTime() - 3600000L);
        _log.info("{} siege scheduled for {}.", (Object)this._hall.getName(), (Object)this._hall.getSiegeDate().getTime());
    }

    public void cancelSiegeTask() {
        if (this._siegeTask != null) {
            this._siegeTask.cancel(false);
        }
    }

    @Override
    public Calendar getSiegeDate() {
        return this._hall.getSiegeDate();
    }

    @Override
    public boolean giveFame() {
        return Configuration.clanhall().enableFame();
    }

    @Override
    public int getFameAmount() {
        return Configuration.clanhall().getFameAmount();
    }

    @Override
    public int getFameFrequency() {
        return Configuration.clanhall().getFameFrequency();
    }

    public final void broadcastNpcSay(L2Npc npc, int type, NpcStringId messageId) {
        NpcSay npcSay = new NpcSay(npc.getObjectId(), type, npc.getId(), messageId);
        int sourceRegion = MapRegionManager.getInstance().getMapRegionLocId(npc);
        for (L2PcInstance pc : L2World.getInstance().getPlayers()) {
            if (pc == null || MapRegionManager.getInstance().getMapRegionLocId(pc) != sourceRegion) continue;
            pc.sendPacket(npcSay);
        }
    }

    public Location getInnerSpawnLoc(L2PcInstance player) {
        return null;
    }

    public boolean canPlantFlag() {
        return true;
    }

    public boolean doorIsAutoAttackable() {
        return true;
    }

    public void onSiegeStarts() {
    }

    public void onSiegeEnds() {
    }

    public abstract L2Clan getWinner();

    public class PrepareOwner
    implements Runnable {
        @Override
        public void run() {
            ClanHallSiegeEngine.this.prepareOwner();
        }
    }

    public class SiegeStarts
    implements Runnable {
        @Override
        public void run() {
            ClanHallSiegeEngine.this.startSiege();
        }
    }

    public class SiegeEnds
    implements Runnable {
        @Override
        public void run() {
            ClanHallSiegeEngine.this.endSiege();
        }
    }
}

