/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.events;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.events.Containers;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.impl.BaseEvent;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.gameserver.model.events.returns.AbstractEventReturn;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(EventDispatcher.class);

    private EventDispatcher() {
    }

    public <T extends AbstractEventReturn> T notifyEvent(BaseEvent event) {
        return this.notifyEvent(event, null, null);
    }

    public <T extends AbstractEventReturn> T notifyEvent(BaseEvent event, Class<T> callbackClass) {
        return this.notifyEvent(event, null, callbackClass);
    }

    public <T extends AbstractEventReturn> T notifyEvent(BaseEvent event, ListenersContainer container) {
        return this.notifyEvent(event, container, null);
    }

    public <T extends AbstractEventReturn> T notifyEvent(BaseEvent event, ListenersContainer container, Class<T> callbackClass) {
        try {
            return Containers.Global().hasListener(event.getType()) || container != null && container.hasListener(event.getType()) ? (T)this.notifyEventImpl(event, container, callbackClass) : null;
        }
        catch (Exception e) {
            LOG.warn("Couldn't notify event {}", (Object)event.getClass().getSimpleName(), (Object)e);
            return null;
        }
    }

    public void notifyEventAsync(BaseEvent event, ListenersContainer ... containers) {
        if (event == null) {
            throw new NullPointerException("Event cannot be null!");
        }
        boolean hasListeners = Containers.Global().hasListener(event.getType());
        if (!hasListeners) {
            for (ListenersContainer container : containers) {
                if (!container.hasListener(event.getType())) continue;
                hasListeners = true;
                break;
            }
        }
        if (hasListeners) {
            ThreadPoolManager.getInstance().executeEvent(() -> this.notifyEventToMultipleContainers(event, containers, null));
        }
    }

    public void notifyEventAsyncDelayed(BaseEvent event, ListenersContainer container, long delay) {
        if (Containers.Global().hasListener(event.getType()) || container.hasListener(event.getType())) {
            ThreadPoolManager.getInstance().scheduleEvent(() -> this.notifyEvent(event, container, null), delay);
        }
    }

    public void notifyEventAsyncDelayed(BaseEvent event, ListenersContainer container, long delay, TimeUnit unit) {
        if (Containers.Global().hasListener(event.getType()) || container.hasListener(event.getType())) {
            ThreadPoolManager.getInstance().scheduleEvent(() -> this.notifyEvent(event, container, null), delay, unit);
        }
    }

    private <T extends AbstractEventReturn> T notifyEventToMultipleContainers(BaseEvent event, ListenersContainer[] containers, Class<T> callbackClass) {
        if (event == null) {
            throw new NullPointerException("Event cannot be null!");
        }
        try {
            AbstractEventReturn callback = null;
            if (containers != null) {
                for (ListenersContainer container : containers) {
                    if (callback != null && callback.abort()) continue;
                    callback = this.notifyToListeners(container.getListeners(event.getType()), event, callbackClass, callback);
                }
            }
            if (callback == null || !callback.abort()) {
                callback = this.notifyToListeners(Containers.Global().getListeners(event.getType()), event, callbackClass, callback);
            }
            return (T)callback;
        }
        catch (Exception e) {
            LOG.warn("Couldn't notify event {}", (Object)event.getClass().getSimpleName(), (Object)e);
            return null;
        }
    }

    private <T extends AbstractEventReturn> T notifyEventImpl(BaseEvent event, ListenersContainer container, Class<T> callbackClass) {
        if (event == null) {
            throw new NullPointerException("Event cannot be null!");
        }
        AbstractEventReturn callback = null;
        if (container != null) {
            callback = this.notifyToListeners(container.getListeners(event.getType()), event, callbackClass, callback);
        }
        if (callback == null || !callback.abort()) {
            callback = this.notifyToListeners(Containers.Global().getListeners(event.getType()), event, callbackClass, callback);
        }
        return (T)callback;
    }

    private <T extends AbstractEventReturn> T notifyToListeners(Queue<AbstractEventListener> listeners, BaseEvent event, Class<T> returnBackClass, T callback) {
        for (AbstractEventListener listener : listeners) {
            try {
                T rb = listener.executeEvent(event, returnBackClass);
                if (rb == null) continue;
                if (callback == null || ((AbstractEventReturn)rb).override()) {
                    callback = rb;
                    continue;
                }
                if (!((AbstractEventReturn)rb).abort()) continue;
                break;
            }
            catch (Exception e) {
                LOG.warn("Exception during notification of event: {} listener: {}", event.getClass().getSimpleName(), listener.getClass().getSimpleName(), e);
            }
        }
        return callback;
    }

    public static EventDispatcher getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EventDispatcher _instance = new EventDispatcher();

        private SingletonHolder() {
        }
    }
}

