/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.holders;

import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class PlayerEventHolder {
    private final L2PcInstance _player;
    private final String _name;
    private final String _title;
    private final int _clanId;
    private final Location _loc;
    private final int _pvpKills;
    private final int _pkKills;
    private final int _karma;
    private final List<L2PcInstance> _kills = new CopyOnWriteArrayList<L2PcInstance>();
    private boolean _sitForced;

    public PlayerEventHolder(L2PcInstance player) {
        this(player, false);
    }

    public PlayerEventHolder(L2PcInstance player, boolean sitForced) {
        this._player = player;
        this._name = player.getName();
        this._title = player.getTitle();
        this._clanId = player.getClanId();
        this._loc = new Location(player);
        this._pvpKills = player.getPvpKills();
        this._pkKills = player.getPkKills();
        this._karma = player.getKarma();
        this._sitForced = sitForced;
    }

    public void restorePlayerStats() {
        this._player.setName(this._name);
        this._player.setTitle(this._title);
        this._player.setClan(ClanTable.getInstance().getClan(this._clanId));
        this._player.teleToLocation((ILocational)this._loc, true);
        this._player.setPvpKills(this._pvpKills);
        this._player.setPkKills(this._pkKills);
        this._player.setKarma(this._karma);
    }

    public void setSitForced(boolean sitForced) {
        this._sitForced = sitForced;
    }

    public boolean isSitForced() {
        return this._sitForced;
    }

    public List<L2PcInstance> getKills() {
        return this._kills;
    }
}

