/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.EtcItemType;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Inventory
extends ItemContainer {
    private static final Logger LOG = LoggerFactory.getLogger(Inventory.class);
    public static final int ADENA_ID = 57;
    public static final int ANCIENT_ADENA_ID = 5575;
    public static final int PAPERDOLL_UNDER = 0;
    public static final int PAPERDOLL_HEAD = 1;
    public static final int PAPERDOLL_HAIR = 2;
    public static final int PAPERDOLL_HAIR2 = 3;
    public static final int PAPERDOLL_NECK = 4;
    public static final int PAPERDOLL_RHAND = 5;
    public static final int PAPERDOLL_CHEST = 6;
    public static final int PAPERDOLL_LHAND = 7;
    public static final int PAPERDOLL_REAR = 8;
    public static final int PAPERDOLL_LEAR = 9;
    public static final int PAPERDOLL_GLOVES = 10;
    public static final int PAPERDOLL_LEGS = 11;
    public static final int PAPERDOLL_FEET = 12;
    public static final int PAPERDOLL_RFINGER = 13;
    public static final int PAPERDOLL_LFINGER = 14;
    public static final int PAPERDOLL_LBRACELET = 15;
    public static final int PAPERDOLL_RBRACELET = 16;
    public static final int PAPERDOLL_DECO1 = 17;
    public static final int PAPERDOLL_DECO2 = 18;
    public static final int PAPERDOLL_DECO3 = 19;
    public static final int PAPERDOLL_DECO4 = 20;
    public static final int PAPERDOLL_DECO5 = 21;
    public static final int PAPERDOLL_DECO6 = 22;
    public static final int PAPERDOLL_CLOAK = 23;
    public static final int PAPERDOLL_BELT = 24;
    public static final int PAPERDOLL_TOTALSLOTS = 25;
    public static final double MAX_ARMOR_WEIGHT = 12000.0;
    private final L2ItemInstance[] _paperdoll = new L2ItemInstance[25];
    private final List<PaperdollListener> _paperdollListeners = new ArrayList<PaperdollListener>();
    protected int _totalWeight;
    private int _wearedMask;

    protected Inventory() {
        this.addPaperdollListener(StatsListener.getInstance());
    }

    protected abstract ItemLocation getEquipLocation();

    private ChangeRecorder newRecorder() {
        return new ChangeRecorder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance dropItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        if (item == null) {
            return null;
        }
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            if (!this._items.contains(item)) {
                return null;
            }
            this.removeItem(item);
            item.setOwnerId(process, 0, actor, reference);
            item.setItemLocation(ItemLocation.VOID);
            item.setLastChange(3);
            item.updateDatabase();
            this.refreshWeight();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance dropItem(String process, int objectId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByObjectId(objectId);
        if (item == null) {
            return null;
        }
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            if (!this._items.contains(item)) {
                return null;
            }
            if (item.getCount() > count) {
                item.changeCount(process, -count, actor, reference);
                item.setLastChange(2);
                item.updateDatabase();
                item = ItemTable.getInstance().createItem(process, item.getId(), count, actor, reference);
                item.updateDatabase();
                this.refreshWeight();
                return item;
            }
        }
        return this.dropItem(process, item, actor, reference);
    }

    @Override
    protected void addItem(L2ItemInstance item) {
        super.addItem(item);
        if (item.isEquipped()) {
            this.equipItem(item);
        }
    }

    @Override
    protected boolean removeItem(L2ItemInstance item) {
        for (int i = 0; i < this._paperdoll.length; ++i) {
            if (this._paperdoll[i] != item) continue;
            this.unEquipItemInSlot(i);
        }
        return super.removeItem(item);
    }

    public L2ItemInstance getPaperdollItem(int slot) {
        return this._paperdoll[slot];
    }

    public boolean isPaperdollSlotEmpty(int slot) {
        return this._paperdoll[slot] == null;
    }

    public static int getPaperdollIndex(int slot) {
        return switch (slot) {
            case 1 -> 0;
            case 2 -> 8;
            case 4, 6 -> 9;
            case 8 -> 4;
            case 16, 48 -> 13;
            case 32 -> 14;
            case 64 -> 1;
            case 128, 16384 -> 5;
            case 256 -> 7;
            case 512 -> 10;
            case 1024, 32768, 131072 -> 6;
            case 2048 -> 11;
            case 4096 -> 12;
            case 8192 -> 23;
            case 65536, 524288 -> 2;
            case 262144 -> 3;
            case 0x100000 -> 16;
            case 0x200000 -> 15;
            case 0x400000 -> 17;
            case 0x10000000 -> 24;
            default -> -1;
        };
    }

    public L2ItemInstance getPaperdollItemByL2ItemId(int slot) {
        int index = Inventory.getPaperdollIndex(slot);
        if (index == -1) {
            return null;
        }
        return this._paperdoll[index];
    }

    public int getPaperdollItemId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        if (item != null) {
            return item.getId();
        }
        return 0;
    }

    public int getPaperdollItemDisplayId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        return item != null ? item.getDisplayId() : 0;
    }

    public int getPaperdollAugmentationId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        return item != null && item.getAugmentation() != null ? item.getAugmentation().getAugmentationId() : 0;
    }

    public int getPaperdollObjectId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        return item != null ? item.getObjectId() : 0;
    }

    public synchronized void addPaperdollListener(PaperdollListener listener) {
        assert (!this._paperdollListeners.contains(listener));
        this._paperdollListeners.add(listener);
    }

    public synchronized void removePaperdollListener(PaperdollListener listener) {
        this._paperdollListeners.remove(listener);
    }

    public synchronized L2ItemInstance setPaperdollItem(int slot, L2ItemInstance item) {
        L2ItemInstance old = this._paperdoll[slot];
        if (old != item) {
            if (old != null) {
                this._paperdoll[slot] = null;
                old.setItemLocation(this.getBaseLocation());
                old.setLastChange(2);
                int mask = 0;
                for (int i = 0; i < 25; ++i) {
                    L2ItemInstance pi = this._paperdoll[i];
                    if (pi == null) continue;
                    mask |= pi.getItem().getItemMask();
                }
                this._wearedMask = mask;
                for (PaperdollListener listener : this._paperdollListeners) {
                    if (listener == null) continue;
                    listener.notifyUnequiped(slot, old, this);
                }
                old.updateDatabase();
            }
            if (item != null) {
                this._paperdoll[slot] = item;
                item.setItemLocation(this.getEquipLocation(), slot);
                item.setLastChange(2);
                this._wearedMask |= item.getItem().getItemMask();
                for (PaperdollListener listener : this._paperdollListeners) {
                    if (listener == null) continue;
                    listener.notifyEquiped(slot, item, this);
                }
                item.updateDatabase();
            }
        }
        return old;
    }

    public int getWearedMask() {
        return this._wearedMask;
    }

    public int getSlotFromItem(L2ItemInstance item) {
        int slot = -1;
        int location = item.getLocationSlot();
        switch (location) {
            case 0: {
                slot = 1;
                break;
            }
            case 9: {
                slot = 4;
                break;
            }
            case 8: {
                slot = 2;
                break;
            }
            case 4: {
                slot = 8;
                break;
            }
            case 13: {
                slot = 16;
                break;
            }
            case 14: {
                slot = 32;
                break;
            }
            case 2: {
                slot = 65536;
                break;
            }
            case 3: {
                slot = 262144;
                break;
            }
            case 1: {
                slot = 64;
                break;
            }
            case 5: {
                slot = 128;
                break;
            }
            case 7: {
                slot = 256;
                break;
            }
            case 10: {
                slot = 512;
                break;
            }
            case 6: {
                slot = item.getItem().getBodyPart();
                break;
            }
            case 11: {
                slot = 2048;
                break;
            }
            case 23: {
                slot = 8192;
                break;
            }
            case 12: {
                slot = 4096;
                break;
            }
            case 15: {
                slot = 0x200000;
                break;
            }
            case 16: {
                slot = 0x100000;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                slot = 0x400000;
                break;
            }
            case 24: {
                slot = 0x10000000;
            }
        }
        return slot;
    }

    public L2ItemInstance[] unEquipItemInBodySlotAndRecord(int slot) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.unEquipItemInBodySlot(slot);
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    public L2ItemInstance unEquipItemInSlot(int pdollSlot) {
        return this.setPaperdollItem(pdollSlot, null);
    }

    public L2ItemInstance[] unEquipItemInSlotAndRecord(int slot) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.unEquipItemInSlot(slot);
            if (this.getOwner() instanceof L2PcInstance) {
                ((L2PcInstance)this.getOwner()).refreshExpertisePenalty();
            }
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    public L2ItemInstance unEquipItemInBodySlot(int slot) {
        if (Configuration.general().debug()) {
            LOG.info("Unequip body slot: {}", (Object)slot);
        }
        int pdollSlot = -1;
        switch (slot) {
            case 4: {
                pdollSlot = 9;
                break;
            }
            case 2: {
                pdollSlot = 8;
                break;
            }
            case 8: {
                pdollSlot = 4;
                break;
            }
            case 16: {
                pdollSlot = 13;
                break;
            }
            case 32: {
                pdollSlot = 14;
                break;
            }
            case 65536: {
                pdollSlot = 2;
                break;
            }
            case 262144: {
                pdollSlot = 3;
                break;
            }
            case 524288: {
                this.setPaperdollItem(2, null);
                pdollSlot = 2;
                break;
            }
            case 64: {
                pdollSlot = 1;
                break;
            }
            case 128: 
            case 16384: {
                pdollSlot = 5;
                break;
            }
            case 256: {
                pdollSlot = 7;
                break;
            }
            case 512: {
                pdollSlot = 10;
                break;
            }
            case 1024: 
            case 32768: 
            case 131072: {
                pdollSlot = 6;
                break;
            }
            case 2048: {
                pdollSlot = 11;
                break;
            }
            case 8192: {
                pdollSlot = 23;
                break;
            }
            case 4096: {
                pdollSlot = 12;
                break;
            }
            case 1: {
                pdollSlot = 0;
                break;
            }
            case 0x200000: {
                pdollSlot = 15;
                break;
            }
            case 0x100000: {
                pdollSlot = 16;
                break;
            }
            case 0x400000: {
                pdollSlot = 17;
                break;
            }
            case 0x10000000: {
                pdollSlot = 24;
                break;
            }
            default: {
                LOG.info("Unhandled slot type: {}", (Object)slot);
                LOG.info(StringUtil.getTraceString(Thread.currentThread().getStackTrace()));
            }
        }
        if (pdollSlot >= 0) {
            L2ItemInstance old = this.setPaperdollItem(pdollSlot, null);
            if (old != null && this.getOwner() instanceof L2PcInstance) {
                ((L2PcInstance)this.getOwner()).refreshExpertisePenalty();
            }
            return old;
        }
        return null;
    }

    public L2ItemInstance[] equipItemAndRecord(L2ItemInstance item) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.equipItem(item);
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    public void equipItem(L2ItemInstance item) {
        L2PcInstance player;
        L2Character l2Character = this.getOwner();
        if (l2Character instanceof L2PcInstance && (player = (L2PcInstance)l2Character).getPrivateStoreType() != PrivateStoreType.NONE) {
            return;
        }
        l2Character = this.getOwner();
        if (l2Character instanceof L2PcInstance && !(player = (L2PcInstance)l2Character).canOverrideCond(PcCondOverride.ITEM_CONDITIONS) && !player.isHero() && item.isHeroItem()) {
            return;
        }
        int targetSlot = item.getItem().getBodyPart();
        L2ItemInstance formal = this.getPaperdollItem(6);
        if (item.getId() != 21163 && formal != null && formal.getItem().getBodyPart() == 131072) {
            switch (targetSlot) {
                case 64: 
                case 128: 
                case 256: 
                case 512: 
                case 2048: 
                case 4096: 
                case 16384: {
                    return;
                }
            }
        }
        switch (targetSlot) {
            case 16384: {
                this.setPaperdollItem(7, null);
                this.setPaperdollItem(5, item);
                break;
            }
            case 256: {
                L2ItemInstance rh = this.getPaperdollItem(5);
                if (!(rh == null || rh.getItem().getBodyPart() != 16384 || rh.getItemType() == WeaponType.BOW && item.getItemType() == EtcItemType.ARROW || rh.getItemType() == WeaponType.CROSSBOW && item.getItemType() == EtcItemType.BOLT || rh.getItemType() == WeaponType.FISHINGROD && item.getItemType() == EtcItemType.LURE)) {
                    this.setPaperdollItem(5, null);
                }
                this.setPaperdollItem(7, item);
                break;
            }
            case 128: {
                this.setPaperdollItem(5, item);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                if (this._paperdoll[9] == null) {
                    this.setPaperdollItem(9, item);
                    break;
                }
                if (this._paperdoll[8] == null) {
                    this.setPaperdollItem(8, item);
                    break;
                }
                this.setPaperdollItem(9, item);
                break;
            }
            case 16: 
            case 32: 
            case 48: {
                if (this._paperdoll[14] == null) {
                    this.setPaperdollItem(14, item);
                    break;
                }
                if (this._paperdoll[13] == null) {
                    this.setPaperdollItem(13, item);
                    break;
                }
                this.setPaperdollItem(14, item);
                break;
            }
            case 8: {
                this.setPaperdollItem(4, item);
                break;
            }
            case 32768: {
                this.setPaperdollItem(11, null);
                this.setPaperdollItem(6, item);
                break;
            }
            case 1024: {
                this.setPaperdollItem(6, item);
                break;
            }
            case 2048: {
                L2ItemInstance chest = this.getPaperdollItem(6);
                if (chest != null && chest.getItem().getBodyPart() == 32768) {
                    this.setPaperdollItem(6, null);
                }
                this.setPaperdollItem(11, item);
                break;
            }
            case 4096: {
                this.setPaperdollItem(12, item);
                break;
            }
            case 512: {
                this.setPaperdollItem(10, item);
                break;
            }
            case 64: {
                this.setPaperdollItem(1, item);
                break;
            }
            case 65536: {
                L2ItemInstance hair = this.getPaperdollItem(2);
                if (hair != null && hair.getItem().getBodyPart() == 524288) {
                    this.setPaperdollItem(3, null);
                } else {
                    this.setPaperdollItem(2, null);
                }
                this.setPaperdollItem(2, item);
                break;
            }
            case 262144: {
                L2ItemInstance hair2 = this.getPaperdollItem(2);
                if (hair2 != null && hair2.getItem().getBodyPart() == 524288) {
                    this.setPaperdollItem(2, null);
                } else {
                    this.setPaperdollItem(3, null);
                }
                this.setPaperdollItem(3, item);
                break;
            }
            case 524288: {
                this.setPaperdollItem(3, null);
                this.setPaperdollItem(2, item);
                break;
            }
            case 1: {
                this.setPaperdollItem(0, item);
                break;
            }
            case 8192: {
                this.setPaperdollItem(23, item);
                break;
            }
            case 0x200000: {
                this.setPaperdollItem(15, item);
                break;
            }
            case 0x100000: {
                this.setPaperdollItem(16, item);
                break;
            }
            case 0x400000: {
                this.equipTalisman(item);
                break;
            }
            case 0x10000000: {
                this.setPaperdollItem(24, item);
                break;
            }
            case 131072: {
                this.setPaperdollItem(11, null);
                this.setPaperdollItem(7, null);
                this.setPaperdollItem(5, null);
                this.setPaperdollItem(5, null);
                this.setPaperdollItem(7, null);
                this.setPaperdollItem(1, null);
                this.setPaperdollItem(12, null);
                this.setPaperdollItem(10, null);
                this.setPaperdollItem(6, item);
                break;
            }
            default: {
                LOG.warn("Unknown body slot {} for Item ID:{}", (Object)targetSlot, (Object)item.getId());
            }
        }
    }

    @Override
    protected void refreshWeight() {
        long weight = 0L;
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getItem() == null) continue;
            weight += (long)item.getItem().getWeight() * item.getCount();
        }
        this._totalWeight = (int)Math.min(weight, Integer.MAX_VALUE);
    }

    public int getTotalWeight() {
        return this._totalWeight;
    }

    public L2ItemInstance findArrowForBow(L2Item bow) {
        if (bow == null) {
            return null;
        }
        L2ItemInstance arrow = null;
        for (L2ItemInstance item : this.getItems()) {
            if (!item.isEtcItem() || item.getItem().getItemGradeSPlus() != bow.getItemGradeSPlus() || item.getEtcItem().getItemType() != EtcItemType.ARROW) continue;
            arrow = item;
            break;
        }
        return arrow;
    }

    public L2ItemInstance findBoltForCrossBow(L2Item crossbow) {
        L2ItemInstance bolt = null;
        for (L2ItemInstance item : this.getItems()) {
            if (!item.isEtcItem() || item.getItem().getItemGradeSPlus() != crossbow.getItemGradeSPlus() || item.getEtcItem().getItemType() != EtcItemType.BOLT) continue;
            bolt = item;
            break;
        }
        return bolt;
    }

    @Override
    public void restore() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT object_id, item_id, count, enchant_level, loc, loc_data, custom_type1, custom_type2, mana_left, time, agathion_energy FROM items WHERE owner_id=? AND (loc=? OR loc=?) ORDER BY loc_data");){
            ps.setInt(1, this.getOwnerId());
            ps.setString(2, this.getBaseLocation().name());
            ps.setString(3, this.getEquipLocation().name());
            try (ResultSet inv = ps.executeQuery();){
                while (inv.next()) {
                    L2PcInstance player;
                    L2ItemInstance item = L2ItemInstance.restoreFromDb(this.getOwnerId(), inv);
                    if (item == null) continue;
                    L2Character l2Character = this.getOwner();
                    if (l2Character instanceof L2PcInstance && !(player = (L2PcInstance)l2Character).canOverrideCond(PcCondOverride.ITEM_CONDITIONS) && !player.isHero() && item.isHeroItem()) {
                        item.setItemLocation(ItemLocation.INVENTORY);
                    }
                    L2World.getInstance().storeObject(item);
                    if (item.isStackable() && this.getItemByItemId(item.getId()) != null) {
                        this.addItem("Restore", item, this.getOwner().getActingPlayer(), null);
                        continue;
                    }
                    this.addItem(item);
                }
            }
            this.refreshWeight();
        }
        catch (Exception e) {
            LOG.warn("Could not restore inventory: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public int getTalismanSlots() {
        return this.getOwner().getActingPlayer().getStat().getTalismanSlots();
    }

    private void equipTalisman(L2ItemInstance item) {
        int i;
        if (this.getTalismanSlots() == 0) {
            return;
        }
        for (i = 17; i < 17 + this.getTalismanSlots(); ++i) {
            if (this._paperdoll[i] == null || this.getPaperdollItemId(i) != item.getId()) continue;
            this.setPaperdollItem(i, item);
            return;
        }
        for (i = 17; i < 17 + this.getTalismanSlots(); ++i) {
            if (this._paperdoll[i] != null) continue;
            this.setPaperdollItem(i, item);
            return;
        }
        this.setPaperdollItem(17, item);
    }

    public boolean canEquipCloak() {
        return this.getOwner().getActingPlayer().getStat().canEquipCloak();
    }

    public void reloadEquippedItems() {
        for (L2ItemInstance item : this._paperdoll) {
            if (item == null) continue;
            int slot = item.getLocationSlot();
            for (PaperdollListener listener : this._paperdollListeners) {
                if (listener == null) continue;
                listener.notifyUnequiped(slot, item, this);
                listener.notifyEquiped(slot, item, this);
            }
        }
    }

    private static final class StatsListener
    implements PaperdollListener {
        private static final StatsListener instance = new StatsListener();

        private StatsListener() {
        }

        public static StatsListener getInstance() {
            return instance;
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            inventory.getOwner().removeStatsOwner(item);
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
            inventory.getOwner().addStatFuncs(item.getStatFuncs(inventory.getOwner()));
        }
    }

    public static interface PaperdollListener {
        public void notifyEquiped(int var1, L2ItemInstance var2, Inventory var3);

        public void notifyUnequiped(int var1, L2ItemInstance var2, Inventory var3);
    }

    private static final class ChangeRecorder
    implements PaperdollListener {
        private final List<L2ItemInstance> _changed = new ArrayList<L2ItemInstance>();

        ChangeRecorder(Inventory inventory) {
            inventory.addPaperdollListener(this);
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
            if (!this._changed.contains(item)) {
                this._changed.add(item);
            }
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            if (!this._changed.contains(item)) {
                this._changed.add(item);
            }
        }

        public L2ItemInstance[] getChangedItems() {
            return this._changed.toArray(new L2ItemInstance[0]);
        }
    }
}

