/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mail
extends ItemContainer {
    private static final Logger LOG = LoggerFactory.getLogger(Mail.class);
    private final int _ownerId;
    private int _messageId;

    public Mail(int objectId, int messageId) {
        this._ownerId = objectId;
        this._messageId = messageId;
    }

    @Override
    public String getName() {
        return "Mail";
    }

    @Override
    public L2PcInstance getOwner() {
        return null;
    }

    @Override
    public ItemLocation getBaseLocation() {
        return ItemLocation.MAIL;
    }

    public int getMessageId() {
        return this._messageId;
    }

    public void setNewMessageId(int messageId) {
        this._messageId = messageId;
        for (L2ItemInstance item : this._items) {
            if (item == null) continue;
            item.setItemLocation(this.getBaseLocation(), messageId);
        }
        this.updateDatabase();
    }

    public void returnToWh(ItemContainer wh) {
        for (L2ItemInstance item : this._items) {
            if (item == null) continue;
            if (wh == null) {
                item.setItemLocation(ItemLocation.WAREHOUSE);
                continue;
            }
            this.transferItem("Expire", item.getObjectId(), item.getCount(), wh, null, null);
        }
    }

    @Override
    protected void addItem(L2ItemInstance item) {
        super.addItem(item);
        item.setItemLocation(this.getBaseLocation(), this._messageId);
    }

    @Override
    public void updateDatabase() {
        this._items.forEach(i -> i.updateDatabase(true));
    }

    @Override
    public void restore() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT object_id, item_id, count, enchant_level, loc, loc_data, custom_type1, custom_type2, mana_left, time, agathion_energy FROM items WHERE owner_id=? AND loc=? AND loc_data=?");){
            ps.setInt(1, this.getOwnerId());
            ps.setString(2, this.getBaseLocation().name());
            ps.setInt(3, this.getMessageId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    L2ItemInstance item = L2ItemInstance.restoreFromDb(this.getOwnerId(), rs);
                    if (item == null) continue;
                    L2World.getInstance().storeObject(item);
                    if (item.isStackable() && this.getItemByItemId(item.getId()) != null) {
                        this.addItem("Restore", item, null, null);
                        continue;
                    }
                    this.addItem(item);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not restore container:", e);
        }
    }

    @Override
    public int getOwnerId() {
        return this._ownerId;
    }

    @Override
    public void deleteMe() {
        this._items.forEach(i -> {
            i.updateDatabase(true);
            i.deleteMe();
            L2World.getInstance().removeObject((L2Object)i);
            IdFactory.getInstance().releaseId(i.getObjectId());
        });
        this._items.clear();
    }
}

