/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.ActionType;
import com.l2jserver.gameserver.model.items.type.CrystalType;
import com.l2jserver.gameserver.model.items.type.EtcItemType;
import com.l2jserver.gameserver.model.items.type.ItemType;
import com.l2jserver.gameserver.model.items.type.ItemType1;
import com.l2jserver.gameserver.model.items.type.ItemType2;
import com.l2jserver.gameserver.model.items.type.MaterialType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.functions.AbstractFunction;
import com.l2jserver.gameserver.model.stats.functions.FuncTemplate;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class L2Item
extends ListenersContainer
implements IIdentifiable {
    private static final Logger LOG = LoggerFactory.getLogger(L2Item.class);
    public static final int SLOT_NONE = 0;
    public static final int SLOT_UNDERWEAR = 1;
    public static final int SLOT_R_EAR = 2;
    public static final int SLOT_L_EAR = 4;
    public static final int SLOT_LR_EAR = 6;
    public static final int SLOT_NECK = 8;
    public static final int SLOT_R_FINGER = 16;
    public static final int SLOT_L_FINGER = 32;
    public static final int SLOT_LR_FINGER = 48;
    public static final int SLOT_HEAD = 64;
    public static final int SLOT_R_HAND = 128;
    public static final int SLOT_L_HAND = 256;
    public static final int SLOT_GLOVES = 512;
    public static final int SLOT_CHEST = 1024;
    public static final int SLOT_LEGS = 2048;
    public static final int SLOT_FEET = 4096;
    public static final int SLOT_BACK = 8192;
    public static final int SLOT_LR_HAND = 16384;
    public static final int SLOT_FULL_ARMOR = 32768;
    public static final int SLOT_HAIR = 65536;
    public static final int SLOT_ALLDRESS = 131072;
    public static final int SLOT_HAIR2 = 262144;
    public static final int SLOT_HAIRALL = 524288;
    public static final int SLOT_R_BRACELET = 0x100000;
    public static final int SLOT_L_BRACELET = 0x200000;
    public static final int SLOT_DECO = 0x400000;
    public static final int SLOT_BELT = 0x10000000;
    public static final int SLOT_WOLF = -100;
    public static final int SLOT_HATCHLING = -101;
    public static final int SLOT_STRIDER = -102;
    public static final int SLOT_BABYPET = -103;
    public static final int SLOT_GREATWOLF = -104;
    public static final int SLOT_MULTI_ALLWEAPON = 16512;
    private final int _itemId;
    private final int _displayId;
    private final String _name;
    private final String _icon;
    private final int _weight;
    private final boolean _stackable;
    private final MaterialType _materialType;
    private final CrystalType _crystalType;
    private final int _equipReuseDelay;
    private final int _duration;
    private final int _time;
    private final int _autoDestroyTime;
    private final int _bodyPart;
    private final int _referencePrice;
    private final int _crystalCount;
    private final boolean _sellable;
    private final boolean _droppable;
    private final boolean _destroyable;
    private final boolean _tradeable;
    private final boolean _depositable;
    private final int _enchantable;
    private final boolean _elementable;
    private final boolean _questItem;
    private final boolean _freightable;
    private final boolean _allow_self_resurrection;
    private final boolean _is_oly_restricted;
    private final boolean _for_npc;
    private final boolean _common;
    private final boolean _heroItem;
    private final boolean _pvpItem;
    private final boolean _immediate_effect;
    private final boolean _ex_immediate_effect;
    private final int _defaultEnchantLevel;
    private final ActionType _defaultAction;
    protected ItemType1 _type1;
    protected ItemType2 _type2;
    protected Elementals[] _elementals = null;
    protected List<FuncTemplate> _funcTemplates;
    protected List<Condition> _preConditions;
    private SkillHolder[] _skillHolder;
    private SkillHolder _unequipSkill = null;
    private final int _useSkillDisTime;
    private final int _reuseDelay;
    private final int _sharedReuseGroup;

    protected L2Item(StatsSet set) {
        String[] info;
        this._itemId = set.getInt("item_id");
        this._displayId = set.getInt("displayId", this._itemId);
        this._name = set.getString("name");
        this._icon = set.getString("icon", null);
        this._weight = set.getInt("weight", 0);
        this._materialType = set.getEnum("material", MaterialType.class, MaterialType.STEEL);
        this._equipReuseDelay = set.getInt("equip_reuse_delay", 0) * 1000;
        this._duration = set.getInt("duration", -1);
        this._time = set.getInt("time", -1);
        this._autoDestroyTime = set.getInt("auto_destroy_time", -1) * 1000;
        this._bodyPart = ItemTable.SLOTS.get(set.getString("bodypart", "none"));
        this._referencePrice = set.getInt("price", 0);
        this._crystalType = set.getEnum("crystal_type", CrystalType.class, CrystalType.NONE);
        this._crystalCount = set.getInt("crystal_count", 0);
        this._stackable = set.getBoolean("is_stackable", false);
        this._sellable = set.getBoolean("is_sellable", true);
        this._droppable = set.getBoolean("is_droppable", true);
        this._destroyable = set.getBoolean("is_destroyable", true);
        this._tradeable = set.getBoolean("is_tradable", true);
        this._depositable = set.getBoolean("is_depositable", true);
        this._elementable = set.getBoolean("element_enabled", false);
        this._enchantable = set.getInt("enchant_enabled", 0);
        this._questItem = set.getBoolean("is_questitem", false);
        this._freightable = set.getBoolean("is_freightable", false);
        this._allow_self_resurrection = set.getBoolean("allow_self_resurrection", false);
        this._is_oly_restricted = set.getBoolean("is_oly_restricted", false);
        this._for_npc = set.getBoolean("for_npc", false);
        this._immediate_effect = set.getBoolean("immediate_effect", false);
        this._ex_immediate_effect = set.getBoolean("ex_immediate_effect", false);
        this._defaultAction = set.getEnum("default_action", ActionType.class, ActionType.NONE);
        this._useSkillDisTime = set.getInt("useSkillDisTime", 0);
        this._defaultEnchantLevel = set.getInt("enchanted", 0);
        this._reuseDelay = set.getInt("reuse_delay", 0);
        this._sharedReuseGroup = set.getInt("shared_reuse_group", 0);
        String skills = set.getString("item_skill", null);
        if (skills != null) {
            String[] skillsSplit = skills.split(";");
            this._skillHolder = new SkillHolder[skillsSplit.length];
            int used = 0;
            for (String element : skillsSplit) {
                try {
                    String[] skillSplit = element.split("-");
                    int id = Integer.parseInt(skillSplit[0]);
                    int level = Integer.parseInt(skillSplit[1]);
                    if (id == 0) {
                        LOG.info("Ignoring item_skill({}) for item {}. Skill id is 0!", (Object)element, (Object)this);
                        continue;
                    }
                    if (level == 0) {
                        LOG.info("Ignoring item_skill({}) for item {}. Skill level is 0!", (Object)element, (Object)this);
                        continue;
                    }
                    this._skillHolder[used] = new SkillHolder(id, level);
                    ++used;
                }
                catch (Exception ex) {
                    LOG.warn("Failed to parse item_skill({}) for item {}! Format: SkillId0-SkillLevel0[;SkillIdN-SkillLevelN]", (Object)element, (Object)this);
                }
            }
            if (used != this._skillHolder.length) {
                SkillHolder[] skillHolder = new SkillHolder[used];
                System.arraycopy(this._skillHolder, 0, skillHolder, 0, used);
                this._skillHolder = skillHolder;
            }
        }
        if ((skills = set.getString("unequip_skill", null)) != null && (info = skills.split("-")).length == 2) {
            int id = 0;
            int level = 0;
            try {
                id = Integer.parseInt(info[0]);
                level = Integer.parseInt(info[1]);
            }
            catch (Exception nfe) {
                LOG.warn("Couldn't parse {} in weapon unequip skills! item {}!", (Object)skills, (Object)this);
            }
            if (id > 0 && level > 0) {
                this._unequipSkill = new SkillHolder(id, level);
            }
        }
        this._common = this._itemId >= 11605 && this._itemId <= 12361;
        this._heroItem = this._itemId >= 6611 && this._itemId <= 6621 || this._itemId >= 9388 && this._itemId <= 9390 || this._itemId == 6842;
        this._pvpItem = this._itemId >= 10667 && this._itemId <= 10835 || this._itemId >= 12852 && this._itemId <= 12977 || this._itemId >= 14363 && this._itemId <= 14525 || this._itemId == 14528 || this._itemId == 14529 || this._itemId == 14558 || this._itemId >= 15913 && this._itemId <= 16024 || this._itemId >= 16134 && this._itemId <= 16147 || this._itemId == 16149 || this._itemId == 16151 || this._itemId == 16153 || this._itemId == 16155 || this._itemId == 16157 || this._itemId == 16159 || this._itemId >= 16168 && this._itemId <= 16176 || this._itemId >= 16179 && this._itemId <= 16220;
    }

    public abstract ItemType getItemType();

    public boolean isMagicWeapon() {
        return false;
    }

    public int getEquipReuseDelay() {
        return this._equipReuseDelay;
    }

    public final int getDuration() {
        return this._duration;
    }

    public final int getTime() {
        return this._time;
    }

    public final int getAutoDestroyTime() {
        return this._autoDestroyTime;
    }

    @Override
    public final int getId() {
        return this._itemId;
    }

    public final int getDisplayId() {
        return this._displayId;
    }

    public abstract int getItemMask();

    public final MaterialType getMaterialType() {
        return this._materialType;
    }

    public final ItemType2 getType2() {
        return this._type2;
    }

    public final int getWeight() {
        return this._weight;
    }

    public final boolean isCrystallizable() {
        return this._crystalType != CrystalType.NONE && this._crystalCount > 0;
    }

    public final CrystalType getCrystalType() {
        return this._crystalType;
    }

    public final int getCrystalItemId() {
        return this._crystalType.getCrystalId();
    }

    public final CrystalType getItemGrade() {
        return this.getCrystalType();
    }

    public final CrystalType getItemGradeSPlus() {
        return switch (this.getItemGrade()) {
            case CrystalType.S80, CrystalType.S84 -> CrystalType.S;
            default -> this.getItemGrade();
        };
    }

    public final int getCrystalCount() {
        return this._crystalCount;
    }

    public final int getCrystalCount(int enchantLevel) {
        if (enchantLevel > 3) {
            return switch (this._type2) {
                case ItemType2.SHIELD_ARMOR, ItemType2.ACCESSORY -> this._crystalCount + this.getCrystalType().getCrystalEnchantBonusArmor() * (3 * enchantLevel - 6);
                case ItemType2.WEAPON -> this._crystalCount + this.getCrystalType().getCrystalEnchantBonusWeapon() * (2 * enchantLevel - 3);
                default -> this._crystalCount;
            };
        }
        if (enchantLevel > 0) {
            return switch (this._type2) {
                case ItemType2.SHIELD_ARMOR, ItemType2.ACCESSORY -> this._crystalCount + this.getCrystalType().getCrystalEnchantBonusArmor() * enchantLevel;
                case ItemType2.WEAPON -> this._crystalCount + this.getCrystalType().getCrystalEnchantBonusWeapon() * enchantLevel;
                default -> this._crystalCount;
            };
        }
        return this._crystalCount;
    }

    public final String getName() {
        return this._name;
    }

    public final Elementals[] getElementals() {
        return this._elementals;
    }

    public Elementals getElemental(byte attribute) {
        for (Elementals elm : this._elementals) {
            if (elm.getElement() != attribute) continue;
            return elm;
        }
        return null;
    }

    public void setElementals(Elementals element) {
        if (this._elementals == null) {
            this._elementals = new Elementals[1];
            this._elementals[0] = element;
        } else {
            Elementals elm = this.getElemental(element.getElement());
            if (elm != null) {
                elm.setValue(element.getValue());
            } else {
                elm = element;
                Elementals[] array = new Elementals[this._elementals.length + 1];
                System.arraycopy(this._elementals, 0, array, 0, this._elementals.length);
                array[this._elementals.length] = elm;
                this._elementals = array;
            }
        }
    }

    public final int getBodyPart() {
        return this._bodyPart;
    }

    public final ItemType1 getType1() {
        return this._type1;
    }

    public final boolean isStackable() {
        return this._stackable;
    }

    public boolean isEquipable() {
        return this.getBodyPart() != 0 && !(this.getItemType() instanceof EtcItemType);
    }

    public final int getReferencePrice() {
        return this._referencePrice;
    }

    public final boolean isSellable() {
        return this._sellable;
    }

    public final boolean isDroppable() {
        return this._droppable;
    }

    public final boolean isDestroyable() {
        return this._destroyable;
    }

    public final boolean isTradeable() {
        return this._tradeable;
    }

    public final boolean isDepositable() {
        return this._depositable;
    }

    public final int isEnchantable() {
        return Configuration.character().getEnchantBlacklist().contains(this.getId()) ? 0 : this._enchantable;
    }

    public final boolean isElementable() {
        return this._elementable;
    }

    public final boolean isCommon() {
        return this._common;
    }

    public final boolean isHeroItem() {
        return this._heroItem;
    }

    public final boolean isPvpItem() {
        return this._pvpItem;
    }

    public boolean isPotion() {
        return this.getItemType() == EtcItemType.POTION;
    }

    public boolean isElixir() {
        return this.getItemType() == EtcItemType.ELIXIR;
    }

    public boolean isScroll() {
        return this.getItemType() == EtcItemType.SCROLL;
    }

    public final List<AbstractFunction> getStatFuncs(L2ItemInstance item, L2Character player) {
        if (this._funcTemplates == null || this._funcTemplates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AbstractFunction> funcs = new ArrayList<AbstractFunction>(this._funcTemplates.size());
        for (FuncTemplate t : this._funcTemplates) {
            AbstractFunction f = t.getFunc(player, player, item, (Object)item);
            if (f == null) continue;
            funcs.add(f);
        }
        return funcs;
    }

    public void attach(FuncTemplate f) {
        switch (f.getStat()) {
            case FIRE_RES: 
            case FIRE_POWER: {
                this.setElementals(new Elementals(0, (int)f.getValue()));
                break;
            }
            case WATER_RES: 
            case WATER_POWER: {
                this.setElementals(new Elementals(1, (int)f.getValue()));
                break;
            }
            case WIND_RES: 
            case WIND_POWER: {
                this.setElementals(new Elementals(2, (int)f.getValue()));
                break;
            }
            case EARTH_RES: 
            case EARTH_POWER: {
                this.setElementals(new Elementals(3, (int)f.getValue()));
                break;
            }
            case HOLY_RES: 
            case HOLY_POWER: {
                this.setElementals(new Elementals(4, (int)f.getValue()));
                break;
            }
            case DARK_RES: 
            case DARK_POWER: {
                this.setElementals(new Elementals(5, (int)f.getValue()));
            }
        }
        if (this._funcTemplates == null) {
            this._funcTemplates = new ArrayList<FuncTemplate>(1);
        }
        this._funcTemplates.add(f);
    }

    public final void attach(Condition c) {
        if (this._preConditions == null) {
            this._preConditions = new ArrayList<Condition>(1);
        }
        if (!this._preConditions.contains(c)) {
            this._preConditions.add(c);
        }
    }

    public boolean hasSkills() {
        return this._skillHolder != null;
    }

    public final SkillHolder[] getSkills() {
        return this._skillHolder;
    }

    public final Skill getUnequipSkill() {
        return this._unequipSkill == null ? null : this._unequipSkill.getSkill();
    }

    public boolean checkCondition(L2Character activeChar, L2Object object, boolean sendMessage) {
        if (activeChar.canOverrideCond(PcCondOverride.ITEM_CONDITIONS) && !Configuration.general().gmItemRestriction()) {
            return true;
        }
        if ((this.isOlyRestrictedItem() || this.isHeroItem()) && activeChar instanceof L2PcInstance && activeChar.getActingPlayer().isInOlympiadMode()) {
            if (this.isEquipable()) {
                activeChar.sendPacket(SystemMessageId.THIS_ITEM_CANT_BE_EQUIPPED_FOR_THE_OLYMPIAD_EVENT);
            } else {
                activeChar.sendPacket(SystemMessageId.THIS_ITEM_IS_NOT_AVAILABLE_FOR_THE_OLYMPIAD_EVENT);
            }
            return false;
        }
        if (!this.isConditionAttached()) {
            return true;
        }
        L2Character target = object instanceof L2Character ? (L2Character)object : null;
        for (Condition preCondition : this._preConditions) {
            if (preCondition == null || preCondition.test(activeChar, target, null, null)) continue;
            if (activeChar instanceof L2Summon) {
                activeChar.sendPacket(SystemMessageId.PET_CANNOT_USE_ITEM);
                return false;
            }
            if (sendMessage) {
                String msg = preCondition.getMessage();
                int msgId = preCondition.getMessageId();
                if (msg != null) {
                    activeChar.sendMessage(msg);
                } else if (msgId != 0) {
                    SystemMessage sm = SystemMessage.getSystemMessage(msgId);
                    if (preCondition.isAddName()) {
                        sm.addItemName(this._itemId);
                    }
                    activeChar.sendPacket(sm);
                }
            }
            return false;
        }
        return true;
    }

    public boolean isConditionAttached() {
        return this._preConditions != null && !this._preConditions.isEmpty();
    }

    public boolean isQuestItem() {
        return this._questItem;
    }

    public boolean isFreightable() {
        return this._freightable;
    }

    public boolean isAllowSelfResurrection() {
        return this._allow_self_resurrection;
    }

    public boolean isOlyRestrictedItem() {
        return this._is_oly_restricted || Configuration.olympiad().getRestrictedItems().contains(this._itemId);
    }

    public boolean isForNpc() {
        return this._for_npc;
    }

    public String toString() {
        return this._name + "(" + this._itemId + ")";
    }

    public boolean hasExImmediateEffect() {
        return this._ex_immediate_effect;
    }

    public boolean hasImmediateEffect() {
        return this._immediate_effect;
    }

    public ActionType getDefaultAction() {
        return this._defaultAction;
    }

    public int useSkillDisTime() {
        return this._useSkillDisTime;
    }

    public int getReuseDelay() {
        return this._reuseDelay;
    }

    public int getSharedReuseGroup() {
        return this._sharedReuseGroup;
    }

    public String getIcon() {
        return this._icon;
    }

    public int getDefaultEnchantLevel() {
        return this._defaultEnchantLevel;
    }

    public boolean isPetItem() {
        return this.getItemType() == EtcItemType.PET_COLLAR;
    }

    public Skill getEnchant4Skill() {
        return null;
    }
}

