/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items.enchant;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.enchant.EnchantSupportItem;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.CrystalType;
import com.l2jserver.gameserver.model.items.type.EtcItemType;
import com.l2jserver.gameserver.model.items.type.ItemType;
import com.l2jserver.gameserver.model.items.type.ItemType2;
import com.l2jserver.gameserver.util.Util;

public abstract class AbstractEnchantItem {
    private static final ItemType[] ENCHANT_TYPES = new ItemType[]{EtcItemType.ANCIENT_CRYSTAL_ENCHANT_AM, EtcItemType.ANCIENT_CRYSTAL_ENCHANT_WP, EtcItemType.BLESS_SCRL_ENCHANT_AM, EtcItemType.BLESS_SCRL_ENCHANT_WP, EtcItemType.SCRL_ENCHANT_AM, EtcItemType.SCRL_ENCHANT_WP, EtcItemType.SCRL_INC_ENCHANT_PROP_AM, EtcItemType.SCRL_INC_ENCHANT_PROP_WP};
    private final int _id;
    private final CrystalType _grade;
    private final int _maxEnchantLevel;
    private final double _bonusRate;

    public AbstractEnchantItem(StatsSet set) {
        this._id = set.getInt("id");
        if (this.getItem() == null) {
            throw new NullPointerException();
        }
        if (!Util.contains(ENCHANT_TYPES, this.getItem().getItemType())) {
            throw new IllegalAccessError();
        }
        this._grade = set.getEnum("targetGrade", CrystalType.class, CrystalType.NONE);
        this._maxEnchantLevel = set.getInt("maxEnchant", 65535);
        this._bonusRate = set.getDouble("bonusRate", 0.0);
    }

    public final int getId() {
        return this._id;
    }

    public final double getBonusRate() {
        return this._bonusRate;
    }

    public final L2Item getItem() {
        return ItemTable.getInstance().getTemplate(this._id);
    }

    public final CrystalType getGrade() {
        return this._grade;
    }

    public abstract boolean isWeapon();

    public int getMaxEnchantLevel() {
        return this._maxEnchantLevel;
    }

    public boolean isValid(L2ItemInstance itemToEnchant, EnchantSupportItem supportItem) {
        if (itemToEnchant == null) {
            return false;
        }
        if (itemToEnchant.isEnchantable() == 0) {
            return false;
        }
        if (!this.isValidItemType(itemToEnchant.getItem().getType2())) {
            return false;
        }
        if (this._maxEnchantLevel != 0 && itemToEnchant.getEnchantLevel() > this._maxEnchantLevel) {
            return false;
        }
        return this._grade == itemToEnchant.getItem().getItemGradeSPlus();
    }

    private boolean isValidItemType(ItemType2 type2) {
        if (type2 == ItemType2.WEAPON) {
            return this.isWeapon();
        }
        if (type2 == ItemType2.SHIELD_ARMOR || type2 == ItemType2.ACCESSORY) {
            return !this.isWeapon();
        }
        return false;
    }
}

