/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.multisell;

import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.multisell.Entry;
import com.l2jserver.gameserver.model.multisell.Ingredient;
import com.l2jserver.gameserver.model.multisell.ItemInfo;
import java.util.ArrayList;

public class PreparedEntry
extends Entry {
    private long _taxAmount = 0L;

    public PreparedEntry(Entry template, L2ItemInstance item, boolean applyTaxes, boolean maintainEnchantment, double taxRate) {
        this._entryId = template.getEntryId() * 100000;
        if (maintainEnchantment && item != null) {
            this._entryId += item.getEnchantLevel();
        }
        ItemInfo info = null;
        long adenaAmount = 0L;
        this._ingredients = new ArrayList(template.getIngredients().size());
        for (Ingredient ing : template.getIngredients()) {
            Ingredient newIngredient;
            if (ing.getItemId() == 57) {
                if (ing.isTaxIngredient()) {
                    if (!applyTaxes) continue;
                    this._taxAmount += Math.round((double)ing.getItemCount() * taxRate);
                    continue;
                }
                adenaAmount += ing.getItemCount();
                continue;
            }
            if (maintainEnchantment && item != null && ing.isArmorOrWeapon()) {
                info = new ItemInfo(item);
                newIngredient = ing.getCopy();
                newIngredient.setItemInfo(info);
                this._ingredients.add(newIngredient);
                continue;
            }
            newIngredient = ing.getCopy();
            this._ingredients.add(newIngredient);
        }
        if ((adenaAmount += this._taxAmount) > 0L) {
            this._ingredients.add(new Ingredient(57, adenaAmount, false, false));
        }
        this._products = new ArrayList(template.getProducts().size());
        for (Ingredient ing : template.getProducts()) {
            if (!ing.isStackable()) {
                this._stackable = false;
            }
            Ingredient newProduct = ing.getCopy();
            if (maintainEnchantment && ing.isArmorOrWeapon()) {
                newProduct.setItemInfo(info);
            } else if (ing.isArmorOrWeapon() && ing.getTemplate().getDefaultEnchantLevel() > 0) {
                info = new ItemInfo(ing.getTemplate().getDefaultEnchantLevel());
                newProduct.setItemInfo(info);
            }
            this._products.add(newProduct);
        }
    }

    @Override
    public final long getTaxAmount() {
        return this._taxAmount;
    }
}

