/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.AbstractOlympiadGame;
import com.l2jserver.gameserver.model.olympiad.CompetitionType;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class OlympiadManager {
    private final List<Integer> _nonClassBasedRegisters = new CopyOnWriteArrayList<Integer>();
    private final Map<Integer, List<Integer>> _classBasedRegisters = new ConcurrentHashMap<Integer, List<Integer>>();
    private final List<List<Integer>> _teamsBasedRegisters = new CopyOnWriteArrayList<List<Integer>>();

    protected OlympiadManager() {
    }

    public static OlympiadManager getInstance() {
        return SingletonHolder._instance;
    }

    public final List<Integer> getRegisteredNonClassBased() {
        return this._nonClassBasedRegisters;
    }

    public final Map<Integer, List<Integer>> getRegisteredClassBased() {
        return this._classBasedRegisters;
    }

    public final List<List<Integer>> getRegisteredTeamsBased() {
        return this._teamsBasedRegisters;
    }

    protected final List<List<Integer>> hasEnoughRegisteredClassed() {
        CopyOnWriteArrayList<List<Integer>> result = null;
        for (Map.Entry<Integer, List<Integer>> classList : this._classBasedRegisters.entrySet()) {
            if (classList.getValue() == null || classList.getValue().size() < Configuration.olympiad().getClassedParticipants()) continue;
            if (result == null) {
                result = new CopyOnWriteArrayList<List<Integer>>();
            }
            result.add(classList.getValue());
        }
        return result;
    }

    protected final boolean hasEnoughRegisteredNonClassed() {
        return this._nonClassBasedRegisters.size() >= Configuration.olympiad().getNonClassedParticipants();
    }

    protected final boolean hasEnoughRegisteredTeams() {
        return this._teamsBasedRegisters.size() >= Configuration.olympiad().getTeamsParticipants();
    }

    protected final void clearRegistered() {
        this._nonClassBasedRegisters.clear();
        this._classBasedRegisters.clear();
        this._teamsBasedRegisters.clear();
        AntiFeedManager.getInstance().clear(1);
    }

    public final boolean isRegistered(L2PcInstance noble) {
        return this.isRegistered(noble, noble, false);
    }

    private boolean isRegistered(L2PcInstance noble, L2PcInstance player, boolean showMessage) {
        Integer objId = noble.getObjectId();
        for (List<Integer> team : this._teamsBasedRegisters) {
            if (team == null || !team.contains(objId)) continue;
            if (showMessage) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_NON_CLASS_LIMITED_EVENT_TEAMS);
                sm.addPcName(noble);
                player.sendPacket(sm);
            }
            return true;
        }
        if (this._nonClassBasedRegisters.contains(objId)) {
            if (showMessage) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_NON_CLASS_LIMITED_MATCH_WAITING_LIST);
                sm.addPcName(noble);
                player.sendPacket(sm);
            }
            return true;
        }
        List<Integer> classed = this._classBasedRegisters.get(noble.getBaseClass());
        if (classed != null && classed.contains(objId)) {
            if (showMessage) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_CLASS_MATCH_WAITING_LIST);
                sm.addPcName(noble);
                player.sendPacket(sm);
            }
            return true;
        }
        return false;
    }

    public final boolean isRegisteredInComp(L2PcInstance noble) {
        return this.isRegistered(noble, noble, false) || this.isInCompetition(noble, noble, false);
    }

    private boolean isInCompetition(L2PcInstance noble, L2PcInstance player, boolean showMessage) {
        if (!Olympiad.getInstance().inCompPeriod()) {
            return false;
        }
        int i = OlympiadGameManager.getInstance().getNumberOfStadiums();
        while (--i >= 0) {
            AbstractOlympiadGame game = OlympiadGameManager.getInstance().getOlympiadTask(i).getGame();
            if (game == null || !game.containsParticipant(noble.getObjectId())) continue;
            if (!showMessage) {
                return true;
            }
            switch (game.getType()) {
                case CLASSED: {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_CLASS_MATCH_WAITING_LIST);
                    sm.addPcName(noble);
                    player.sendPacket(sm);
                    break;
                }
                case NON_CLASSED: {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_NON_CLASS_LIMITED_MATCH_WAITING_LIST);
                    sm.addPcName(noble);
                    player.sendPacket(sm);
                    break;
                }
                case TEAMS: {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_NON_CLASS_LIMITED_EVENT_TEAMS);
                    sm.addPcName(noble);
                    player.sendPacket(sm);
                }
            }
            return true;
        }
        return false;
    }

    public final boolean registerNoble(L2PcInstance player, CompetitionType type) {
        if (!Olympiad.getInstance().inCompPeriod()) {
            player.sendPacket(SystemMessageId.THE_OLYMPIAD_GAME_IS_NOT_CURRENTLY_IN_PROGRESS);
            return false;
        }
        if (Olympiad.getInstance().getMillisToCompEnd() < 600000L) {
            player.sendPacket(SystemMessageId.GAME_REQUEST_CANNOT_BE_MADE);
            return false;
        }
        int charId = player.getObjectId();
        if (Olympiad.getInstance().getRemainingWeeklyMatches(charId) < 1) {
            player.sendPacket(SystemMessageId.MAX_OLY_WEEKLY_MATCHES_REACHED);
            return false;
        }
        switch (type) {
            case CLASSED: {
                if (!this.checkNoble(player, player)) {
                    return false;
                }
                if (Olympiad.getInstance().getRemainingWeeklyMatchesClassed(charId) < 1) {
                    player.sendPacket(SystemMessageId.MAX_OLY_WEEKLY_MATCHES_REACHED_60_NON_CLASSED_30_CLASSED_10_TEAM);
                    return false;
                }
                List<Integer> classed = this._classBasedRegisters.get(player.getBaseClass());
                if (classed != null) {
                    classed.add(charId);
                } else {
                    classed = new CopyOnWriteArrayList<Integer>();
                    classed.add(charId);
                    this._classBasedRegisters.put(player.getBaseClass(), classed);
                }
                player.sendPacket(SystemMessageId.YOU_HAVE_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_CLASSIFIED_GAMES);
                break;
            }
            case NON_CLASSED: {
                if (!this.checkNoble(player, player)) {
                    return false;
                }
                if (Olympiad.getInstance().getRemainingWeeklyMatchesNonClassed(charId) < 1) {
                    player.sendPacket(SystemMessageId.MAX_OLY_WEEKLY_MATCHES_REACHED_60_NON_CLASSED_30_CLASSED_10_TEAM);
                    return false;
                }
                this._nonClassBasedRegisters.add(charId);
                player.sendPacket(SystemMessageId.YOU_HAVE_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_NO_CLASS_GAMES);
                break;
            }
            case TEAMS: {
                L2Party party = player.getParty();
                if (party == null || party.getMemberCount() != 3) {
                    player.sendPacket(SystemMessageId.PARTY_REQUIREMENTS_NOT_MET);
                    return false;
                }
                if (!party.isLeader(player)) {
                    player.sendPacket(SystemMessageId.ONLY_PARTY_LEADER_CAN_REQUEST_TEAM_MATCH);
                    return false;
                }
                int teamPoints = 0;
                ArrayList<Integer> team = new ArrayList<Integer>(party.getMemberCount());
                for (L2PcInstance noble : party.getMembers()) {
                    if (!this.checkNoble(noble, player)) {
                        if (Configuration.customs().getDualboxCheckMaxOlympiadParticipantsPerIP() > 0) {
                            for (L2PcInstance unreg : party.getMembers()) {
                                if (unreg == noble) break;
                                AntiFeedManager.getInstance().removePlayer(1, unreg);
                            }
                        }
                        return false;
                    }
                    if (Olympiad.getInstance().getRemainingWeeklyMatchesTeam(noble.getObjectId()) < 1) {
                        player.sendPacket(SystemMessageId.MAX_OLY_WEEKLY_MATCHES_REACHED_60_NON_CLASSED_30_CLASSED_10_TEAM);
                        return false;
                    }
                    team.add(noble.getObjectId());
                    teamPoints += Olympiad.getInstance().getNoblePoints(noble.getObjectId());
                }
                if (teamPoints < 10) {
                    player.sendMessage("Your team must have at least 10 points in total.");
                    if (Configuration.customs().getDualboxCheckMaxOlympiadParticipantsPerIP() > 0) {
                        for (L2PcInstance unreg : party.getMembers()) {
                            AntiFeedManager.getInstance().removePlayer(1, unreg);
                        }
                    }
                    return false;
                }
                party.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_REGISTERED_IN_A_WAITING_LIST_OF_TEAM_GAMES));
                this._teamsBasedRegisters.add(team);
            }
        }
        return true;
    }

    public final boolean unRegisterNoble(L2PcInstance noble) {
        if (!Olympiad.getInstance().inCompPeriod()) {
            noble.sendPacket(SystemMessageId.THE_OLYMPIAD_GAME_IS_NOT_CURRENTLY_IN_PROGRESS);
            return false;
        }
        if (!noble.isNoble()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DOES_NOT_MEET_REQUIREMENTS_ONLY_NOBLESS_CAN_PARTICIPATE_IN_THE_OLYMPIAD);
            sm.addString(noble.getName());
            noble.sendPacket(sm);
            return false;
        }
        if (!this.isRegistered(noble, noble, false)) {
            noble.sendPacket(SystemMessageId.YOU_HAVE_NOT_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_A_GAME);
            return false;
        }
        if (this.isInCompetition(noble, noble, false)) {
            return false;
        }
        Integer objId = noble.getObjectId();
        if (this._nonClassBasedRegisters.remove(objId)) {
            if (Configuration.customs().getDualboxCheckMaxOlympiadParticipantsPerIP() > 0) {
                AntiFeedManager.getInstance().removePlayer(1, noble);
            }
            noble.sendPacket(SystemMessageId.YOU_HAVE_BEEN_DELETED_FROM_THE_WAITING_LIST_OF_A_GAME);
            return true;
        }
        List<Integer> classed = this._classBasedRegisters.get(noble.getBaseClass());
        if (classed != null && classed.remove(objId)) {
            this._classBasedRegisters.put(noble.getBaseClass(), classed);
            if (Configuration.customs().getDualboxCheckMaxOlympiadParticipantsPerIP() > 0) {
                AntiFeedManager.getInstance().removePlayer(1, noble);
            }
            noble.sendPacket(SystemMessageId.YOU_HAVE_BEEN_DELETED_FROM_THE_WAITING_LIST_OF_A_GAME);
            return true;
        }
        for (List<Integer> team : this._teamsBasedRegisters) {
            if (team == null || !team.contains(objId)) continue;
            this._teamsBasedRegisters.remove(team);
            ThreadPoolManager.getInstance().executeGeneral(new AnnounceUnregToTeam(team));
            return true;
        }
        return false;
    }

    public final void removeDisconnectedCompetitor(L2PcInstance player) {
        Integer objId;
        OlympiadGameTask task = OlympiadGameManager.getInstance().getOlympiadTask(player.getOlympiadGameId());
        if (task != null && task.isGameStarted()) {
            task.getGame().handleDisconnect(player);
        }
        if (this._nonClassBasedRegisters.remove(objId = Integer.valueOf(player.getObjectId()))) {
            return;
        }
        List<Integer> classed = this._classBasedRegisters.get(player.getBaseClass());
        if (classed != null && classed.remove(objId)) {
            return;
        }
        for (List<Integer> team : this._teamsBasedRegisters) {
            if (team == null || !team.contains(objId)) continue;
            this._teamsBasedRegisters.remove(team);
            ThreadPoolManager.getInstance().executeGeneral(new AnnounceUnregToTeam(team));
            return;
        }
    }

    private boolean checkNoble(L2PcInstance noble, L2PcInstance player) {
        int points;
        if (!noble.isNoble()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DOES_NOT_MEET_REQUIREMENTS_ONLY_NOBLESS_CAN_PARTICIPATE_IN_THE_OLYMPIAD);
            sm.addPcName(noble);
            player.sendPacket(sm);
            return false;
        }
        if (noble.isSubClassActive()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CANT_JOIN_THE_OLYMPIAD_WITH_A_SUB_CLASS_CHARACTER);
            sm.addPcName(noble);
            player.sendPacket(sm);
            return false;
        }
        if (noble.isCursedWeaponEquipped()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CANNOT_JOIN_OLYMPIAD_POSSESSING_S2);
            sm.addPcName(noble);
            sm.addItemName(noble.getCursedWeaponEquippedId());
            player.sendPacket(sm);
            return false;
        }
        if (!noble.isInventoryUnder90(true)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_INVENTORY_SLOT_EXCEEDS_80_PERCENT);
            sm.addPcName(noble);
            player.sendPacket(sm);
            return false;
        }
        int charId = noble.getObjectId();
        if (noble.isOnEvent()) {
            player.sendMessage("You can't join olympiad while participating on TvT Event.");
            return false;
        }
        if (this.isRegistered(noble, player, true)) {
            return false;
        }
        if (this.isInCompetition(noble, player, true)) {
            return false;
        }
        StatsSet statDat = Olympiad.getNobleStats(charId);
        if (statDat == null) {
            statDat = new StatsSet();
            statDat.set("class_id", noble.getBaseClass());
            statDat.set("char_name", noble.getName());
            statDat.set("olympiad_points", Configuration.olympiad().getStartPoints());
            statDat.set("competitions_done", 0);
            statDat.set("competitions_won", 0);
            statDat.set("competitions_lost", 0);
            statDat.set("competitions_drawn", 0);
            statDat.set("competitions_done_week", 0);
            statDat.set("competitions_done_week_classed", 0);
            statDat.set("competitions_done_week_non_classed", 0);
            statDat.set("competitions_done_week_team", 0);
            statDat.set("to_save", true);
            Olympiad.addNobleStats(charId, statDat);
        }
        if ((points = Olympiad.getInstance().getNoblePoints(charId)) <= 0) {
            NpcHtmlMessage message = new NpcHtmlMessage(player.getLastHtmlActionOriginId());
            message.setFile(player.getHtmlPrefix(), "data/html/olympiad/noble_nopoints1.htm");
            message.replace("%objectId%", String.valueOf(noble.getLastHtmlActionOriginId()));
            player.sendPacket(message);
            return false;
        }
        if (Configuration.customs().getDualboxCheckMaxOlympiadParticipantsPerIP() > 0 && !AntiFeedManager.getInstance().tryAddPlayer(1, noble, Configuration.customs().getDualboxCheckMaxOlympiadParticipantsPerIP())) {
            NpcHtmlMessage message = new NpcHtmlMessage(player.getLastHtmlActionOriginId());
            message.setFile(player.getHtmlPrefix(), "data/html/mods/OlympiadIPRestriction.htm");
            message.replace("%max%", String.valueOf(AntiFeedManager.getInstance().getLimit(player, Configuration.customs().getDualboxCheckMaxOlympiadParticipantsPerIP())));
            player.sendPacket(message);
            return false;
        }
        return true;
    }

    public int getCountOpponents() {
        return this._nonClassBasedRegisters.size() + this._classBasedRegisters.size() + this._teamsBasedRegisters.size();
    }

    private static class SingletonHolder {
        protected static final OlympiadManager _instance = new OlympiadManager();

        private SingletonHolder() {
        }
    }

    private static final class AnnounceUnregToTeam
    implements Runnable {
        private final List<Integer> _team;

        public AnnounceUnregToTeam(List<Integer> t) {
            this._team = t;
        }

        @Override
        public void run() {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_BEEN_DELETED_FROM_THE_WAITING_LIST_OF_A_GAME);
            for (int objectId : this._team) {
                L2PcInstance teamMember = L2World.getInstance().getPlayer(objectId);
                if (teamMember == null) continue;
                teamMember.sendPacket(sm);
                if (Configuration.customs().getDualboxCheckMaxOlympiadParticipantsPerIP() <= 0) continue;
                AntiFeedManager.getInstance().removePlayer(1, teamMember);
            }
        }
    }
}

