/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.options;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.options.OptionsSkillHolder;
import com.l2jserver.gameserver.model.options.OptionsSkillType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.functions.AbstractFunction;
import com.l2jserver.gameserver.model.stats.functions.FuncTemplate;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Options {
    private final int _id;
    private final List<FuncTemplate> _funcs = new ArrayList<FuncTemplate>();
    private SkillHolder _activeSkill = null;
    private SkillHolder _passiveSkill = null;
    private final List<OptionsSkillHolder> _activationSkills = new ArrayList<OptionsSkillHolder>();

    public Options(int id) {
        this._id = id;
    }

    public final int getId() {
        return this._id;
    }

    public boolean hasFuncs() {
        return !this._funcs.isEmpty();
    }

    public List<AbstractFunction> getStatFuncs(L2ItemInstance item, L2Character player) {
        if (this._funcs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AbstractFunction> funcs = new ArrayList<AbstractFunction>(this._funcs.size());
        for (FuncTemplate fuctionTemplate : this._funcs) {
            AbstractFunction fuction = fuctionTemplate.getFunc(player, player, item, (Object)this);
            if (fuction != null) {
                funcs.add(fuction);
            }
            player.sendDebugMessage("Adding stats: " + String.valueOf((Object)fuctionTemplate.getStat()) + " val: " + fuctionTemplate.getValue());
        }
        return funcs;
    }

    public void addFunc(FuncTemplate template) {
        this._funcs.add(template);
    }

    public boolean hasActiveSkill() {
        return this._activeSkill != null;
    }

    public SkillHolder getActiveSkill() {
        return this._activeSkill;
    }

    public void setActiveSkill(SkillHolder holder) {
        this._activeSkill = holder;
    }

    public boolean hasPassiveSkill() {
        return this._passiveSkill != null;
    }

    public SkillHolder getPassiveSkill() {
        return this._passiveSkill;
    }

    public void setPassiveSkill(SkillHolder holder) {
        this._passiveSkill = holder;
    }

    public boolean hasActivationSkills() {
        return !this._activationSkills.isEmpty();
    }

    public boolean hasActivationSkills(OptionsSkillType type) {
        for (OptionsSkillHolder holder : this._activationSkills) {
            if (holder.getSkillType() != type) continue;
            return true;
        }
        return false;
    }

    public List<OptionsSkillHolder> getActivationsSkills() {
        return this._activationSkills;
    }

    public List<OptionsSkillHolder> getActivationsSkills(OptionsSkillType type) {
        ArrayList<OptionsSkillHolder> temp = new ArrayList<OptionsSkillHolder>();
        for (OptionsSkillHolder holder : this._activationSkills) {
            if (holder.getSkillType() != type) continue;
            temp.add(holder);
        }
        return temp;
    }

    public void addActivationSkill(OptionsSkillHolder holder) {
        this._activationSkills.add(holder);
    }

    public void apply(L2PcInstance player) {
        player.sendDebugMessage("Activating option id: " + this._id);
        if (this.hasFuncs()) {
            player.addStatFuncs(this.getStatFuncs(null, player));
        }
        if (this.hasActiveSkill()) {
            this.addSkill(player, this.getActiveSkill().getSkill());
            player.sendDebugMessage("Adding active skill: " + String.valueOf(this.getActiveSkill()));
        }
        if (this.hasPassiveSkill()) {
            this.addSkill(player, this.getPassiveSkill().getSkill());
            player.sendDebugMessage("Adding passive skill: " + String.valueOf(this.getPassiveSkill()));
        }
        if (this.hasActivationSkills()) {
            for (OptionsSkillHolder holder : this._activationSkills) {
                player.addTriggerSkill(holder);
                player.sendDebugMessage("Adding trigger skill: " + String.valueOf(holder));
            }
        }
        player.sendSkillList();
    }

    public void remove(L2PcInstance player) {
        player.sendDebugMessage("Deactivating option id: " + this._id);
        if (this.hasFuncs()) {
            player.removeStatsOwner(this);
        }
        if (this.hasActiveSkill()) {
            player.removeSkill(this.getActiveSkill().getSkill(), false, false);
            player.sendDebugMessage("Removing active skill: " + String.valueOf(this.getActiveSkill()));
        }
        if (this.hasPassiveSkill()) {
            player.removeSkill(this.getPassiveSkill().getSkill(), false, true);
            player.sendDebugMessage("Removing passive skill: " + String.valueOf(this.getPassiveSkill()));
        }
        if (this.hasActivationSkills()) {
            for (OptionsSkillHolder holder : this._activationSkills) {
                player.removeTriggerSkill(holder);
                player.sendDebugMessage("Removing trigger skill: " + String.valueOf(holder));
            }
        }
        player.sendSkillList();
    }

    private void addSkill(L2PcInstance player, Skill skill) {
        boolean updateTimeStamp = false;
        player.addSkill(skill, false);
        if (skill.isActive()) {
            long remainingTime = player.getSkillRemainingReuseTime(skill.getReuseHashCode());
            if (remainingTime > 0L) {
                player.addTimeStamp(skill, remainingTime);
                player.disableSkill(skill, remainingTime);
            }
            updateTimeStamp = true;
        }
        if (updateTimeStamp) {
            player.sendPacket(new SkillCoolTime(player));
        }
    }
}

