/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.quest;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.CategoryType;
import com.l2jserver.gameserver.enums.Race;
import com.l2jserver.gameserver.enums.audio.IAudio;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.events.AbstractScript;
import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.ListenerRegisterType;
import com.l2jserver.gameserver.model.events.impl.BaseEvent;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcEventReceived;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcFirstTalk;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcSkillFinished;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.AttackableAggroRangeEnter;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.AttackableHate;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.FactionCall;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerLearnSkillRequested;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerMenuSelected;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerOneSkillSelected;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerQuestAccepted;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSkillLearned;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSummonSpawn;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSummonTalk;
import com.l2jserver.gameserver.model.events.impl.character.trap.OnTrapAction;
import com.l2jserver.gameserver.model.events.impl.item.ItemBypass;
import com.l2jserver.gameserver.model.events.impl.item.ItemTalk;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.olympiad.CompetitionType;
import com.l2jserver.gameserver.model.olympiad.Participant;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.QuestTimer;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.NpcQuestHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.TutorialShowHtml;
import com.l2jserver.gameserver.scripting.ScriptManager;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quest
extends AbstractScript
implements IIdentifiable {
    private static final Logger LOG = LoggerFactory.getLogger(Quest.class);
    private volatile Map<String, List<QuestTimer>> _questTimers = null;
    private final ReentrantReadWriteLock _rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock _writeLock = this._rwLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock _readLock = this._rwLock.readLock();
    private volatile Map<Predicate<L2PcInstance>, String> _startCondition = null;
    private final int _questId;
    private final String _name;
    private final String _description;
    private final byte _initialState = 0;
    protected boolean _onEnterWorld = false;
    private boolean _isCustom = false;
    private int[] _questItemIds = null;
    private static final String DEFAULT_NO_QUEST_MSG = "<html><body>You are either not on a quest that involves this NPC, or you don't meet this NPC's minimum quest requirements.</body></html>";
    private static final String DEFAULT_ALREADY_COMPLETED_MSG = "<html><body>This quest has already been completed.</body></html>";
    private static final String QUEST_DELETE_FROM_CHAR_QUERY = "DELETE FROM character_quests WHERE charId=? AND name=?";
    private static final String QUEST_DELETE_FROM_CHAR_QUERY_NON_REPEATABLE_QUERY = "DELETE FROM character_quests WHERE charId=? AND name=? AND var!=?";
    private static final int RESET_HOUR = 6;
    private static final int RESET_MINUTES = 30;

    public Quest(int questId, String name, String description) {
        this._questId = questId;
        this._name = name;
        this._description = description;
        if (questId > 0) {
            QuestManager.getInstance().addQuest(this);
        } else {
            QuestManager.getInstance().addScript(this);
        }
        this.loadGlobalData();
    }

    public int getResetHour() {
        return 6;
    }

    public int getResetMinutes() {
        return 30;
    }

    protected void loadGlobalData() {
    }

    public void saveGlobalData() {
    }

    @Override
    public int getId() {
        return this._questId;
    }

    public QuestState newQuestState(L2PcInstance player) {
        return new QuestState(this, player, 0);
    }

    public QuestState getQuestState(L2PcInstance player, boolean initIfNone) {
        QuestState qs = player.getQuestState(this._name);
        if (qs != null || !initIfNone) {
            return qs;
        }
        return this.newQuestState(player);
    }

    public byte getInitialState() {
        return 0;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getDescr() {
        return this._description;
    }

    public void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player) {
        this.startQuestTimer(name, time, npc, player, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, List<QuestTimer>> getQuestTimers() {
        if (this._questTimers == null) {
            Quest quest = this;
            synchronized (quest) {
                if (this._questTimers == null) {
                    this._questTimers = new ConcurrentHashMap<String, List<QuestTimer>>(1);
                }
            }
        }
        return this._questTimers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player, boolean repeating) {
        List timers = this.getQuestTimers().computeIfAbsent(name, k -> new ArrayList(1));
        if (this.getQuestTimer(name, npc, player) == null) {
            this._writeLock.lock();
            try {
                timers.add(new QuestTimer(this, name, time, npc, player, repeating));
            }
            finally {
                this._writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuestTimer getQuestTimer(String name, L2Npc npc, L2PcInstance player) {
        if (this._questTimers == null) {
            return null;
        }
        List<QuestTimer> timers = this.getQuestTimers().get(name);
        if (timers != null) {
            this._readLock.lock();
            try {
                for (QuestTimer timer : timers) {
                    if (timer == null || !timer.isMatch(this, name, npc, player)) continue;
                    QuestTimer questTimer = timer;
                    return questTimer;
                }
            }
            finally {
                this._readLock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuestTimers(String name) {
        if (this._questTimers == null) {
            return;
        }
        List<QuestTimer> timers = this.getQuestTimers().get(name);
        if (timers != null) {
            this._writeLock.lock();
            try {
                for (QuestTimer timer : timers) {
                    if (timer == null) continue;
                    timer.cancel();
                }
                timers.clear();
            }
            finally {
                this._writeLock.unlock();
            }
        }
    }

    public void cancelQuestTimer(String name, L2Npc npc, L2PcInstance player) {
        QuestTimer timer = this.getQuestTimer(name, npc, player);
        if (timer != null) {
            timer.cancelAndRemove();
        }
    }

    public void removeQuestTimer(QuestTimer timer) {
        List<QuestTimer> timers;
        if (timer != null && this._questTimers != null && (timers = this.getQuestTimers().get(timer.getName())) != null) {
            this._writeLock.lock();
            try {
                timers.remove(timer);
            }
            finally {
                this._writeLock.unlock();
            }
        }
    }

    public final void notifyEvent(String event, L2Npc npc, L2PcInstance player) {
        try {
            String result = this.onEvent(event, npc, player);
            this.showResult(player, result, npc);
        }
        catch (Exception ex) {
            this.showError(player, ex);
        }
    }

    public final void notifyTalk(L2Npc npc, L2PcInstance player) {
        try {
            String startConditionHtml = this.getStartConditionHtml(player);
            String result = !player.hasQuestState(this._name) && startConditionHtml != null ? startConditionHtml : this.onTalk(npc, player);
            player.setLastQuestNpcObject(npc.getObjectId());
            this.showResult(player, result, npc);
        }
        catch (Exception ex) {
            this.showError(player, ex);
        }
    }

    public final void notifyFirstTalk(L2Npc npc, L2PcInstance player) {
        try {
            String result = this.onFirstTalk(npc, player);
            this.showResult(player, result, npc);
        }
        catch (Exception ex) {
            this.showError(player, ex);
        }
    }

    public final void notifyItemTalk(L2ItemInstance item, L2PcInstance player) {
        try {
            String result = this.onItemTalk(item, player);
            this.showResult(player, result);
        }
        catch (Exception ex) {
            this.showError(player, ex);
        }
    }

    public void onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon) {
    }

    public void onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon, Skill skill) {
        this.onAttack(npc, attacker, damage, isSummon);
    }

    public void onDeath(L2Character killer, L2Character victim, QuestState qs) {
        this.onEvent("", killer instanceof L2Npc ? (L2Npc)killer : null, qs.getPlayer());
    }

    public String onEvent(String event, L2Npc npc, L2PcInstance player) {
        return null;
    }

    public void onKill(L2Npc npc, L2PcInstance player, boolean isSummon) {
    }

    public String onTalk(L2Npc npc, L2PcInstance talker) {
        return null;
    }

    public String onFirstTalk(L2Npc npc, L2PcInstance player) {
        return null;
    }

    public String onItemTalk(L2ItemInstance item, L2PcInstance player) {
        return null;
    }

    public void onItemEvent(ItemBypass event) {
    }

    public void onMenuSelected(PlayerMenuSelected event) {
    }

    public void onQuestAccepted(PlayerQuestAccepted event) {
    }

    public void onLearnSkillRequested(PlayerLearnSkillRequested event) {
    }

    public void onOneSkillSelected(PlayerOneSkillSelected event) {
    }

    public void onSkillLearned(PlayerSkillLearned event) {
    }

    public void onItemUse(L2Item item, L2PcInstance player) {
    }

    public void onSkillSee(L2Npc npc, L2PcInstance caster, Skill skill, List<L2Object> targets, boolean isSummon) {
    }

    public void onSpellFinished(NpcSkillFinished event) {
    }

    public void onTrapAction(OnTrapAction event) {
    }

    public void onSpawn(L2Npc npc) {
    }

    protected void onTeleport(L2Npc npc) {
    }

    public void onFactionCall(FactionCall event) {
    }

    public void onAggroRangeEnter(AttackableAggroRangeEnter event) {
    }

    public void onSeeCreature(L2Npc npc, L2Character creature) {
    }

    public void onEnterWorld(L2PcInstance player) {
    }

    public void onTutorialEvent(L2PcInstance player, String command) {
    }

    public void onTutorialClientEvent(L2PcInstance player, int event) {
    }

    public void onTutorialQuestionMark(L2PcInstance player, int number) {
    }

    public void onTutorialCmd(L2PcInstance player, String command) {
    }

    public void onEnterZone(L2Character creature, L2ZoneType zoneType) {
    }

    public void onExitZone(L2Character creature, L2ZoneType zoneType) {
    }

    public void onEventReceived(NpcEventReceived event) {
    }

    public void onOlympiadMatchFinish(Participant winner, Participant loser, CompetitionType type) {
    }

    public void onOlympiadLose(L2PcInstance loser, CompetitionType type) {
    }

    public void onMoveFinished(L2Npc npc) {
    }

    public void onNodeArrived(L2Npc npc) {
    }

    public void onRouteFinished(L2Npc npc) {
    }

    public boolean onNpcHate(L2Attackable mob, L2PcInstance player, boolean isSummon) {
        return true;
    }

    public void onSummonSpawn(L2Summon summon) {
    }

    public void onSummonTalk(L2Summon summon) {
    }

    public boolean onCanSeeMe(L2Npc npc, L2PcInstance player) {
        return false;
    }

    public boolean showError(L2PcInstance player, Throwable t) {
        LOG.warn("There has been an error on the script!", t);
        if (t.getMessage() == null) {
            LOG.warn(t.getMessage());
        }
        if (player != null && player.getAccessLevel().isGm()) {
            String result = "<html><body><title>Script error</title>" + com.l2jserver.commons.util.Util.getStackTrace((Throwable)t) + "</body></html>";
            return this.showResult(player, result);
        }
        return false;
    }

    public boolean showResult(L2PcInstance player, String res) {
        return this.showResult(player, res, null);
    }

    public boolean showResult(L2PcInstance player, String res, L2Npc npc) {
        if (res == null || res.isEmpty() || player == null) {
            return true;
        }
        if (res.endsWith(".htm") || res.endsWith(".html")) {
            this.showHtmlFile(player, res, npc);
        } else if (res.startsWith("<html")) {
            NpcHtmlMessage npcReply = new NpcHtmlMessage(npc != null ? npc.getObjectId() : 0, res);
            npcReply.replace("%playername%", player.getName());
            player.sendPacket(npcReply);
            player.sendPacket(ActionFailed.STATIC_PACKET);
        } else {
            player.sendMessage(res);
        }
        return false;
    }

    public static void playerEnter(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement invalidQuestData = con.prepareStatement("DELETE FROM character_quests WHERE charId = ? AND name = ?");
             PreparedStatement invalidQuestDataVar = con.prepareStatement("DELETE FROM character_quests WHERE charId = ? AND name = ? AND var = ?");
             PreparedStatement ps1 = con.prepareStatement("SELECT name, value FROM character_quests WHERE charId = ? AND var = ?");){
            ps1.setInt(1, player.getObjectId());
            ps1.setString(2, "<state>");
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String questId = rs.getString("name");
                    String statename = rs.getString("value");
                    Quest q = QuestManager.getInstance().getQuest(questId);
                    if (q == null) {
                        LOG.warn("Unknown quest {} for player {}!", (Object)questId, (Object)player.getName());
                        if (!Configuration.general().autoDeleteInvalidQuestData()) continue;
                        invalidQuestData.setInt(1, player.getObjectId());
                        invalidQuestData.setString(2, questId);
                        invalidQuestData.executeUpdate();
                        continue;
                    }
                    new QuestState(q, player, State.getStateId(statename));
                }
            }
            try (PreparedStatement ps2 = con.prepareStatement("SELECT name, var, value FROM character_quests WHERE charId = ? AND var <> ?");){
                ps2.setInt(1, player.getObjectId());
                ps2.setString(2, "<state>");
                try (ResultSet rs = ps2.executeQuery();){
                    while (rs.next()) {
                        String questId = rs.getString("name");
                        String var = rs.getString("var");
                        String value = rs.getString("value");
                        QuestState qs = player.getQuestState(questId);
                        if (qs == null) {
                            LOG.warn("Lost variable {} in quest {} for player {}!", var, questId, player.getName());
                            if (!Configuration.general().autoDeleteInvalidQuestData()) continue;
                            invalidQuestDataVar.setInt(1, player.getObjectId());
                            invalidQuestDataVar.setString(2, questId);
                            invalidQuestDataVar.setString(3, var);
                            invalidQuestDataVar.executeUpdate();
                            continue;
                        }
                        qs.setInternal(var, value);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not insert char quest!", ex);
        }
        for (String name : QuestManager.getInstance().getScripts().keySet()) {
            player.processQuestEvent(name, "enter");
        }
    }

    public final void saveGlobalQuestVar(String var, String value) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("REPLACE INTO quest_global_data (quest_name,var,value) VALUES (?,?,?)");){
            ps.setString(1, this.getName());
            ps.setString(2, var);
            ps.setString(3, value);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Could not insert global quest variable!", ex);
        }
    }

    public final String loadGlobalQuestVar(String var) {
        String result = "";
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT value FROM quest_global_data WHERE quest_name = ? AND var = ?");){
            ps.setString(1, this.getName());
            ps.setString(2, var);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getString(1);
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not load global quest variable!", ex);
        }
        return result;
    }

    public final void deleteGlobalQuestVar(String var) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM quest_global_data WHERE quest_name = ? AND var = ?");){
            ps.setString(1, this.getName());
            ps.setString(2, var);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Could not delete global quest variable!", ex);
        }
    }

    public final void deleteAllGlobalQuestVars() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM quest_global_data WHERE quest_name = ?");){
            ps.setString(1, this.getName());
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Could not delete global quest variables!", ex);
        }
    }

    public static void createQuestVarInDb(QuestState qs, String var, String value) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO character_quests (charId,name,var,value) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE value=?");){
            ps.setInt(1, qs.getPlayer().getObjectId());
            ps.setString(2, qs.getQuestName());
            ps.setString(3, var);
            ps.setString(4, value);
            ps.setString(5, value);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Could not insert char quest!", ex);
        }
    }

    public static void updateQuestVarInDb(QuestState qs, String var, String value) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE character_quests SET value=? WHERE charId=? AND name=? AND var = ?");){
            ps.setString(1, value);
            ps.setInt(2, qs.getPlayer().getObjectId());
            ps.setString(3, qs.getQuestName());
            ps.setString(4, var);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Could not update char quest!", ex);
        }
    }

    public static void deleteQuestVarInDb(QuestState qs, String var) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM character_quests WHERE charId=? AND name=? AND var=?");){
            ps.setInt(1, qs.getPlayer().getObjectId());
            ps.setString(2, qs.getQuestName());
            ps.setString(3, var);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Could not delete char quest!", ex);
        }
    }

    public static void deleteQuestInDb(QuestState qs, boolean repeatable) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(repeatable ? QUEST_DELETE_FROM_CHAR_QUERY : QUEST_DELETE_FROM_CHAR_QUERY_NON_REPEATABLE_QUERY);){
            ps.setInt(1, qs.getPlayer().getObjectId());
            ps.setString(2, qs.getQuestName());
            if (!repeatable) {
                ps.setString(3, "<state>");
            }
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Unable to delete char quest!", ex);
        }
    }

    public static void createQuestInDb(QuestState qs) {
        Quest.createQuestVarInDb(qs, "<state>", State.getStateName(qs.getState()));
    }

    public static void updateQuestInDb(QuestState qs) {
        Quest.updateQuestVarInDb(qs, "<state>", State.getStateName(qs.getState()));
    }

    public static String getNoQuestMsg(L2PcInstance player) {
        String result = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/noquest.htm");
        if (result != null && result.length() > 0) {
            return result;
        }
        return DEFAULT_NO_QUEST_MSG;
    }

    public static String getAlreadyCompletedMsg(L2PcInstance player) {
        String result = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/alreadycompleted.htm");
        if (result != null && !result.isEmpty()) {
            return result;
        }
        return DEFAULT_ALREADY_COMPLETED_MSG;
    }

    public void bindStartNpc(int ... npcIds) {
        this.setNpcQuestStartId(npcIds);
    }

    public void bindStartNpc(Collection<Integer> npcIds) {
        this.setNpcQuestStartId(npcIds);
    }

    public void bindFirstTalk(int ... npcIds) {
        this.setNpcFirstTalkId((NpcFirstTalk event) -> this.notifyFirstTalk(event.npc(), event.player()), npcIds);
    }

    public void bindFirstTalk(Collection<Integer> npcIds) {
        this.setNpcFirstTalkId((NpcFirstTalk event) -> this.notifyFirstTalk(event.npc(), event.player()), npcIds);
    }

    public void bindMenuSelected(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onMenuSelected((PlayerMenuSelected)event), EventType.PLAYER_MENU_SELECTED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindQuestAccepted(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onQuestAccepted((PlayerQuestAccepted)event), EventType.PLAYER_QUEST_ACCEPTED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindLearnSkillRequested(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onLearnSkillRequested((PlayerLearnSkillRequested)event), EventType.PLAYER_LEARN_SKILL_REQUESTED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindSkillLearned(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onSkillLearned((PlayerSkillLearned)event), EventType.PLAYER_SKILL_LEARNED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindItemBypass(int ... itemIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onItemEvent((ItemBypass)event), EventType.ITEM_BYPASS, ListenerRegisterType.ITEM, itemIds);
    }

    public void bindItemBypass(Collection<Integer> itemIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onItemEvent((ItemBypass)event), EventType.ITEM_BYPASS, ListenerRegisterType.ITEM, itemIds);
    }

    public void bindItemTalk(int ... itemIds) {
        this.setItemTalkId((ItemTalk event) -> this.notifyItemTalk(event.item(), event.player()), itemIds);
    }

    public void addItemTalk(Collection<Integer> itemIds) {
        this.setItemTalkId((ItemTalk event) -> this.notifyItemTalk(event.item(), event.player()), itemIds);
    }

    public void bindAttack(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onAttack(event.target(), event.attacker(), event.damage(), event.isSummon(), event.skill()), EventType.ATTACKABLE_ATTACK, ListenerRegisterType.NPC, npcIds);
    }

    public void bindAttack(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onAttack(event.target(), event.attacker(), event.damage(), event.isSummon(), event.skill()), EventType.ATTACKABLE_ATTACK, ListenerRegisterType.NPC, npcIds);
    }

    public void bindKill(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onKill(event.target(), event.attacker(), event.isSummon()), EventType.ATTACKABLE_KILL, ListenerRegisterType.NPC, npcIds);
    }

    public void bindKill(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onKill(event.target(), event.attacker(), event.isSummon()), EventType.ATTACKABLE_KILL, ListenerRegisterType.NPC, npcIds);
    }

    public void bindTalk(int ... npcIds) {
        this.setNpcTalkId(npcIds);
    }

    public void bindTalk(Collection<Integer> npcIds) {
        this.setNpcTalkId(npcIds);
    }

    public void bindTeleport(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onTeleport(event.npc()), EventType.NPC_TELEPORT, ListenerRegisterType.NPC, npcIds);
    }

    public void bindTeleport(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onTeleport(event.npc()), EventType.NPC_TELEPORT, ListenerRegisterType.NPC, npcIds);
    }

    public void bindSpawn(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onSpawn(event.npc()), EventType.NPC_SPAWN, ListenerRegisterType.NPC, npcIds);
    }

    public void bindSpawn(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onSpawn(event.npc()), EventType.NPC_SPAWN, ListenerRegisterType.NPC, npcIds);
    }

    public void bindSkillSee(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onSkillSee(event.npc(), event.caster(), event.skill(), event.targets(), event.isSummon()), EventType.NPC_SKILL_SEE, ListenerRegisterType.NPC, npcIds);
    }

    public void bindSkillSee(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onSkillSee(event.npc(), event.caster(), event.skill(), event.targets(), event.isSummon()), EventType.NPC_SKILL_SEE, ListenerRegisterType.NPC, npcIds);
    }

    public void bindSpellFinished(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onSpellFinished((NpcSkillFinished)event), EventType.NPC_SKILL_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindSpellFinished(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onSpellFinished((NpcSkillFinished)event), EventType.NPC_SKILL_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindTrapAction(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onTrapAction((OnTrapAction)event), EventType.TRAP_ACTION, ListenerRegisterType.NPC, npcIds);
    }

    public void bindTrapAction(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onTrapAction((OnTrapAction)event), EventType.TRAP_ACTION, ListenerRegisterType.NPC, npcIds);
    }

    public void bindFactionCall(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onFactionCall((FactionCall)event), EventType.FACTION_CALL, ListenerRegisterType.NPC, npcIds);
    }

    public void bindFactionCall(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onFactionCall((FactionCall)event), EventType.FACTION_CALL, ListenerRegisterType.NPC, npcIds);
    }

    public void bindAggroRangeEnter(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onAggroRangeEnter((AttackableAggroRangeEnter)event), EventType.ATTACKABLE_AGGRO_RANGE_ENTER, ListenerRegisterType.NPC, npcIds);
    }

    public void bindAggroRangeEnter(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onAggroRangeEnter((AttackableAggroRangeEnter)event), EventType.ATTACKABLE_AGGRO_RANGE_ENTER, ListenerRegisterType.NPC, npcIds);
    }

    public void bindSeeCreature(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onSeeCreature(event.npc(), event.creature()), EventType.NPC_CREATURE_SEE, ListenerRegisterType.NPC, npcIds);
    }

    public void bindSeeCreature(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onSeeCreature(event.npc(), event.creature()), EventType.NPC_CREATURE_SEE, ListenerRegisterType.NPC, npcIds);
    }

    public void bindEnterZone(int ... zoneIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onEnterZone(event.creature(), event.zone()), EventType.CREATURE_ZONE_ENTER, ListenerRegisterType.ZONE, zoneIds);
    }

    public void bindEnterZone(Collection<Integer> zoneIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onEnterZone(event.creature(), event.zone()), EventType.CREATURE_ZONE_ENTER, ListenerRegisterType.ZONE, zoneIds);
    }

    public void bindExitZone(int ... zoneIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onExitZone(event.creature(), event.zone()), EventType.CREATURE_ZONE_EXIT, ListenerRegisterType.ZONE, zoneIds);
    }

    public void bindExitZone(Collection<Integer> zoneIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onExitZone(event.creature(), event.zone()), EventType.CREATURE_ZONE_EXIT, ListenerRegisterType.ZONE, zoneIds);
    }

    public void bindEventReceived(int ... npcIds) {
        this.setNpcEventReceivedId((NpcEventReceived event) -> this.onEventReceived((NpcEventReceived)event), npcIds);
    }

    public void bindEventReceived(Collection<Integer> npcIds) {
        this.setNpcEventReceivedId((NpcEventReceived event) -> this.onEventReceived((NpcEventReceived)event), npcIds);
    }

    public void bindMoveFinished(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onMoveFinished(event.npc()), EventType.NPC_MOVE_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindMoveFinished(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onMoveFinished(event.npc()), EventType.NPC_MOVE_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindNodeArrived(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onNodeArrived(event.npc()), EventType.NPC_MOVE_NODE_ARRIVED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindNodeArrived(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onNodeArrived(event.npc()), EventType.NPC_MOVE_NODE_ARRIVED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindRouteFinished(int ... npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onRouteFinished(event.npc()), EventType.NPC_MOVE_ROUTE_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindRouteFinished(Collection<Integer> npcIds) {
        this.registerConsumer((? extends BaseEvent event) -> this.onRouteFinished(event.npc()), EventType.NPC_MOVE_ROUTE_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    public void bindNpcHate(int ... npcIds) {
        this.addNpcHateId((AttackableHate event) -> new TerminateReturn(!this.onNpcHate(event.npc(), event.player(), event.isSummon()), false, false), npcIds);
    }

    public void bindNpcHate(Collection<Integer> npcIds) {
        this.addNpcHateId((AttackableHate event) -> new TerminateReturn(!this.onNpcHate(event.npc(), event.player(), event.isSummon()), false, false), npcIds);
    }

    public void bindSummonSpawn(int ... npcIds) {
        this.setPlayerSummonSpawnId((PlayerSummonSpawn event) -> this.onSummonSpawn(event.summon()), npcIds);
    }

    public void bindSummonSpawn(Collection<Integer> npcIds) {
        this.setPlayerSummonSpawnId((PlayerSummonSpawn event) -> this.onSummonSpawn(event.summon()), npcIds);
    }

    public void bindSummonTalk(int ... npcIds) {
        this.setPlayerSummonTalkId((PlayerSummonTalk event) -> this.onSummonTalk(event.summon()), npcIds);
    }

    public void bindSummonTalk(Collection<Integer> npcIds) {
        this.setPlayerSummonTalkId((PlayerSummonSpawn event) -> this.onSummonTalk(event.summon()), npcIds);
    }

    public void bindCanSeeMe(int ... npcIds) {
        this.addNpcHateId((AttackableHate event) -> new TerminateReturn(!this.onCanSeeMe(event.npc(), event.player()), false, false), npcIds);
    }

    public void bindCanSeeMe(Collection<Integer> npcIds) {
        this.addNpcHateId((AttackableHate event) -> new TerminateReturn(!this.onCanSeeMe(event.npc(), event.player()), false, false), npcIds);
    }

    public void bindOlympiadMatchFinish() {
        this.setOlympiadMatchResult(event -> this.onOlympiadMatchFinish(event.winner(), event.loser(), event.competitionType()));
    }

    public void setOnEnterWorld(boolean state) {
        if (state) {
            this.registerConsumer((? extends BaseEvent event) -> this.onEnterWorld(event.player()), EventType.PLAYER_LOGIN, ListenerRegisterType.GLOBAL, new int[0]);
        } else {
            this.getListeners().stream().filter(listener -> listener.getType() == EventType.PLAYER_LOGIN).forEach(AbstractEventListener::unregisterMe);
        }
    }

    public void bindTutorial() {
        this.registerConsumer((? extends BaseEvent event) -> this.onTutorialEvent(event.player(), event.command()), EventType.PLAYER_TUTORIAL, ListenerRegisterType.GLOBAL, new int[0]);
    }

    public void bindTutorialClient() {
        this.registerConsumer((? extends BaseEvent event) -> this.onTutorialClientEvent(event.player(), event.event()), EventType.PLAYER_TUTORIAL_CLIENT_EVENT, ListenerRegisterType.GLOBAL, new int[0]);
    }

    public void bindTutorialQuestionMark() {
        this.registerConsumer((? extends BaseEvent event) -> this.onTutorialQuestionMark(event.player(), event.number()), EventType.PLAYER_TUTORIAL_QUESTION_MARK, ListenerRegisterType.GLOBAL, new int[0]);
    }

    public void bindTutorialCmd() {
        this.registerConsumer((? extends BaseEvent event) -> this.onTutorialCmd(event.player(), event.command()), EventType.PLAYER_TUTORIAL_CMD, ListenerRegisterType.GLOBAL, new int[0]);
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player) {
        if (player == null) {
            return null;
        }
        L2Party party = player.getParty();
        if (party == null || party.getMembers().isEmpty()) {
            return player;
        }
        return party.getMembers().get(Rnd.get((int)party.getMembers().size()));
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, int cond) {
        return this.getRandomPartyMember(player, "cond", String.valueOf(cond));
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, String var, String value) {
        if (player == null) {
            return null;
        }
        if (var == null) {
            return this.getRandomPartyMember(player);
        }
        L2Party party = player.getParty();
        if (party == null || party.getMembers().isEmpty()) {
            QuestState temp = player.getQuestState(this.getName());
            if (temp != null && temp.isSet(var) && temp.get(var).equalsIgnoreCase(value)) {
                return player;
            }
            return null;
        }
        ArrayList<L2PcInstance> candidates = new ArrayList<L2PcInstance>();
        L2Object target = player.getTarget();
        if (target == null) {
            target = player;
        }
        for (L2PcInstance partyMember : party.getMembers()) {
            QuestState temp;
            if (partyMember == null || (temp = partyMember.getQuestState(this.getName())) == null || temp.get(var) == null || !temp.get(var).equalsIgnoreCase(value) || !partyMember.isInsideRadius(target, 1500, true, false)) continue;
            candidates.add(partyMember);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (L2PcInstance)candidates.get(Rnd.get((int)candidates.size()));
    }

    public L2PcInstance getRandomPartyMemberState(L2PcInstance player, int state) {
        if (player == null) {
            return null;
        }
        L2Party party = player.getParty();
        if (party == null || party.getMembers().isEmpty()) {
            QuestState temp = player.getQuestState(this.getName());
            if (temp != null && temp.getState() == state) {
                return player;
            }
            return null;
        }
        ArrayList<L2PcInstance> candidates = new ArrayList<L2PcInstance>();
        L2Object target = player.getTarget();
        if (target == null) {
            target = player;
        }
        for (L2PcInstance partyMember : party.getMembers()) {
            QuestState temp;
            if (partyMember == null || (temp = partyMember.getQuestState(this.getName())) == null || temp.getState() != state || !partyMember.isInsideRadius(target, 1500, true, false)) continue;
            candidates.add(partyMember);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (L2PcInstance)candidates.get(Rnd.get((int)candidates.size()));
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, L2Npc npc) {
        if (player == null || !Quest.checkDistanceToTarget(player, npc)) {
            return null;
        }
        L2Party party = player.getParty();
        L2PcInstance luckyPlayer = null;
        if (party == null) {
            if (this.checkPartyMember(player, npc)) {
                luckyPlayer = player;
            }
        } else {
            int highestRoll = 0;
            for (L2PcInstance member : party.getMembers()) {
                int rnd = Quest.getRandom(1000);
                if (rnd <= highestRoll || !this.checkPartyMember(member, npc)) continue;
                highestRoll = rnd;
                luckyPlayer = member;
            }
        }
        if (luckyPlayer != null && Quest.checkDistanceToTarget(luckyPlayer, npc)) {
            return luckyPlayer;
        }
        return null;
    }

    public boolean checkPartyMember(L2PcInstance player, L2Npc npc) {
        return true;
    }

    public QuestState getRandomPartyMemberState(L2PcInstance player, int condition, int playerChance, L2Npc target) {
        if (player == null || playerChance < 1) {
            return null;
        }
        QuestState qs = player.getQuestState(this.getName());
        if (!player.isInParty()) {
            if (!this.checkPartyMemberConditions(qs, condition, target)) {
                return null;
            }
            if (!Quest.checkDistanceToTarget(player, target)) {
                return null;
            }
            return qs;
        }
        ArrayList<QuestState> candidates = new ArrayList<QuestState>();
        if (this.checkPartyMemberConditions(qs, condition, target)) {
            for (int i = 0; i < playerChance; ++i) {
                candidates.add(qs);
            }
        }
        for (L2PcInstance member : player.getParty().getMembers()) {
            if (member == player || !this.checkPartyMemberConditions(qs = member.getQuestState(this.getName()), condition, target)) continue;
            candidates.add(qs);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        qs = (QuestState)candidates.get(Quest.getRandom(candidates.size()));
        if (!Quest.checkDistanceToTarget(qs.getPlayer(), target)) {
            return null;
        }
        return qs;
    }

    private boolean checkPartyMemberConditions(QuestState qs, int condition, L2Npc npc) {
        return qs != null && (condition == -1 ? qs.isStarted() : qs.isCond(condition)) && this.checkPartyMember(qs, npc);
    }

    private static boolean checkDistanceToTarget(L2PcInstance player, L2Npc target) {
        return target == null || Util.checkIfInRange(1500, player, target, true);
    }

    public boolean checkPartyMember(QuestState qs, L2Npc npc) {
        return true;
    }

    public void showPage(L2PcInstance player, String fileName) {
        this.showPage(player, fileName, false);
    }

    public void showPage(L2PcInstance player, String fileName, boolean haveQuest) {
        String content = this.getHtm(player.getHtmlPrefix(), fileName);
        if (content == null) {
            return;
        }
        L2Npc npc = player.getLastFolkNPC();
        if (haveQuest && npc != null) {
            content = content.replace("%objectId%", "" + npc.getObjectId());
        }
        player.sendPacket(new NpcHtmlMessage(npc != null ? npc.getObjectId() : 0, content));
    }

    public void showQuestPage(L2PcInstance player, String fileName, int questId) {
        this.showQuestFHTML(player, fileName, questId, Map.of());
    }

    public void showQuestFHTML(L2PcInstance player, String fileName, int questId, Map<String, Object> mappings) {
        String content = this.getHtm(player.getHtmlPrefix(), fileName);
        if (content == null) {
            LOG.warn("Player {} requested inexistent file {}!", (Object)player, (Object)fileName);
            return;
        }
        for (Map.Entry<String, Object> mapping : mappings.entrySet()) {
            content = content.replace(mapping.getKey(), mapping.getValue().toString());
        }
        L2Npc npc = player.getLastFolkNPC();
        player.sendPacket(new NpcQuestHtmlMessage(npc != null ? npc.getObjectId() : 0, questId, content));
    }

    public void showTutorialHTML(L2PcInstance player, String fileName) {
        String content = this.getHtm(player.getHtmlPrefix(), fileName);
        if (content != null) {
            player.sendPacket(new TutorialShowHtml(content));
        }
    }

    public String showHtmlFile(L2PcInstance player, String filename) {
        return this.showHtmlFile(player, filename, null);
    }

    public String showHtmlFile(L2PcInstance player, String filename, L2Npc npc) {
        boolean questwindow = !filename.endsWith(".html");
        int questId = this.getId();
        String content = this.getHtm(player.getHtmlPrefix(), filename);
        if (content != null) {
            int npcObjId = 0;
            if (npc != null) {
                content = content.replaceAll("%objectId%", String.valueOf(npc.getObjectId()));
                npcObjId = npc.getObjectId();
            }
            content = content.replaceAll("%playername%", player.getName());
            if (questwindow && questId > 0 && questId < 20000 && questId != 999) {
                player.sendPacket(new NpcQuestHtmlMessage(npcObjId, questId, content));
            } else {
                player.sendPacket(new NpcHtmlMessage(npcObjId, content));
            }
            player.sendPacket(ActionFailed.STATIC_PACKET);
        }
        return content;
    }

    public String getHtm(String prefix, String fileName) {
        String path = fileName.startsWith("data/") ? fileName : this.getClass().getPackageName().replace('.', '/') + "/" + fileName;
        return HtmCache.getInstance().getHtm(prefix, path);
    }

    public int[] getRegisteredItemIds() {
        return this._questItemIds;
    }

    public void registerQuestItems(int ... items) {
        this._questItemIds = this._questItemIds != null ? IntStream.concat(Arrays.stream(this._questItemIds), IntStream.of(items)).toArray() : items;
    }

    public void registerQuestItems(Set<Integer> itemIds) {
        this.registerQuestItems(itemIds.stream().mapToInt(i -> i).toArray());
    }

    public void removeRegisteredQuestItems(L2PcInstance player) {
        Quest.takeItems(player, -1, this._questItemIds);
    }

    @Override
    public void setActive(boolean status) {
    }

    @Override
    public boolean reload() {
        this.unload();
        return false;
    }

    @Override
    public boolean unload() {
        return this.unload(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unload(boolean removeFromList) {
        this.saveGlobalData();
        if (this._questTimers != null) {
            for (List<QuestTimer> timers : this.getQuestTimers().values()) {
                this._readLock.lock();
                try {
                    for (QuestTimer timer : timers) {
                        timer.cancel();
                    }
                }
                finally {
                    this._readLock.unlock();
                }
                timers.clear();
            }
            this.getQuestTimers().clear();
        }
        if (removeFromList) {
            return QuestManager.getInstance().removeScript(this) && super.unload();
        }
        return super.unload();
    }

    @Override
    public ScriptManager<?> getManager() {
        return QuestManager.getInstance();
    }

    public void setIsCustom(boolean val) {
        this._isCustom = val;
    }

    public boolean isCustomQuest() {
        return this._isCustom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Predicate<L2PcInstance>, String> getStartConditions() {
        if (this._startCondition == null) {
            Quest quest = this;
            synchronized (quest) {
                if (this._startCondition == null) {
                    this._startCondition = new LinkedHashMap<Predicate<L2PcInstance>, String>(1);
                }
            }
        }
        return this._startCondition;
    }

    public boolean canStartQuest(L2PcInstance player) {
        if (this._startCondition == null) {
            return true;
        }
        for (Predicate<L2PcInstance> cond : this._startCondition.keySet()) {
            if (cond.test(player)) continue;
            return false;
        }
        return true;
    }

    public String getStartConditionHtml(L2PcInstance player) {
        if (this._startCondition == null) {
            return null;
        }
        for (Map.Entry<Predicate<L2PcInstance>, String> startRequirement : this._startCondition.entrySet()) {
            if (startRequirement.getKey().test(player)) continue;
            return startRequirement.getValue();
        }
        return null;
    }

    public void addCondStart(Predicate<L2PcInstance> questStartRequirement, String html) {
        this.getStartConditions().put(questStartRequirement, html);
    }

    public void addCondLevel(int minLevel, int maxLevel, String html) {
        this.getStartConditions().put(p -> p.getLevel() >= minLevel && p.getLevel() <= maxLevel, html);
    }

    public void addCondMinLevel(int minLevel, String html) {
        this.getStartConditions().put(p -> p.getLevel() >= minLevel, html);
    }

    public void addCondMaxLevel(int maxLevel, String html) {
        this.getStartConditions().put(p -> p.getLevel() <= maxLevel, html);
    }

    public void addCondRace(Race race, String html) {
        this.getStartConditions().put(p -> p.getRace() == race, html);
    }

    public void addCondNotRace(Race race, String html) {
        this.getStartConditions().put(p -> p.getRace() != race, html);
    }

    public void addCondCompletedQuest(String name, String html) {
        this.getStartConditions().put(p -> p.hasQuestState(name) && p.getQuestState(name).isCompleted(), html);
    }

    public void addCondClassId(ClassId classId, String html) {
        this.getStartConditions().put(p -> p.getClassId() == classId, html);
    }

    public void addCondNotClassId(ClassId classId, String html) {
        this.getStartConditions().put(p -> p.getClassId() != classId, html);
    }

    public void addCondIsSubClassActive(String html) {
        this.getStartConditions().put(L2PcInstance::isSubClassActive, html);
    }

    public void addCondIsNotSubClassActive(String html) {
        this.getStartConditions().put(p -> !p.isSubClassActive(), html);
    }

    public void addCondInCategory(CategoryType categoryType, String html) {
        this.getStartConditions().put(p -> p.isInCategory(categoryType), html);
    }

    public boolean haveMemo(L2PcInstance talker, int questId) {
        Quest quest = QuestManager.getInstance().getQuest(questId);
        return quest != null && talker.hasQuestState(quest.getName());
    }

    public void setOneTimeQuestFlag(L2PcInstance talker, int questId, int flag) {
        Quest quest = QuestManager.getInstance().getQuest(questId);
        if (quest != null) {
            quest.getQuestState(talker, true).setState(flag == 1 ? 2 : 1);
        }
    }

    public int getOneTimeQuestFlag(L2PcInstance talker, int questId) {
        Quest quest = QuestManager.getInstance().getQuest(questId);
        if (quest != null && quest.getQuestState(talker, true).isCompleted()) {
            return 1;
        }
        return 0;
    }

    public static void playSound(L2PcInstance player, IAudio sound) {
        player.sendPacket(sound.getPacket());
    }

    public void showRadar(L2PcInstance player, int x, int y, int z, int type) {
        player.getRadar().addMarker(x, y, z);
    }

    public boolean isVisibleInQuestWindow() {
        return true;
    }

    public String toString() {
        return this._name + " (" + this._questId + ")";
    }
}

