/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.stats;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.functions.AbstractFunction;
import java.util.ArrayList;
import java.util.List;

public final class Calculator {
    private static final AbstractFunction[] EMPTY_FUNCS = new AbstractFunction[0];
    private AbstractFunction[] _functions;

    public Calculator() {
        this._functions = EMPTY_FUNCS;
    }

    public Calculator(Calculator c) {
        this._functions = c._functions;
    }

    public static boolean equalsCals(Calculator c1, Calculator c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        AbstractFunction[] funcs1 = c1._functions;
        AbstractFunction[] funcs2 = c2._functions;
        if (funcs1 == funcs2) {
            return true;
        }
        if (funcs1.length != funcs2.length) {
            return false;
        }
        if (funcs1.length == 0) {
            return true;
        }
        for (int i = 0; i < funcs1.length; ++i) {
            if (funcs1[i] == funcs2[i]) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this._functions.length;
    }

    public synchronized void addFunc(AbstractFunction function) {
        int i;
        AbstractFunction[] funcs = this._functions;
        AbstractFunction[] tmp = new AbstractFunction[funcs.length + 1];
        int order = function.getOrder();
        for (i = 0; i < funcs.length && order >= funcs[i].getOrder(); ++i) {
            tmp[i] = funcs[i];
        }
        tmp[i] = function;
        while (i < funcs.length) {
            tmp[i + 1] = funcs[i];
            ++i;
        }
        this._functions = tmp;
    }

    public synchronized void removeFunc(AbstractFunction function) {
        int i;
        AbstractFunction[] funcs = this._functions;
        AbstractFunction[] tmp = new AbstractFunction[funcs.length - 1];
        for (i = 0; i < funcs.length - 1 && function != funcs[i]; ++i) {
            tmp[i] = funcs[i];
        }
        if (i == funcs.length) {
            return;
        }
        ++i;
        while (i < funcs.length) {
            tmp[i - 1] = funcs[i];
            ++i;
        }
        this._functions = tmp.length == 0 ? EMPTY_FUNCS : tmp;
    }

    public synchronized List<Stats> removeOwner(Object owner) {
        ArrayList<Stats> modifiedStats = new ArrayList<Stats>();
        for (AbstractFunction func : this._functions) {
            if (func.getFuncOwner() != owner) continue;
            modifiedStats.add(func.getStat());
            this.removeFunc(func);
        }
        return modifiedStats;
    }

    public double calc(L2Character caster, L2Character target, Skill skill, double initVal) {
        double value = initVal;
        for (AbstractFunction func : this._functions) {
            value = func.calc(caster, target, skill, value);
        }
        return value;
    }

    public AbstractFunction[] getFunctions() {
        return this._functions;
    }
}

