/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.stats.functions;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.functions.AbstractFunction;

public class FuncEnchant
extends AbstractFunction {
    public FuncEnchant(Stats stat, int order, Object owner, double value, Condition applyCond) {
        super(stat, order, owner, value, applyCond);
    }

    @Override
    public double calc(L2Character effector, L2Character effected, Skill skill, double initVal) {
        double value = initVal;
        if (this.getApplyCond() != null && !this.getApplyCond().test(effector, effected, skill)) {
            return value;
        }
        L2ItemInstance item = (L2ItemInstance)this.getFuncOwner();
        int enchant = item.getEnchantLevel();
        if (enchant <= 0) {
            return value;
        }
        int overEnchant = 0;
        if (enchant > 3) {
            overEnchant = enchant - 3;
            enchant = 3;
        }
        if (effector.isPlayer() && effector.getActingPlayer().isInOlympiadMode() && Configuration.olympiad().getEnchantLimit() >= 0 && enchant + overEnchant > Configuration.olympiad().getEnchantLimit()) {
            if (Configuration.olympiad().getEnchantLimit() > 3) {
                overEnchant = Configuration.olympiad().getEnchantLimit() - 3;
            } else {
                overEnchant = 0;
                enchant = Configuration.olympiad().getEnchantLimit();
            }
        }
        if (this.getStat() == Stats.MAGIC_DEFENCE || this.getStat() == Stats.POWER_DEFENCE) {
            return value + (double)enchant + (double)(3 * overEnchant);
        }
        if (this.getStat() == Stats.MAGIC_ATTACK) {
            switch (item.getItem().getItemGradeSPlus()) {
                case S: {
                    value += (double)(4 * enchant + 8 * overEnchant);
                    break;
                }
                case A: 
                case B: 
                case C: {
                    value += (double)(3 * enchant + 6 * overEnchant);
                    break;
                }
                case D: 
                case NONE: {
                    value += (double)(2 * enchant + 4 * overEnchant);
                }
            }
            return value;
        }
        if (item.isWeapon()) {
            WeaponType type = (WeaponType)item.getItemType();
            block5 : switch (item.getItem().getItemGradeSPlus()) {
                case S: {
                    if (item.getWeaponItem().getBodyPart() == 16384) {
                        if (type == WeaponType.BOW || type == WeaponType.CROSSBOW) {
                            value += (double)(10 * enchant + 20 * overEnchant);
                            break;
                        }
                        value += (double)(6 * enchant + 12 * overEnchant);
                        break;
                    }
                    value += (double)(5 * enchant + 10 * overEnchant);
                    break;
                }
                case A: {
                    if (item.getWeaponItem().getBodyPart() == 16384) {
                        if (type == WeaponType.BOW || type == WeaponType.CROSSBOW) {
                            value += (double)(8 * enchant + 16 * overEnchant);
                            break;
                        }
                        value += (double)(5 * enchant + 10 * overEnchant);
                        break;
                    }
                    value += (double)(4 * enchant + 8 * overEnchant);
                    break;
                }
                case B: 
                case C: {
                    if (item.getWeaponItem().getBodyPart() == 16384) {
                        if (type == WeaponType.BOW || type == WeaponType.CROSSBOW) {
                            value += (double)(6 * enchant + 12 * overEnchant);
                            break;
                        }
                        value += (double)(4 * enchant + 8 * overEnchant);
                        break;
                    }
                    value += (double)(3 * enchant + 6 * overEnchant);
                    break;
                }
                case D: 
                case NONE: {
                    switch (type) {
                        case BOW: 
                        case CROSSBOW: {
                            value += (double)(4 * enchant + 8 * overEnchant);
                            break block5;
                        }
                    }
                    value += (double)(2 * enchant + 4 * overEnchant);
                }
            }
        }
        return value;
    }
}

