/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.variables;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.variables.AbstractVariables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountVariables
extends AbstractVariables {
    private static final Logger LOG = LoggerFactory.getLogger(AccountVariables.class);
    private static final String SELECT_QUERY = "SELECT * FROM account_gsdata WHERE account_name = ?";
    private static final String DELETE_QUERY = "DELETE FROM account_gsdata WHERE account_name = ?";
    private static final String INSERT_QUERY = "INSERT INTO account_gsdata (account_name, var, value) VALUES (?, ?, ?)";
    private final String _accountName;

    public AccountVariables(String accountName) {
        this._accountName = accountName;
        this.restoreMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restoreMe() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement st = con.prepareStatement(SELECT_QUERY);){
            st.setString(1, this._accountName);
            try (ResultSet rs = st.executeQuery();){
                while (rs.next()) {
                    this.set(rs.getString("var"), rs.getString("value"));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't restore variables for: {}", (Object)this._accountName, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.compareAndSetChanges(true, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeMe() {
        if (!this.hasChanges()) {
            return false;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            try (PreparedStatement st = con.prepareStatement(DELETE_QUERY);){
                st.setString(1, this._accountName);
                st.execute();
            }
            st = con.prepareStatement(INSERT_QUERY);
            try {
                st.setString(1, this._accountName);
                for (Map.Entry<String, Object> entry : this.getSet().entrySet()) {
                    st.setString(2, entry.getKey());
                    st.setString(3, String.valueOf(entry.getValue()));
                    st.addBatch();
                }
                st.executeBatch();
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't update variables for: {}", (Object)this._accountName, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.compareAndSetChanges(true, false);
        }
        return true;
    }
}

