/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.GameServer;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.AbstractZoneSettings;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class L2BossZone
extends L2ZoneType {
    private int _timeInvade;
    private final int[] _oustLoc = new int[3];

    public L2BossZone(int id) {
        super(id);
        AbstractZoneSettings settings = ZoneManager.getSettings(this.getName());
        if (settings == null) {
            settings = new Settings();
        }
        this.setSettings(settings);
        GrandBossManager.getInstance().addZone(this);
    }

    @Override
    public Settings getSettings() {
        return (Settings)super.getSettings();
    }

    @Override
    public void setParameter(String name, String value) {
        switch (name) {
            case "InvadeTime": {
                this._timeInvade = Integer.parseInt(value);
                break;
            }
            case "oustX": {
                this._oustLoc[0] = Integer.parseInt(value);
                break;
            }
            case "oustY": {
                this._oustLoc[1] = Integer.parseInt(value);
                break;
            }
            case "oustZ": {
                this._oustLoc[2] = Integer.parseInt(value);
                break;
            }
            default: {
                super.setParameter(name, value);
            }
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (this.isEnabled()) {
            if (character.isPlayer()) {
                L2PcInstance player = character.getActingPlayer();
                if (player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
                    return;
                }
                if (this.getSettings().getPlayersAllowed().contains(player.getObjectId())) {
                    Long expirationTime = this.getSettings().getPlayerAllowedReEntryTimes().get(player.getObjectId());
                    if (expirationTime == null) {
                        long serverStartTime = GameServer.dateTimeServerStarted.getTimeInMillis();
                        if (serverStartTime > System.currentTimeMillis() - (long)this._timeInvade) {
                            return;
                        }
                    } else {
                        this.getSettings().getPlayerAllowedReEntryTimes().remove(player.getObjectId());
                        if (expirationTime > System.currentTimeMillis()) {
                            return;
                        }
                    }
                    this.getSettings().getPlayersAllowed().remove((Object)player.getObjectId());
                }
                if (this._oustLoc[0] != 0 && this._oustLoc[1] != 0 && this._oustLoc[2] != 0) {
                    player.teleToLocation(this._oustLoc[0], this._oustLoc[1], this._oustLoc[2]);
                } else {
                    player.teleToLocation(TeleportWhereType.TOWN);
                }
            } else if (character.isSummon()) {
                L2PcInstance player = character.getActingPlayer();
                if (player != null) {
                    if (this.getSettings().getPlayersAllowed().contains(player.getObjectId()) || player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
                        return;
                    }
                    if (this._oustLoc[0] != 0 && this._oustLoc[1] != 0 && this._oustLoc[2] != 0) {
                        player.teleToLocation(this._oustLoc[0], this._oustLoc[1], this._oustLoc[2]);
                    } else {
                        player.teleToLocation(TeleportWhereType.TOWN);
                    }
                }
                ((L2Summon)character).unSummon(player);
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (this.isEnabled()) {
            if (character.isPlayer()) {
                L2PcInstance player = character.getActingPlayer();
                if (player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
                    return;
                }
                if (!player.isOnline() && this.getSettings().getPlayersAllowed().contains(player.getObjectId())) {
                    this.getSettings().getPlayerAllowedReEntryTimes().put(player.getObjectId(), System.currentTimeMillis() + (long)this._timeInvade);
                } else {
                    if (this.getSettings().getPlayersAllowed().contains(player.getObjectId())) {
                        this.getSettings().getPlayersAllowed().remove((Object)player.getObjectId());
                    }
                    this.getSettings().getPlayerAllowedReEntryTimes().remove(player.getObjectId());
                }
            }
            if (character.isPlayable() && this.getCharactersInside() != null && !this.getCharactersInside().isEmpty()) {
                this.getSettings().getRaidList().clear();
                int count = 0;
                for (L2Character creature : this.getCharactersInside()) {
                    if (creature == null) continue;
                    if (creature.isPlayable()) {
                        ++count;
                        continue;
                    }
                    if (!creature.isAttackable() || !creature.isRaid()) continue;
                    this.getSettings().getRaidList().add(creature);
                }
                if (count == 0 && !this.getSettings().getRaidList().isEmpty()) {
                    for (L2Character creature : this.getSettings().getRaidList()) {
                        L2Attackable raid = (L2Attackable)creature;
                        if (raid == null || raid.getSpawn() == null || raid.isDead() || raid.isInsideRadius(raid.getSpawn(), 150, false, false)) continue;
                        raid.returnHome();
                    }
                }
            }
        }
        if (character.isAttackable() && character.isRaid() && !character.isDead()) {
            ((L2Attackable)character).returnHome();
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        if (this.isEnabled() != flag) {
            this.oustAllPlayers();
        }
        super.setEnabled(flag);
    }

    public int getTimeInvade() {
        return this._timeInvade;
    }

    public void setAllowedPlayers(List<Integer> players) {
        if (players != null) {
            this.getSettings().getPlayersAllowed().clear();
            this.getSettings().getPlayersAllowed().addAll(players);
        }
    }

    public List<Integer> getAllowedPlayers() {
        return this.getSettings().getPlayersAllowed();
    }

    public boolean isPlayerAllowed(L2PcInstance player) {
        if (player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
            return true;
        }
        if (this.getSettings().getPlayersAllowed().contains(player.getObjectId())) {
            return true;
        }
        if (this._oustLoc[0] != 0 && this._oustLoc[1] != 0 && this._oustLoc[2] != 0) {
            player.teleToLocation(this._oustLoc[0], this._oustLoc[1], this._oustLoc[2]);
        } else {
            player.teleToLocation(TeleportWhereType.TOWN);
        }
        return false;
    }

    public void movePlayersTo(Location loc) {
        if (this._characterList.isEmpty()) {
            return;
        }
        for (L2Character character : this.getCharactersInside()) {
            L2PcInstance player;
            if (character == null || !character.isPlayer() || !(player = character.getActingPlayer()).isOnline()) continue;
            player.teleToLocation(loc);
        }
    }

    public void oustAllPlayers() {
        if (this._characterList.isEmpty()) {
            return;
        }
        for (L2Character character : this.getCharactersInside()) {
            L2PcInstance player;
            if (character == null || !character.isPlayer() || !(player = character.getActingPlayer()).isOnline()) continue;
            if (this._oustLoc[0] != 0 && this._oustLoc[1] != 0 && this._oustLoc[2] != 0) {
                player.teleToLocation(this._oustLoc[0], this._oustLoc[1], this._oustLoc[2]);
                continue;
            }
            player.teleToLocation(TeleportWhereType.TOWN);
        }
        this.getSettings().getPlayerAllowedReEntryTimes().clear();
        this.getSettings().getPlayersAllowed().clear();
    }

    public void allowPlayerEntry(L2PcInstance player, int durationInSec) {
        if (!player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
            if (!this.getSettings().getPlayersAllowed().contains(player.getObjectId())) {
                this.getSettings().getPlayersAllowed().add(player.getObjectId());
            }
            this.getSettings().getPlayerAllowedReEntryTimes().put(player.getObjectId(), System.currentTimeMillis() + (long)(durationInSec * 1000));
        }
    }

    public void removePlayer(L2PcInstance player) {
        if (!player.canOverrideCond(PcCondOverride.ZONE_CONDITIONS)) {
            this.getSettings().getPlayersAllowed().remove((Object)player.getObjectId());
            this.getSettings().getPlayerAllowedReEntryTimes().remove(player.getObjectId());
        }
    }

    public void updateKnownList(L2Npc npc) {
        if (this._characterList == null || this._characterList.isEmpty()) {
            return;
        }
        Map<Integer, L2PcInstance> npcKnownPlayers = npc.getKnownList().getKnownPlayers();
        for (L2Character character : this.getCharactersInside()) {
            L2PcInstance player;
            if (character == null || !character.isPlayer() || !(player = character.getActingPlayer()).isOnline()) continue;
            npcKnownPlayers.put(player.getObjectId(), player);
        }
    }

    public static final class Settings
    extends AbstractZoneSettings {
        private final Map<Integer, Long> _playerAllowedReEntryTimes = new ConcurrentHashMap<Integer, Long>();
        private final List<Integer> _playersAllowed = new CopyOnWriteArrayList<Integer>();
        private final List<L2Character> _raidList = new CopyOnWriteArrayList<L2Character>();

        protected Settings() {
        }

        public Map<Integer, Long> getPlayerAllowedReEntryTimes() {
            return this._playerAllowedReEntryTimes;
        }

        public List<Integer> getPlayersAllowed() {
            return this._playersAllowed;
        }

        public List<L2Character> getRaidList() {
            return this._raidList;
        }

        @Override
        public void clear() {
            this._playerAllowedReEntryTimes.clear();
            this._playersAllowed.clear();
            this._raidList.clear();
        }
    }
}

