/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.AbstractZoneSettings;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.TaskZoneSettings;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.serverpackets.EtcStatusUpdate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2EffectZone
extends L2ZoneType {
    private static final Logger LOG = LoggerFactory.getLogger(L2EffectZone.class);
    private int _chance = 100;
    private int _initialDelay = 0;
    private int _reuse = 30000;
    private boolean _bypassConditions;
    private boolean _isShowDangerIcon;
    protected volatile Map<Integer, Integer> _skills;

    public L2EffectZone(int id) {
        super(id);
        this.setTargetType(InstanceType.L2Playable);
        this._bypassConditions = false;
        this._isShowDangerIcon = true;
        AbstractZoneSettings settings = ZoneManager.getSettings(this.getName());
        if (settings == null) {
            settings = new TaskZoneSettings();
        }
        this.setSettings(settings);
    }

    @Override
    public TaskZoneSettings getSettings() {
        return (TaskZoneSettings)super.getSettings();
    }

    @Override
    public void setParameter(String name, String value) {
        switch (name) {
            case "chance": {
                this._chance = Integer.parseInt(value);
                break;
            }
            case "initialDelay": {
                this._initialDelay = Integer.parseInt(value);
                break;
            }
            case "reuse": {
                this._reuse = Integer.parseInt(value);
                break;
            }
            case "bypassSkillConditions": {
                this._bypassConditions = Boolean.parseBoolean(value);
                break;
            }
            case "maxDynamicSkillCount": {
                this._skills = new ConcurrentHashMap<Integer, Integer>(Integer.parseInt(value));
                break;
            }
            case "skillIdLvl": {
                String[] propertySplit = value.split(";");
                this._skills = new ConcurrentHashMap<Integer, Integer>(propertySplit.length);
                for (String skill : propertySplit) {
                    String[] skillSplit = skill.split("-");
                    if (skillSplit.length != 2) {
                        LOG.warn("Invalid config property -> skillsIdLvl \"{}\"", (Object)skill);
                        continue;
                    }
                    try {
                        this._skills.put(Integer.parseInt(skillSplit[0]), Integer.parseInt(skillSplit[1]));
                    }
                    catch (NumberFormatException nfe) {
                        if (skill.isEmpty()) continue;
                        LOG.warn("Invalid config property -> skillsIdLvl \"{}\"{}", (Object)skillSplit[0], (Object)skillSplit[1]);
                    }
                }
                break;
            }
            case "showDangerIcon": {
                this._isShowDangerIcon = Boolean.parseBoolean(value);
                break;
            }
            default: {
                super.setParameter(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEnter(L2Character character) {
        if (this._skills != null && this.getSettings().getTask() == null) {
            L2EffectZone l2EffectZone = this;
            synchronized (l2EffectZone) {
                if (this.getSettings().getTask() == null) {
                    this.getSettings().setTask(ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new ApplySkill(), this._initialDelay, this._reuse));
                }
            }
        }
        if (character.isPlayer()) {
            character.setInsideZone(ZoneId.ALTERED, true);
            if (this._isShowDangerIcon) {
                character.setInsideZone(ZoneId.DANGER_AREA, true);
                character.sendPacket(new EtcStatusUpdate(character.getActingPlayer()));
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character.isPlayer()) {
            character.setInsideZone(ZoneId.ALTERED, false);
            if (this._isShowDangerIcon) {
                character.setInsideZone(ZoneId.DANGER_AREA, false);
                if (!character.isInsideZone(ZoneId.DANGER_AREA)) {
                    character.sendPacket(new EtcStatusUpdate(character.getActingPlayer()));
                }
            }
        }
        if (this._characterList.isEmpty() && this.getSettings().getTask() != null) {
            this.getSettings().clear();
        }
    }

    protected Skill getSkill(int skillId, int skillLvl) {
        return SkillData.getInstance().getSkill(skillId, skillLvl);
    }

    public int getChance() {
        return this._chance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSkill(int skillId, int skillLvL) {
        if (skillLvL < 1) {
            this.removeSkill(skillId);
            return;
        }
        if (this._skills == null) {
            L2EffectZone l2EffectZone = this;
            synchronized (l2EffectZone) {
                if (this._skills == null) {
                    this._skills = new ConcurrentHashMap<Integer, Integer>(3);
                }
            }
        }
        this._skills.put(skillId, skillLvL);
    }

    public void removeSkill(int skillId) {
        if (this._skills != null) {
            this._skills.remove(skillId);
        }
    }

    public void clearSkills() {
        if (this._skills != null) {
            this._skills.clear();
        }
    }

    public int getSkillLevel(int skillId) {
        Map<Integer, Integer> skills = this._skills;
        return skills != null ? skills.getOrDefault(skillId, 0) : 0;
    }

    private final class ApplySkill
    implements Runnable {
        private ApplySkill() {
            if (L2EffectZone.this._skills == null) {
                throw new IllegalStateException("No skills defined.");
            }
        }

        @Override
        public void run() {
            if (L2EffectZone.this.isEnabled()) {
                for (L2Character temp : L2EffectZone.this.getCharactersInside()) {
                    if (temp == null || temp.isDead() || Rnd.get((int)100) >= L2EffectZone.this.getChance()) continue;
                    for (Map.Entry<Integer, Integer> e : L2EffectZone.this._skills.entrySet()) {
                        Skill skill = L2EffectZone.this.getSkill(e.getKey(), e.getValue());
                        if (skill == null || !L2EffectZone.this._bypassConditions && !skill.checkCondition(temp, temp, false) || temp.isAffectedBySkill(e.getKey())) continue;
                        skill.applyEffects(temp, temp);
                    }
                }
            }
        }
    }
}

