/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.CrystalType;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRefinePacket
extends L2GameClientPacket {
    public static final int GRADE_NONE = 0;
    public static final int GRADE_MID = 1;
    public static final int GRADE_HIGH = 2;
    public static final int GRADE_TOP = 3;
    public static final int GRADE_ACC = 4;
    protected static final int GEMSTONE_D = 2130;
    protected static final int GEMSTONE_C = 2131;
    protected static final int GEMSTONE_B = 2132;
    private static final Map<Integer, LifeStone> _lifeStones = new HashMap<Integer, LifeStone>();

    protected static LifeStone getLifeStone(int itemId) {
        return _lifeStones.get(itemId);
    }

    protected static boolean isValid(L2PcInstance player, L2ItemInstance item, L2ItemInstance refinerItem, L2ItemInstance gemStones) {
        if (!AbstractRefinePacket.isValid(player, item, refinerItem)) {
            return false;
        }
        if (gemStones.getOwnerId() != player.getObjectId()) {
            return false;
        }
        if (gemStones.getItemLocation() != ItemLocation.INVENTORY) {
            return false;
        }
        CrystalType grade = item.getItem().getItemGrade();
        LifeStone ls = _lifeStones.get(refinerItem.getId());
        if (AbstractRefinePacket.getGemStoneId(grade) != gemStones.getId()) {
            return false;
        }
        return (long)AbstractRefinePacket.getGemStoneCount(grade, ls.getGrade()) <= gemStones.getCount();
    }

    protected static boolean isValid(L2PcInstance player, L2ItemInstance item, L2ItemInstance refinerItem) {
        if (!AbstractRefinePacket.isValid(player, item)) {
            return false;
        }
        if (refinerItem.getOwnerId() != player.getObjectId()) {
            return false;
        }
        if (refinerItem.getItemLocation() != ItemLocation.INVENTORY) {
            return false;
        }
        LifeStone ls = _lifeStones.get(refinerItem.getId());
        if (ls == null) {
            return false;
        }
        if (item.getItem() instanceof L2Weapon && ls.getGrade() == 4) {
            return false;
        }
        if (item.getItem() instanceof L2Armor && ls.getGrade() != 4) {
            return false;
        }
        return player.getLevel() >= ls.getPlayerLevel();
    }

    protected static boolean isValid(L2PcInstance player, L2ItemInstance item) {
        block20: {
            block21: {
                block19: {
                    if (!AbstractRefinePacket.isValid(player)) {
                        return false;
                    }
                    if (item.getOwnerId() != player.getObjectId()) {
                        return false;
                    }
                    if (item.isAugmented()) {
                        return false;
                    }
                    if (item.isHeroItem()) {
                        return false;
                    }
                    if (item.isShadowItem()) {
                        return false;
                    }
                    if (item.isCommonItem()) {
                        return false;
                    }
                    if (item.isEtcItem()) {
                        return false;
                    }
                    if (item.isTimeLimitedItem()) {
                        return false;
                    }
                    if (item.isPvp() && !Configuration.character().allowAugmentPvPItems()) {
                        return false;
                    }
                    if (item.getItem().getCrystalType().isLesser(CrystalType.C)) {
                        return false;
                    }
                    switch (item.getItemLocation()) {
                        case INVENTORY: 
                        case PAPERDOLL: {
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (!(item.getItem() instanceof L2Weapon)) break block19;
                    switch (((L2Weapon)item.getItem()).getItemType()) {
                        case NONE: 
                        case FISHINGROD: {
                            return false;
                        }
                    }
                    break block20;
                }
                if (!(item.getItem() instanceof L2Armor)) break block21;
                switch (item.getItem().getBodyPart()) {
                    case 6: 
                    case 8: 
                    case 48: {
                        break block20;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }
        return !Configuration.character().getAugmentationBlacklist().contains(item.getId());
    }

    protected static boolean isValid(L2PcInstance player) {
        if (player.getPrivateStoreType() != PrivateStoreType.NONE) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_A_PRIVATE_STORE_OR_PRIVATE_WORKSHOP_IS_IN_OPERATION);
            return false;
        }
        if (player.getActiveTradeList() != null) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_TRADING);
            return false;
        }
        if (player.isDead()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_DEAD);
            return false;
        }
        if (player.isStunned()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_PARALYZED);
            return false;
        }
        if (player.isFishing()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_FISHING);
            return false;
        }
        if (player.isSitting()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_AUGMENT_ITEMS_WHILE_SITTING_DOWN);
            return false;
        }
        if (player.isCursedWeaponEquipped()) {
            return false;
        }
        return !player.isEnchanting() && !player.isProcessingTransaction();
    }

    protected static int getGemStoneId(CrystalType itemGrade) {
        return switch (itemGrade) {
            case CrystalType.C, CrystalType.B -> 2130;
            case CrystalType.A, CrystalType.S -> 2131;
            case CrystalType.S80, CrystalType.S84 -> 2132;
            default -> 0;
        };
    }

    protected static int getGemStoneCount(CrystalType itemGrade, int lifeStoneGrade) {
        if (lifeStoneGrade == 4) {
            return switch (itemGrade) {
                case CrystalType.C -> 200;
                case CrystalType.B -> 300;
                case CrystalType.A -> 200;
                case CrystalType.S -> 250;
                case CrystalType.S80 -> 360;
                case CrystalType.S84 -> 480;
                default -> 0;
            };
        }
        return switch (itemGrade) {
            case CrystalType.C -> 20;
            case CrystalType.B -> 30;
            case CrystalType.A -> 20;
            case CrystalType.S -> 25;
            case CrystalType.S80, CrystalType.S84 -> 36;
            default -> 0;
        };
    }

    static {
        _lifeStones.put(8723, new LifeStone(0, 0));
        _lifeStones.put(8724, new LifeStone(0, 1));
        _lifeStones.put(8725, new LifeStone(0, 2));
        _lifeStones.put(8726, new LifeStone(0, 3));
        _lifeStones.put(8727, new LifeStone(0, 4));
        _lifeStones.put(8728, new LifeStone(0, 5));
        _lifeStones.put(8729, new LifeStone(0, 6));
        _lifeStones.put(8730, new LifeStone(0, 7));
        _lifeStones.put(8731, new LifeStone(0, 8));
        _lifeStones.put(8732, new LifeStone(0, 9));
        _lifeStones.put(8733, new LifeStone(1, 0));
        _lifeStones.put(8734, new LifeStone(1, 1));
        _lifeStones.put(8735, new LifeStone(1, 2));
        _lifeStones.put(8736, new LifeStone(1, 3));
        _lifeStones.put(8737, new LifeStone(1, 4));
        _lifeStones.put(8738, new LifeStone(1, 5));
        _lifeStones.put(8739, new LifeStone(1, 6));
        _lifeStones.put(8740, new LifeStone(1, 7));
        _lifeStones.put(8741, new LifeStone(1, 8));
        _lifeStones.put(8742, new LifeStone(1, 9));
        _lifeStones.put(8743, new LifeStone(2, 0));
        _lifeStones.put(8744, new LifeStone(2, 1));
        _lifeStones.put(8745, new LifeStone(2, 2));
        _lifeStones.put(8746, new LifeStone(2, 3));
        _lifeStones.put(8747, new LifeStone(2, 4));
        _lifeStones.put(8748, new LifeStone(2, 5));
        _lifeStones.put(8749, new LifeStone(2, 6));
        _lifeStones.put(8750, new LifeStone(2, 7));
        _lifeStones.put(8751, new LifeStone(2, 8));
        _lifeStones.put(8752, new LifeStone(2, 9));
        _lifeStones.put(8753, new LifeStone(3, 0));
        _lifeStones.put(8754, new LifeStone(3, 1));
        _lifeStones.put(8755, new LifeStone(3, 2));
        _lifeStones.put(8756, new LifeStone(3, 3));
        _lifeStones.put(8757, new LifeStone(3, 4));
        _lifeStones.put(8758, new LifeStone(3, 5));
        _lifeStones.put(8759, new LifeStone(3, 6));
        _lifeStones.put(8760, new LifeStone(3, 7));
        _lifeStones.put(8761, new LifeStone(3, 8));
        _lifeStones.put(8762, new LifeStone(3, 9));
        _lifeStones.put(9573, new LifeStone(0, 10));
        _lifeStones.put(9574, new LifeStone(1, 10));
        _lifeStones.put(9575, new LifeStone(2, 10));
        _lifeStones.put(9576, new LifeStone(3, 10));
        _lifeStones.put(10483, new LifeStone(0, 11));
        _lifeStones.put(10484, new LifeStone(1, 11));
        _lifeStones.put(10485, new LifeStone(2, 11));
        _lifeStones.put(10486, new LifeStone(3, 11));
        _lifeStones.put(12754, new LifeStone(4, 0));
        _lifeStones.put(12755, new LifeStone(4, 1));
        _lifeStones.put(12756, new LifeStone(4, 2));
        _lifeStones.put(12757, new LifeStone(4, 3));
        _lifeStones.put(12758, new LifeStone(4, 4));
        _lifeStones.put(12759, new LifeStone(4, 5));
        _lifeStones.put(12760, new LifeStone(4, 6));
        _lifeStones.put(12761, new LifeStone(4, 7));
        _lifeStones.put(12762, new LifeStone(4, 8));
        _lifeStones.put(12763, new LifeStone(4, 9));
        _lifeStones.put(12821, new LifeStone(4, 10));
        _lifeStones.put(12822, new LifeStone(4, 11));
        _lifeStones.put(12840, new LifeStone(4, 0));
        _lifeStones.put(12841, new LifeStone(4, 1));
        _lifeStones.put(12842, new LifeStone(4, 2));
        _lifeStones.put(12843, new LifeStone(4, 3));
        _lifeStones.put(12844, new LifeStone(4, 4));
        _lifeStones.put(12845, new LifeStone(4, 5));
        _lifeStones.put(12846, new LifeStone(4, 6));
        _lifeStones.put(12847, new LifeStone(4, 7));
        _lifeStones.put(12848, new LifeStone(4, 8));
        _lifeStones.put(12849, new LifeStone(4, 9));
        _lifeStones.put(12850, new LifeStone(4, 10));
        _lifeStones.put(12851, new LifeStone(4, 11));
        _lifeStones.put(14008, new LifeStone(4, 12));
        _lifeStones.put(14166, new LifeStone(0, 12));
        _lifeStones.put(14167, new LifeStone(1, 12));
        _lifeStones.put(14168, new LifeStone(2, 12));
        _lifeStones.put(14169, new LifeStone(3, 12));
        _lifeStones.put(16160, new LifeStone(0, 13));
        _lifeStones.put(16161, new LifeStone(1, 13));
        _lifeStones.put(16162, new LifeStone(2, 13));
        _lifeStones.put(16163, new LifeStone(3, 13));
        _lifeStones.put(16177, new LifeStone(4, 13));
        _lifeStones.put(16164, new LifeStone(0, 13));
        _lifeStones.put(16165, new LifeStone(1, 13));
        _lifeStones.put(16166, new LifeStone(2, 13));
        _lifeStones.put(16167, new LifeStone(3, 13));
        _lifeStones.put(16178, new LifeStone(4, 13));
    }

    protected static final class LifeStone {
        private static final int[] LEVELS = new int[]{46, 49, 52, 55, 58, 61, 64, 67, 70, 76, 80, 82, 84, 85};
        private final int _grade;
        private final int _level;

        public LifeStone(int grade, int level) {
            this._grade = grade;
            this._level = level;
        }

        public int getLevel() {
            return this._level;
        }

        public int getGrade() {
            return this._grade;
        }

        public int getPlayerLevel() {
            return LEVELS[this._level];
        }
    }
}

