/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.PartyMatchWaitingList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExManagePartyRoomMember;
import com.l2jserver.gameserver.network.serverpackets.ExPartyRoomMember;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PartyMatchDetail;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class AnswerJoinPartyRoom
extends L2GameClientPacket {
    private static final String _C__D0_30_ANSWERJOINPARTYROOM = "[C] D0:30 AnswerJoinPartyRoom";
    private int _answer;

    @Override
    protected void readImpl() {
        this._answer = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = this.getActiveChar();
        if (player == null) {
            return;
        }
        L2PcInstance partner = player.getActiveRequester();
        if (partner == null) {
            player.sendPacket(SystemMessageId.TARGET_IS_NOT_FOUND_IN_THE_GAME);
            player.setActiveRequester(null);
            return;
        }
        if (L2World.getInstance().getPlayer(partner.getObjectId()) == null) {
            player.sendPacket(SystemMessageId.TARGET_IS_NOT_FOUND_IN_THE_GAME);
            player.setActiveRequester(null);
            return;
        }
        if (this._answer == 1 && !partner.isRequestExpired()) {
            PartyMatchRoom room = PartyMatchRoomList.getInstance().getRoom(partner.getPartyRoom());
            if (room == null) {
                return;
            }
            if (player.getLevel() >= room.getMinLvl() && player.getLevel() <= room.getMaxLvl()) {
                PartyMatchWaitingList.getInstance().removePlayer(player);
                player.setPartyRoom(partner.getPartyRoom());
                player.sendPacket(new PartyMatchDetail(player, room));
                player.sendPacket(new ExPartyRoomMember(player, room, 0));
                for (L2PcInstance member : room.getPartyMembers()) {
                    if (member == null) continue;
                    member.sendPacket(new ExManagePartyRoomMember(player, room, 0));
                    member.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.C1_ENTERED_PARTY_ROOM).addPcName(player)));
                }
                room.addMember(player);
                player.broadcastUserInfo();
            } else {
                player.sendPacket(SystemMessageId.CANT_ENTER_PARTY_ROOM);
            }
        } else {
            partner.sendPacket(SystemMessageId.PARTY_MATCHING_REQUEST_NO_RESPONSE);
        }
        player.setActiveRequester(null);
        partner.onTransactionResponse();
    }

    @Override
    public String getType() {
        return _C__D0_30_ANSWERJOINPARTYROOM;
    }
}

