/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.data.xml.impl.InitialEquipmentData;
import com.l2jserver.gameserver.data.xml.impl.InitialShortcutData;
import com.l2jserver.gameserver.data.xml.impl.PlayerCreationPointData;
import com.l2jserver.gameserver.data.xml.impl.SkillTreesData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.appearance.PcAppearance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.stat.PcStat;
import com.l2jserver.gameserver.model.actor.templates.L2PcTemplate;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.events.Containers;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.BaseEvent;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerCreate;
import com.l2jserver.gameserver.model.items.PcItemTemplate;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.CharCreateFail;
import com.l2jserver.gameserver.network.serverpackets.CharCreateOk;
import com.l2jserver.gameserver.network.serverpackets.CharSelectionInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CharacterCreate
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(CharacterCreate.class);
    private static final Logger LOG_ACCOUNTING = LoggerFactory.getLogger("accounting");
    private static final String _C__0C_CHARACTERCREATE = "[C] 0C CharacterCreate";
    private static final int PLAYER_NAME_MAX_LENGHT = 16;
    private String _name;
    private int _race;
    private byte _sex;
    private int _classId;
    private int _int;
    private int _str;
    private int _con;
    private int _men;
    private int _dex;
    private int _wit;
    private byte _hairStyle;
    private byte _hairColor;
    private byte _face;

    @Override
    protected void readImpl() {
        this._name = this.readS();
        this._race = this.readD();
        this._sex = (byte)this.readD();
        this._classId = this.readD();
        this._int = this.readD();
        this._str = this.readD();
        this._con = this.readD();
        this._men = this.readD();
        this._dex = this.readD();
        this._wit = this.readD();
        this._hairStyle = (byte)this.readD();
        this._hairColor = (byte)this.readD();
        this._face = (byte)this.readD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        L2PcInstance newChar;
        if (this._name.isEmpty() || this._name.length() > 16) {
            if (Configuration.general().debug()) {
                LOG.debug("Character Creation Failure: Character name {} is invalid.", (Object)this._name);
            }
            this.sendPacket(new CharCreateFail(3));
            return;
        }
        if (Configuration.character().getForbiddenNames().contains(this._name.toLowerCase())) {
            this.sendPacket(new CharCreateFail(4));
            return;
        }
        if (!this.isValidName(this._name)) {
            this.sendPacket(new CharCreateFail(4));
            return;
        }
        if (this._name.isEmpty() || this._name.length() > 16) {
            this.sendPacket(new CharCreateFail(3));
            return;
        }
        if (this._face > 2 || this._face < 0) {
            LOG.warn("Character Creation Failure: Character face {} is invalid. Possible client hack. {}", (Object)this._face, (Object)this.getClient());
            this.sendPacket(new CharCreateFail(0));
            return;
        }
        if (this._hairStyle < 0 || this._sex == 0 && this._hairStyle > 4 || this._sex != 0 && this._hairStyle > 6) {
            LOG.warn("Character Creation Failure: Character hair style {} is invalid. Possible client hack. {}", (Object)this._hairStyle, (Object)this.getClient());
            this.sendPacket(new CharCreateFail(0));
            return;
        }
        if (this._hairColor > 3 || this._hairColor < 0) {
            LOG.warn("Character Creation Failure: Character hair color {} is invalid. Possible client hack. {}", (Object)this._hairColor, (Object)this.getClient());
            this.sendPacket(new CharCreateFail(0));
            return;
        }
        CharNameTable charNameTable = CharNameTable.getInstance();
        synchronized (charNameTable) {
            if (CharNameTable.getInstance().getAccountCharacterCount(((L2GameClient)this.getClient()).getAccountName()) >= Configuration.character().getCharMaxNumber() && Configuration.character().getCharMaxNumber() != 0) {
                if (Configuration.general().debug()) {
                    LOG.debug("Max number of characters reached. Creation failed.");
                }
                this.sendPacket(new CharCreateFail(1));
                return;
            }
            if (CharNameTable.getInstance().doesCharNameExist(this._name)) {
                if (Configuration.general().debug()) {
                    LOG.debug("Character Creation Failure: Message generated: You cannot create another character. Please delete the existing character and try again.");
                }
                this.sendPacket(new CharCreateFail(2));
                return;
            }
            if (ClassId.getClassId(this._classId).level() > 0) {
                LOG.warn("Character Creation Failure: {} classId: {}", (Object)this._name, (Object)this._classId);
                this.sendPacket(new CharCreateFail(0));
                return;
            }
            PcAppearance app = new PcAppearance(this._face, this._hairColor, this._hairStyle, this._sex != 0);
            newChar = L2PcInstance.create(this._classId, ((L2GameClient)this.getClient()).getAccountName(), this._name, app);
        }
        newChar.setCurrentHp(newChar.getMaxHp());
        newChar.setCurrentMp(newChar.getMaxMp());
        this.sendPacket(new CharCreateOk());
        this.initNewChar((L2GameClient)this.getClient(), newChar);
        LOG_ACCOUNTING.info("Created new character {} {}.", (Object)newChar, (Object)this.getClient());
    }

    private boolean isValidName(String text) {
        return Configuration.character().getPlayerNameTemplate().matcher(text).matches();
    }

    private void initNewChar(L2GameClient client, L2PcInstance newChar) {
        List<PcItemTemplate> initialItems;
        if (Configuration.general().debug()) {
            LOG.debug("Character init start");
        }
        L2World.getInstance().storeObject(newChar);
        if (Configuration.character().getStartingAdena() > 0) {
            newChar.addAdena("Init", Configuration.character().getStartingAdena(), null, false);
        }
        L2PcTemplate template = newChar.getTemplate();
        Location createLoc = PlayerCreationPointData.getInstance().getCreationPoint(template.getClassId());
        newChar.setXYZInvisible(createLoc.getX(), createLoc.getY(), createLoc.getZ());
        newChar.setTitle("");
        if (Configuration.vitality().enabled()) {
            newChar.setVitalityPoints(Math.min(Configuration.vitality().getStartingVitalityPoints(), PcStat.MAX_VITALITY_POINTS), true);
        }
        if (Configuration.character().getStartingLevel() > 1) {
            newChar.addLevel(Configuration.character().getStartingLevel() - 1);
        }
        if (Configuration.character().getStartingSP() > 0) {
            newChar.addSp(Configuration.character().getStartingSP());
        }
        if ((initialItems = InitialEquipmentData.getInstance().getEquipmentList(newChar.getClassId())) != null) {
            for (PcItemTemplate ie : initialItems) {
                L2ItemInstance item = newChar.getInventory().addItem("Init", ie.getId(), ie.getCount(), newChar, null);
                if (item == null) {
                    LOG.warn("Could not create item during char creation: itemId {}, amount {}.", (Object)ie.getId(), (Object)ie.getCount());
                    continue;
                }
                if (!item.isEquipable() || !ie.isEquipped()) continue;
                newChar.getInventory().equipItem(item);
            }
        }
        for (L2SkillLearn skill : SkillTreesData.getInstance().getAvailableSkills(newChar, newChar.getClassId(), false, true)) {
            if (Configuration.general().debug()) {
                LOG.debug("Adding starter skill:{} / {}", (Object)skill.getSkillId(), (Object)skill.getSkillLevel());
            }
            newChar.addSkill(SkillData.getInstance().getSkill(skill.getSkillId(), skill.getSkillLevel()), true);
        }
        InitialShortcutData.getInstance().registerAllShortcuts(newChar);
        EventDispatcher.getInstance().notifyEvent((BaseEvent)new PlayerCreate(newChar, newChar.getObjectId(), newChar.getName(), client), Containers.Players());
        newChar.setOnlineStatus(true, false);
        newChar.deleteMe();
        CharSelectionInfo cl = new CharSelectionInfo(client.getAccountName(), client.getSessionId().playOkID1);
        client.setCharSelection(cl.getCharInfo());
        if (Configuration.general().debug()) {
            LOG.debug("Character init end");
        }
    }

    @Override
    public String getType() {
        return _C__0C_CHARACTERCREATE;
    }
}

