/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.MultisellData;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.L2Augmentation;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.multisell.Entry;
import com.l2jserver.gameserver.model.multisell.Ingredient;
import com.l2jserver.gameserver.model.multisell.PreparedListContainer;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSellChoose
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(MultiSellChoose.class);
    private static final String _C__B0_MULTISELLCHOOSE = "[C] B0 MultiSellChoose";
    private int _listId;
    private int _entryId;
    private long _amount;
    private int _unk1;
    private int _unk2;
    private int _unk3;
    private int _unk4;
    private int _unk5;
    private int _unk6;
    private int _unk7;
    private int _unk8;
    private int _unk9;
    private int _unk10;
    private int _unk11;

    @Override
    protected void readImpl() {
        this._listId = this.readD();
        this._entryId = this.readD();
        this._amount = this.readQ();
        this._unk1 = this.readH();
        this._unk2 = this.readD();
        this._unk3 = this.readD();
        this._unk4 = this.readH();
        this._unk5 = this.readH();
        this._unk6 = this.readH();
        this._unk7 = this.readH();
        this._unk8 = this.readH();
        this._unk9 = this.readH();
        this._unk10 = this.readH();
        this._unk11 = this.readH();
    }

    @Override
    public void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getMultiSell().tryPerformAction("multisell choose")) {
            player.setMultiSell(null);
            return;
        }
        if (this._amount < 1L || this._amount > 5000L) {
            player.setMultiSell(null);
            return;
        }
        PreparedListContainer list = player.getMultiSell();
        if (list == null || list.getListId() != this._listId) {
            player.setMultiSell(null);
            return;
        }
        L2Npc npc = player.getLastFolkNPC();
        if (npc != null && !list.isNpcAllowed(npc.getId()) || npc == null && list.isNpcOnly()) {
            player.setMultiSell(null);
            return;
        }
        if (!(player.isGM() || npc == null || player.isInsideRadius(npc, 150, true, false) && player.getInstanceId() == npc.getInstanceId())) {
            player.setMultiSell(null);
            return;
        }
        for (Entry entry : list.getEntries()) {
            SystemMessage sm;
            if (entry.getEntryId() != this._entryId) continue;
            if (!entry.isStackable() && this._amount > 1L) {
                LOG.error("Character: {} is trying to set amount > 1 on non-stackable multisell, id:{}:{}", player.getName(), this._listId, this._entryId);
                player.setMultiSell(null);
                return;
            }
            PcInventory inv = player.getInventory();
            int slots = 0;
            int weight = 0;
            for (Ingredient e : entry.getProducts()) {
                if (e.getItemId() < 0) continue;
                if (!e.isStackable()) {
                    slots = (int)((long)slots + e.getItemCount() * this._amount);
                } else if (player.getInventory().getItemByItemId(e.getItemId()) == null) {
                    ++slots;
                }
                weight = (int)((long)weight + e.getItemCount() * this._amount * (long)e.getWeight());
            }
            if (!inv.validateWeight(weight)) {
                player.sendPacket(SystemMessageId.WEIGHT_LIMIT_EXCEEDED);
                return;
            }
            if (!inv.validateCapacity(slots)) {
                player.sendPacket(SystemMessageId.SLOTS_FULL);
                return;
            }
            ArrayList<Ingredient> ingredientsList = new ArrayList<Ingredient>(entry.getIngredients().size());
            for (Ingredient e : entry.getIngredients()) {
                boolean newIng = true;
                int i = ingredientsList.size();
                while (--i >= 0) {
                    Ingredient ex = (Ingredient)ingredientsList.get(i);
                    if (ex.getItemId() != e.getItemId() || ex.getEnchantLevel() != e.getEnchantLevel()) continue;
                    if (ex.getItemCount() + e.getItemCount() > Integer.MAX_VALUE) {
                        player.sendPacket(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED);
                        return;
                    }
                    Ingredient ing = ex.getCopy();
                    ing.setItemCount(ex.getItemCount() + e.getItemCount());
                    ingredientsList.set(i, ing);
                    newIng = false;
                    break;
                }
                if (!newIng) continue;
                ingredientsList.add(e);
            }
            for (Ingredient e : ingredientsList) {
                if (e.getItemCount() * this._amount > Integer.MAX_VALUE) {
                    player.sendPacket(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED);
                    return;
                }
                if (e.getItemId() < 0) {
                    if (MultisellData.hasSpecialIngredient(e.getItemId(), e.getItemCount() * this._amount, player)) continue;
                    return;
                }
                long required = Configuration.character().blacksmithUseRecipes() || !e.getMaintainIngredient() ? e.getItemCount() * this._amount : e.getItemCount();
                if (inv.getInventoryItemCount(e.getItemId(), list.getMaintainEnchantment() ? e.getEnchantLevel() : -1, false) >= required) continue;
                sm = SystemMessage.getSystemMessage(SystemMessageId.S2_UNIT_OF_THE_ITEM_S1_REQUIRED);
                sm.addItemName(e.getTemplate());
                sm.addLong(required);
                player.sendPacket(sm);
                return;
            }
            ArrayList<L2Augmentation> augmentation = new ArrayList<L2Augmentation>();
            Elementals[] elemental = null;
            for (Ingredient e : entry.getIngredients()) {
                if (e.getItemId() < 0) {
                    if (MultisellData.takeSpecialIngredient(e.getItemId(), e.getItemCount() * this._amount, player)) continue;
                    return;
                }
                L2ItemInstance itemToTake = inv.getItemByItemId(e.getItemId());
                if (itemToTake == null) {
                    LOG.error("Character: {} is trying to cheat in multisell, id:{}:{}", player.getName(), this._listId, this._entryId);
                    player.setMultiSell(null);
                    return;
                }
                if (!Configuration.character().blacksmithUseRecipes() && e.getMaintainIngredient()) continue;
                if (itemToTake.isStackable()) {
                    if (player.destroyItem("Multisell", itemToTake.getObjectId(), e.getItemCount() * this._amount, player.getTarget(), true)) continue;
                    player.setMultiSell(null);
                    return;
                }
                if (list.getMaintainEnchantment()) {
                    L2ItemInstance[] inventoryContents = inv.getAllItemsByItemId(e.getItemId(), e.getEnchantLevel(), false);
                    int i = 0;
                    while ((long)i < e.getItemCount() * this._amount) {
                        if (inventoryContents[i].isAugmented()) {
                            augmentation.add(inventoryContents[i].getAugmentation());
                        }
                        if (inventoryContents[i].getElementals() != null) {
                            elemental = inventoryContents[i].getElementals();
                        }
                        if (!player.destroyItem("Multisell", inventoryContents[i].getObjectId(), 1L, player.getTarget(), true)) {
                            player.setMultiSell(null);
                            return;
                        }
                        ++i;
                    }
                    continue;
                }
                int i = 1;
                while ((long)i <= e.getItemCount() * this._amount) {
                    L2ItemInstance[] inventoryContents = inv.getAllItemsByItemId(e.getItemId(), false);
                    itemToTake = inventoryContents[0];
                    if (itemToTake.getEnchantLevel() > 0) {
                        L2ItemInstance item;
                        L2ItemInstance[] l2ItemInstanceArray = inventoryContents;
                        int n = l2ItemInstanceArray.length;
                        for (int j = 0; j < n && ((item = l2ItemInstanceArray[j]).getEnchantLevel() >= itemToTake.getEnchantLevel() || (itemToTake = item).getEnchantLevel() != 0); ++j) {
                        }
                    }
                    if (!player.destroyItem("Multisell", itemToTake.getObjectId(), 1L, player.getTarget(), true)) {
                        player.setMultiSell(null);
                        return;
                    }
                    ++i;
                }
            }
            for (Ingredient e : entry.getProducts()) {
                if (e.getItemId() < 0) {
                    MultisellData.giveSpecialProduct(e.getItemId(), e.getItemCount() * this._amount, player);
                    continue;
                }
                if (e.isStackable()) {
                    inv.addItem("Multisell", e.getItemId(), e.getItemCount() * this._amount, player, player.getTarget());
                } else {
                    int i = 0;
                    while ((long)i < e.getItemCount() * this._amount) {
                        L2ItemInstance product = inv.addItem("Multisell", e.getItemId(), 1L, player, player.getTarget());
                        if (product != null && list.getMaintainEnchantment()) {
                            if (i < augmentation.size()) {
                                product.setAugmentation(new L2Augmentation(((L2Augmentation)augmentation.get(i)).getAugmentationId()));
                            }
                            if (elemental != null) {
                                for (Elementals elm : elemental) {
                                    product.setElementAttr(elm.getElement(), elm.getValue());
                                }
                            }
                            product.setEnchantLevel(e.getEnchantLevel());
                            product.updateDatabase();
                        }
                        ++i;
                    }
                }
                if (e.getItemCount() * this._amount > 1L) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
                    sm.addItemName(e.getItemId());
                    sm.addLong(e.getItemCount() * this._amount);
                    player.sendPacket(sm);
                    continue;
                }
                if (list.getMaintainEnchantment() && e.getEnchantLevel() > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.ACQUIRED_S1_S2);
                    sm.addLong(e.getEnchantLevel());
                    sm.addItemName(e.getItemId());
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
                    sm.addItemName(e.getItemId());
                }
                player.sendPacket(sm);
            }
            player.sendPacket(new ItemList(player, false));
            StatusUpdate su = new StatusUpdate(player);
            su.addAttribute(14, player.getCurrentLoad());
            player.sendPacket(su);
            if (npc == null || entry.getTaxAmount() <= 0L) break;
            npc.getCastle().addToTreasury(entry.getTaxAmount() * this._amount);
            break;
        }
    }

    @Override
    public String getType() {
        return _C__B0_MULTISELLCHOOSE;
    }
}

