/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.data.sql.impl.PetNameTable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;

public final class RequestChangePetName
extends L2GameClientPacket {
    private static final String _C__93_REQUESTCHANGEPETNAME = "[C] 93 RequestChangePetName";
    private static final int PET_NAME_MAX_LENGTH = 16;
    private String _name;

    @Override
    protected void readImpl() {
        this._name = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Summon pet = activeChar.getSummon();
        if (pet == null) {
            return;
        }
        if (!pet.isPet()) {
            activeChar.sendPacket(SystemMessageId.DONT_HAVE_PET);
            return;
        }
        if (pet.getName() != null) {
            activeChar.sendPacket(SystemMessageId.NAMING_YOU_CANNOT_SET_NAME_OF_THE_PET);
            return;
        }
        if (PetNameTable.getInstance().doesPetNameExist(this._name)) {
            activeChar.sendPacket(SystemMessageId.NAMING_ALREADY_IN_USE_BY_ANOTHER_PET);
            return;
        }
        if (this._name.isEmpty() || this._name.length() > 16) {
            activeChar.sendPacket(SystemMessageId.NAMING_CHARNAME_UP_TO_16CHARS);
            return;
        }
        if (!PetNameTable.getInstance().isValidPetName(this._name)) {
            activeChar.sendPacket(SystemMessageId.NAMING_PETNAME_CONTAINS_INVALID_CHARS);
            return;
        }
        pet.setName(this._name);
        pet.updateAndBroadcastStatus(1);
    }

    @Override
    public String getType() {
        return _C__93_REQUESTCHANGEPETNAME;
    }
}

