/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.EnchantSkillGroupsData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfoDetail;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillResult;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestExEnchantSkillRouteChange
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestExEnchantSkillRouteChange.class);
    private static final Logger LOG_ENCHANT_SKILL = LoggerFactory.getLogger("enchant_skill");
    private static final String _C__D0_34_REQUESTEXENCHANTSKILLROUTECHANGE = "[C] D0:34 RequestExEnchantSkillRouteChange";
    private int _skillId;
    private int _skillLvl;

    @Override
    protected void readImpl() {
        this._skillId = this.readD();
        this._skillLvl = this.readD();
    }

    @Override
    protected void runImpl() {
        if (this._skillId <= 0 || this._skillLvl <= 0) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.getClassId().level() < 3) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_IN_THIS_CLASS);
            return;
        }
        if (player.getLevel() < 76) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ON_THIS_LEVEL);
            return;
        }
        if (!player.isAllowedToEnchantSkills()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ATTACKING_TRANSFORMED_BOAT);
            return;
        }
        Skill skill = SkillData.getInstance().getSkill(this._skillId, this._skillLvl);
        if (skill == null) {
            return;
        }
        int reqItemId = 9626;
        L2EnchantSkillLearn s = EnchantSkillGroupsData.getInstance().getSkillEnchantmentBySkillId(this._skillId);
        if (s == null) {
            return;
        }
        int beforeEnchantSkillLevel = player.getSkillLevel(this._skillId);
        if (beforeEnchantSkillLevel <= 100) {
            return;
        }
        int currentEnchantLevel = beforeEnchantSkillLevel % 100;
        if (currentEnchantLevel != this._skillLvl % 100) {
            return;
        }
        L2EnchantSkillGroup.EnchantSkillHolder esd = s.getEnchantSkillHolder(this._skillLvl);
        int requiredSp = esd.getSpCost();
        int requireditems = esd.getAdenaCost();
        if (player.getSp() >= requiredSp) {
            L2ItemInstance spb = player.getInventory().getItemByItemId(reqItemId);
            if (Configuration.character().enchantSkillSpBookNeeded() && spb == null) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_ITENS_NEEDED_TO_CHANGE_SKILL_ENCHANT_ROUTE);
                return;
            }
            if (player.getInventory().getAdena() < (long)requireditems) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
                return;
            }
            boolean check = player.removeSp(requiredSp);
            if (Configuration.character().enchantSkillSpBookNeeded()) {
                check &= player.destroyItem("Consume", spb.getObjectId(), 1L, (L2Object)player, true);
            }
            if (!(check &= player.destroyItemByItemId("Consume", 57, requireditems, player, true))) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
                return;
            }
            int levelPenalty = Rnd.get((int)Math.min(4, currentEnchantLevel));
            this._skillLvl -= levelPenalty;
            if (this._skillLvl % 100 == 0) {
                this._skillLvl = s.getBaseLevel();
            }
            if ((skill = SkillData.getInstance().getSkill(this._skillId, this._skillLvl)) != null) {
                if (Configuration.general().logSkillEnchants()) {
                    LOG_ENCHANT_SKILL.info("ROUTE_CHANGED {} using {} by {}.", skill, spb, player);
                }
                player.addSkill(skill, true);
                player.sendPacket(ExEnchantSkillResult.valueOf(true));
            }
            if (Configuration.general().debug()) {
                LOG.debug("Learned skill ID: {} Level: {} for {} SP, {} Adena.", this._skillId, this._skillLvl, requiredSp, requireditems);
            }
            player.sendPacket(new UserInfo(player));
            player.sendPacket(new ExBrExtraUserInfo(player));
            if (levelPenalty == 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.SKILL_ENCHANT_CHANGE_SUCCESSFUL_S1_LEVEL_WILL_REMAIN);
                sm.addSkillName(this._skillId);
                player.sendPacket(sm);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.SKILL_ENCHANT_CHANGE_SUCCESSFUL_S1_LEVEL_WAS_DECREASED_BY_S2);
                sm.addSkillName(this._skillId);
                sm.addInt(levelPenalty);
                player.sendPacket(sm);
            }
            player.sendSkillList();
            int afterEnchantSkillLevel = player.getSkillLevel(this._skillId);
            player.sendPacket(new ExEnchantSkillInfo(this._skillId, afterEnchantSkillLevel));
            player.sendPacket(new ExEnchantSkillInfoDetail(3, this._skillId, afterEnchantSkillLevel, player));
            player.updateShortCuts(this._skillId, afterEnchantSkillLevel);
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DONT_HAVE_ENOUGH_SP_TO_ENCHANT_THAT_SKILL);
            player.sendPacket(sm);
        }
    }

    @Override
    public String getType() {
        return _C__D0_34_REQUESTEXENCHANTSKILLROUTECHANGE;
    }
}

