/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.FriendPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestFriendDel
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestFriendDel.class);
    private static final String _C__7A_REQUESTFRIENDDEL = "[C] 7A RequestFriendDel";
    private String _name;

    @Override
    protected void readImpl() {
        this._name = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        int id = CharNameTable.getInstance().getIdByName(this._name);
        if (id == -1) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_NOT_ON_YOUR_FRIENDS_LIST);
            sm.addString(this._name);
            activeChar.sendPacket(sm);
            return;
        }
        if (!activeChar.isFriend(id)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_NOT_ON_YOUR_FRIENDS_LIST);
            sm.addString(this._name);
            activeChar.sendPacket(sm);
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM character_friends WHERE (charId=? AND friendId=?) OR (charId=? AND friendId=?)");){
            ps.setInt(1, activeChar.getObjectId());
            ps.setInt(2, id);
            ps.setInt(3, id);
            ps.setInt(4, activeChar.getObjectId());
            ps.execute();
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_BEEN_DELETED_FROM_YOUR_FRIENDS_LIST);
            sm.addString(this._name);
            activeChar.sendPacket(sm);
            activeChar.removeFriend(id);
            activeChar.sendPacket(new FriendPacket(false, id));
            L2PcInstance friend = L2World.getInstance().getPlayer(this._name);
            if (friend != null) {
                friend.removeFriend(activeChar.getObjectId());
                friend.sendPacket(new FriendPacket(false, activeChar.getObjectId()));
            }
        }
        catch (Exception e) {
            LOG.warn("Could not del friend objectid: ", e);
        }
    }

    @Override
    public String getType() {
        return _C__7A_REQUESTFRIENDDEL;
    }
}

