/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;

public class RequestGiveNickName
extends L2GameClientPacket {
    private static final String _C__0B_REQUESTGIVENICKNAME = "[C] 0B RequestGiveNickName";
    private String _target;
    private String _title;

    @Override
    protected void readImpl() {
        this._target = this.readS();
        this._title = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.isNoble() && this._target.equalsIgnoreCase(activeChar.getName())) {
            activeChar.setTitle(this._title);
            activeChar.sendPacket(SystemMessageId.TITLE_CHANGED);
            activeChar.broadcastTitleInfo();
        } else {
            if (!activeChar.hasClanPrivilege(ClanPrivilege.CL_GIVE_TITLE)) {
                activeChar.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
                return;
            }
            if (activeChar.getClan().getLevel() < 3) {
                activeChar.sendPacket(SystemMessageId.CLAN_LVL_3_NEEDED_TO_ENDOWE_TITLE);
                return;
            }
            L2ClanMember member1 = activeChar.getClan().getClanMember(this._target);
            if (member1 != null) {
                L2PcInstance member = member1.getPlayerInstance();
                if (member != null) {
                    member.setTitle(this._title);
                    member.sendPacket(SystemMessageId.TITLE_CHANGED);
                    member.broadcastTitleInfo();
                } else {
                    activeChar.sendPacket(SystemMessageId.TARGET_IS_NOT_FOUND_IN_THE_GAME);
                }
            } else {
                activeChar.sendPacket(SystemMessageId.TARGET_MUST_BE_IN_CLAN);
            }
        }
    }

    @Override
    public String getType() {
        return _C__0B_REQUESTGIVENICKNAME;
    }
}

