/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.AskJoinAlly;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestJoinAlly
extends L2GameClientPacket {
    private static final String _C__8C_REQUESTJOINALLY = "[C] 8C RequestJoinAlly";
    private int _id;

    @Override
    protected void readImpl() {
        this._id = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        L2PcInstance targetPlayer = L2World.getInstance().getPlayer(this._id);
        if (targetPlayer == null) {
            player.sendPacket(SystemMessageId.YOU_HAVE_INVITED_THE_WRONG_TARGET);
            return;
        }
        L2Clan clan = player.getClan();
        if (clan == null) {
            player.sendPacket(SystemMessageId.YOU_ARE_NOT_A_CLAN_MEMBER);
            return;
        }
        if (!clan.checkAllyJoinCondition(player, targetPlayer)) {
            return;
        }
        if (!player.getRequest().setRequest(targetPlayer, this)) {
            return;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_ALLIANCE_LEADER_OF_S1_REQUESTED_ALLIANCE);
        sm.addString(player.getClan().getAllyName());
        sm.addString(player.getName());
        targetPlayer.sendPacket(sm);
        targetPlayer.sendPacket(new AskJoinAlly(player.getObjectId(), player.getClan().getAllyName()));
    }

    @Override
    public String getType() {
        return _C__8C_REQUESTJOINALLY;
    }
}

