/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.PartyMatchWaitingList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExClosePartyRoom;
import com.l2jserver.gameserver.network.serverpackets.ListPartyWaiting;

public final class RequestOustFromPartyRoom
extends L2GameClientPacket {
    private static final String _C__D0_09_REQUESTOUSTFROMPARTYROOM = "[C] D0:09 RequestOustFromPartyRoom";
    private int _charid;

    @Override
    protected void readImpl() {
        this._charid = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = this.getActiveChar();
        if (player == null) {
            return;
        }
        L2PcInstance member = L2World.getInstance().getPlayer(this._charid);
        if (member == null) {
            return;
        }
        PartyMatchRoom room = PartyMatchRoomList.getInstance().getPlayerRoom(member);
        if (room == null || room.getOwner() != player) {
            return;
        }
        if (player.isInParty() && member.isInParty() && player.getParty().getLeaderObjectId() == member.getParty().getLeaderObjectId()) {
            player.sendPacket(SystemMessageId.CANNOT_DISMISS_PARTY_MEMBER);
        } else {
            room.deleteMember(member);
            member.setPartyRoom(0);
            member.sendPacket(new ExClosePartyRoom());
            PartyMatchWaitingList.getInstance().addPlayer(member);
            int loc = 0;
            member.sendPacket(new ListPartyWaiting(member, 0, loc, member.getLevel()));
            member.broadcastUserInfo();
            member.sendPacket(SystemMessageId.OUSTED_FROM_PARTY_ROOM);
        }
    }

    @Override
    public String getType() {
        return _C__D0_09_REQUESTOUSTFROMPARTYROOM;
    }
}

