/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.PetItemList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestPetUseItem
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestPetUseItem.class);
    private static final String _C__8A_REQUESTPETUSEITEM = "[C] 8A RequestPetUseItem";
    private int _objectId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    protected void runImpl() {
        long reuse;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null || !activeChar.hasPet()) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getUseItem().tryPerformAction("pet use item")) {
            return;
        }
        L2PetInstance pet = (L2PetInstance)activeChar.getSummon();
        L2ItemInstance item = pet.getInventory().getItemByObjectId(this._objectId);
        if (item == null) {
            return;
        }
        if (!item.getItem().isForNpc()) {
            activeChar.sendPacket(SystemMessageId.PET_CANNOT_USE_ITEM);
            return;
        }
        if (activeChar.isAlikeDead() || pet.isDead()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addItemName(item);
            activeChar.sendPacket(sm);
            return;
        }
        int reuseDelay = item.getReuseDelay();
        if (reuseDelay > 0 && (reuse = pet.getItemRemainingReuseTime(item.getObjectId())) > 0L) {
            return;
        }
        if (!item.isEquipped() && !item.getItem().checkCondition(pet, pet, true)) {
            return;
        }
        this.useItem(pet, item, activeChar);
    }

    private void useItem(L2PetInstance pet, L2ItemInstance item, L2PcInstance activeChar) {
        if (item.isEquipable()) {
            if (!item.getItem().isConditionAttached()) {
                activeChar.sendPacket(SystemMessageId.PET_CANNOT_USE_ITEM);
                return;
            }
            if (item.isEquipped()) {
                pet.getInventory().unEquipItemInSlot(item.getLocationSlot());
            } else {
                pet.getInventory().equipItem(item);
            }
            activeChar.sendPacket(new PetItemList(pet.getInventory().getItems()));
            pet.updateAndBroadcastStatus(1);
        } else {
            IItemHandler handler = ItemHandler.getInstance().getHandler(item.getEtcItem());
            if (handler != null) {
                if (handler.useItem(pet, item, false)) {
                    int reuseDelay = item.getReuseDelay();
                    if (reuseDelay > 0) {
                        activeChar.addTimeStampItem(item, reuseDelay);
                    }
                    pet.updateAndBroadcastStatus(1);
                }
            } else {
                activeChar.sendPacket(SystemMessageId.PET_CANNOT_USE_ITEM);
                LOG.warn("No item handler registered for itemId: {}", (Object)item.getId());
            }
        }
    }

    @Override
    public String getType() {
        return _C__8A_REQUESTPETUSEITEM;
    }
}

