/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.BuyListData;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.buylist.L2BuyList;
import com.l2jserver.gameserver.model.buylist.Product;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.type.ArmorType;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ShopPreviewInfo;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.Util;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestPreviewItem
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestPreviewItem.class);
    private static final String _C__C7_REQUESTPREVIEWITEM = "[C] C7 RequestPreviewItem";
    private int _unk;
    private int _listId;
    private int _count;
    private int[] _items;

    @Override
    protected void readImpl() {
        this._unk = this.readD();
        this._listId = this.readD();
        this._count = this.readD();
        if (this._count < 0) {
            this._count = 0;
        }
        if (this._count > 100) {
            return;
        }
        this._items = new int[this._count];
        for (int i = 0; i < this._count; ++i) {
            this._items[i] = this.readD();
        }
    }

    @Override
    protected void runImpl() {
        L2MerchantInstance merchant;
        if (this._items == null) {
            return;
        }
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("buy")) {
            activeChar.sendMessage("You are buying too fast.");
            return;
        }
        if (!Configuration.character().karmaPlayerCanShop() && activeChar.getKarma() > 0) {
            return;
        }
        L2Object target = activeChar.getTarget();
        if (!(activeChar.isGM() || target instanceof L2MerchantInstance && activeChar.isInsideRadius(target, 150, false, false))) {
            return;
        }
        if (this._count < 1 || this._listId >= 4000000) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2MerchantInstance l2MerchantInstance = merchant = target instanceof L2MerchantInstance ? (L2MerchantInstance)target : null;
        if (merchant == null) {
            LOG.warn("Null merchant!");
            return;
        }
        L2BuyList buyList = BuyListData.getInstance().getBuyList(this._listId);
        if (buyList == null) {
            Util.handleIllegalPlayerAction(activeChar, "Warning!! Character " + activeChar.getName() + " of account " + activeChar.getAccountName() + " sent a false BuyList list_id " + this._listId);
            return;
        }
        long totalPrice = 0L;
        HashMap<Integer, Integer> itemList = new HashMap<Integer, Integer>();
        for (int i = 0; i < this._count; ++i) {
            int slot;
            int itemId = this._items[i];
            Product product = buyList.getProductByItemId(itemId);
            if (product == null) {
                Util.handleIllegalPlayerAction(activeChar, "Warning!! Character " + activeChar.getName() + " of account " + activeChar.getAccountName() + " sent a false BuyList list_id " + this._listId + " and item_id " + itemId);
                return;
            }
            L2Item template = product.getItem();
            if (template == null || (slot = Inventory.getPaperdollIndex(template.getBodyPart())) < 0 || (!(template instanceof L2Weapon) ? template instanceof L2Armor && activeChar.getRace().ordinal() == 5 && (template.getItemType() == ArmorType.HEAVY || template.getItemType() == ArmorType.MAGIC) : activeChar.getRace().ordinal() == 5 && (template.getItemType() == WeaponType.NONE || template.getItemType() == WeaponType.RAPIER || template.getItemType() == WeaponType.CROSSBOW || template.getItemType() == WeaponType.ANCIENTSWORD))) continue;
            if (itemList.containsKey(slot)) {
                activeChar.sendPacket(SystemMessageId.YOU_CAN_NOT_TRY_THOSE_ITEMS_ON_AT_THE_SAME_TIME);
                return;
            }
            itemList.put(slot, itemId);
            if ((totalPrice += (long)Configuration.general().getWearPrice()) <= Configuration.character().getMaxAdena()) continue;
            Util.handleIllegalPlayerAction(activeChar, "Warning!! Character " + activeChar.getName() + " of account " + activeChar.getAccountName() + " tried to purchase over " + Configuration.character().getMaxAdena() + " adena worth of goods.");
            return;
        }
        if (totalPrice < 0L || !activeChar.reduceAdena("Wear", totalPrice, activeChar.getLastFolkNPC(), true)) {
            activeChar.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            return;
        }
        if (!itemList.isEmpty()) {
            activeChar.sendPacket(new ShopPreviewInfo(itemList));
            ThreadPoolManager.getInstance().scheduleGeneral(new RemoveWearItemsTask(activeChar), Configuration.general().getWearDelay());
        }
    }

    @Override
    public String getType() {
        return _C__C7_REQUESTPREVIEWITEM;
    }

    private static class RemoveWearItemsTask
    implements Runnable {
        private final L2PcInstance activeChar;

        protected RemoveWearItemsTask(L2PcInstance player) {
            this.activeChar = player;
        }

        @Override
        public void run() {
            try {
                this.activeChar.sendPacket(SystemMessageId.NO_LONGER_TRYING_ON);
                this.activeChar.sendPacket(new UserInfo(this.activeChar));
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }
}

