/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.ItemRequest;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.util.Util;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestPrivateStoreBuy
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestPrivateStoreBuy.class);
    private static final String _C__83_REQUESTPRIVATESTOREBUY = "[C] 83 RequestPrivateStoreBuy";
    private static final int BATCH_LENGTH = 20;
    private int _storePlayerId;
    private Set<ItemRequest> _items = null;

    @Override
    protected void readImpl() {
        this._storePlayerId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > MAX_ITEM_IN_PACKET || count * 20 != this._buf.remaining()) {
            return;
        }
        this._items = new HashSet<ItemRequest>();
        for (int i = 0; i < count; ++i) {
            int objectId = this.readD();
            long cnt = this.readQ();
            long price = this.readQ();
            if (objectId < 1 || cnt < 1L || price < 0L) {
                this._items = null;
                return;
            }
            this._items.add(new ItemRequest(objectId, cnt, price));
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = this.getActiveChar();
        if (player == null) {
            return;
        }
        if (this._items == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("privatestorebuy")) {
            player.sendMessage("You are buying items too fast.");
            return;
        }
        L2PcInstance storePlayer = L2World.getInstance().getPlayer(this._storePlayerId);
        if (storePlayer == null) {
            return;
        }
        if (player.isCursedWeaponEquipped()) {
            return;
        }
        if (!player.isInsideRadius(storePlayer, 150, true, false)) {
            return;
        }
        if (player.getInstanceId() != storePlayer.getInstanceId() && player.getInstanceId() != -1) {
            return;
        }
        if (storePlayer.getPrivateStoreType() != PrivateStoreType.SELL && storePlayer.getPrivateStoreType() != PrivateStoreType.PACKAGE_SELL) {
            return;
        }
        TradeList storeList = storePlayer.getSellList();
        if (storeList == null) {
            return;
        }
        if (!player.getAccessLevel().allowTransaction()) {
            player.sendMessage("Transactions are disabled for your Access Level.");
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (storePlayer.getPrivateStoreType() == PrivateStoreType.PACKAGE_SELL && storeList.getItemCount() > this._items.size()) {
            String msgErr = "[RequestPrivateStoreBuy] player " + ((L2GameClient)this.getClient()).getActiveChar().getName() + " tried to buy less items than sold by package-sell, ban this player for bot usage!";
            Util.handleIllegalPlayerAction(((L2GameClient)this.getClient()).getActiveChar(), msgErr);
            return;
        }
        int result = storeList.privateStoreBuy(player, this._items);
        if (result > 0) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            if (result > 1) {
                LOG.warn("PrivateStore buy has failed due to invalid list or request. Player: {}, Private store of: {}", (Object)player.getName(), (Object)storePlayer.getName());
            }
            return;
        }
        if (storeList.getItemCount() == 0) {
            storePlayer.setPrivateStoreType(PrivateStoreType.NONE);
            storePlayer.broadcastUserInfo();
        }
    }

    @Override
    public String getType() {
        return _C__83_REQUESTPRIVATESTOREBUY;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

