/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestSurrenderPledgeWar
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSurrenderPledgeWar.class);
    private static final String _C__07_REQUESTSURRENDERPLEDGEWAR = "[C] 07 RequestSurrenderPledgeWar";
    private String _pledgeName;

    @Override
    protected void readImpl() {
        this._pledgeName = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        L2Clan _clan = player.getClan();
        if (_clan == null) {
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClanByName(this._pledgeName);
        if (clan == null) {
            player.sendMessage("No such clan.");
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        LOG.info("RequestSurrenderPledgeWar by {} with {}", (Object)_clan.getName(), (Object)this._pledgeName);
        if (!_clan.isAtWarWith(clan.getId())) {
            player.sendMessage("You aren't at war with this clan.");
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_SURRENDERED_TO_THE_S1_CLAN);
        msg.addString(this._pledgeName);
        player.sendPacket(msg);
        ClanTable.getInstance().deleteclanswars(_clan.getId(), clan.getId());
    }

    @Override
    public String getType() {
        return _C__07_REQUESTSURRENDERPLEDGEWAR;
    }
}

