/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2EtcItem;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUnEquipItem
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestUnEquipItem.class);
    private static final String _C__16_REQUESTUNEQUIPITEM = "[C] 16 RequestUnequipItem";
    private int _slot;

    @Override
    protected void readImpl() {
        this._slot = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar;
        if (Configuration.general().debug()) {
            LOG.debug("Request unequip slot {}", (Object)this._slot);
        }
        if ((activeChar = ((L2GameClient)this.getClient()).getActiveChar()) == null) {
            return;
        }
        L2ItemInstance item = activeChar.getInventory().getPaperdollItemByL2ItemId(this._slot);
        if (item == null) {
            return;
        }
        if (activeChar.isAttackingNow() || activeChar.isCastingNow() || activeChar.isCastingSimultaneouslyNow()) {
            activeChar.sendPacket(SystemMessageId.CANNOT_CHANGE_WEAPON_DURING_AN_ATTACK);
            return;
        }
        if (this._slot == 256 && item.getItem() instanceof L2EtcItem) {
            return;
        }
        if (this._slot == 16384 && (activeChar.isCursedWeaponEquipped() || activeChar.isCombatFlagEquipped())) {
            return;
        }
        if (activeChar.isStunned() || activeChar.isSleeping() || activeChar.isAlikeDead()) {
            return;
        }
        if (!activeChar.getInventory().canManipulateWithItemId(item.getId())) {
            activeChar.sendPacket(SystemMessageId.ITEM_CANNOT_BE_TAKEN_OFF);
            return;
        }
        if (item.isWeapon() && item.getWeaponItem().isForceEquip() && !activeChar.canOverrideCond(PcCondOverride.ITEM_CONDITIONS)) {
            activeChar.sendPacket(SystemMessageId.ITEM_CANNOT_BE_TAKEN_OFF);
            return;
        }
        L2ItemInstance[] unequipped = activeChar.getInventory().unEquipItemInBodySlotAndRecord(this._slot);
        activeChar.broadcastUserInfo();
        if (unequipped.length > 0) {
            SystemMessage sm;
            if (unequipped[0].getEnchantLevel() > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                sm.addInt(unequipped[0].getEnchantLevel());
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
            }
            sm.addItemName(unequipped[0]);
            activeChar.sendPacket(sm);
            InventoryUpdate iu = new InventoryUpdate();
            iu.addItems(Arrays.asList(unequipped));
            activeChar.sendPacket(iu);
        }
    }

    @Override
    public String getType() {
        return _C__16_REQUESTUNEQUIPITEM;
    }
}

