/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SendTradeRequest;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TradeRequest
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(TradeRequest.class);
    private int _objectId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    protected void runImpl() {
        SystemMessage sm;
        L2Object target;
        L2PcInstance player = this.getActiveChar();
        if (player == null) {
            return;
        }
        if (!player.getAccessLevel().allowTransaction()) {
            player.sendMessage("Transactions are disabled for your current Access Level.");
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        BuffInfo info = player.getEffectList().getBuffInfoByAbnormalType(AbnormalType.BOT_PENALTY);
        if (info != null) {
            for (AbstractEffect effect : info.getEffects()) {
                if (effect.checkCondition(-2)) continue;
                player.sendPacket(SystemMessageId.YOU_HAVE_BEEN_REPORTED_SO_ACTIONS_NOT_ALLOWED);
                player.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        }
        if ((target = L2World.getInstance().findObject(this._objectId)) == null || !player.getKnownList().knowsObject(target) || target.getInstanceId() != player.getInstanceId() && player.getInstanceId() != -1) {
            return;
        }
        if (target.getObjectId() == player.getObjectId()) {
            player.sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
            return;
        }
        if (!target.isPlayer()) {
            player.sendPacket(SystemMessageId.INCORRECT_TARGET);
            return;
        }
        L2PcInstance partner = target.getActingPlayer();
        if (partner.isInOlympiadMode() || player.isInOlympiadMode()) {
            player.sendMessage("A user currently participating in the Olympiad cannot accept or request a trade.");
            return;
        }
        info = partner.getEffectList().getBuffInfoByAbnormalType(AbnormalType.BOT_PENALTY);
        if (info != null) {
            for (AbstractEffect effect : info.getEffects()) {
                if (effect.checkCondition(-2)) continue;
                SystemMessage sm2 = SystemMessage.getSystemMessage(SystemMessageId.C1_REPORTED_AND_IS_BEING_INVESTIGATED);
                sm2.addCharName(partner);
                player.sendPacket(sm2);
                player.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        }
        if (!Configuration.character().karmaPlayerCanTrade() && player.getKarma() > 0) {
            player.sendMessage("You cannot trade while you are in a chaotic state.");
            return;
        }
        if (!Configuration.character().karmaPlayerCanTrade() && partner.getKarma() > 0) {
            player.sendMessage("You cannot request a trade while your target is in a chaotic state.");
            return;
        }
        if (Configuration.general().jailDisableTransaction() && (player.isJailed() || partner.isJailed())) {
            player.sendMessage("You cannot trade while you are in in Jail.");
            return;
        }
        if (player.getPrivateStoreType() != PrivateStoreType.NONE || partner.getPrivateStoreType() != PrivateStoreType.NONE) {
            player.sendPacket(SystemMessageId.CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE);
            return;
        }
        if (player.isProcessingTransaction()) {
            if (Configuration.general().debug()) {
                LOG.debug("Already trading with someone else.");
            }
            player.sendPacket(SystemMessageId.ALREADY_TRADING);
            return;
        }
        if (partner.isProcessingRequest() || partner.isProcessingTransaction()) {
            if (Configuration.general().debug()) {
                LOG.info("Transaction already in progress.");
            }
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
            sm.addString(partner.getName());
            player.sendPacket(sm);
            return;
        }
        if (partner.getTradeRefusal()) {
            player.sendMessage("That person is in trade refusal mode.");
            return;
        }
        if (BlockList.isBlocked(partner, player)) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_ADDED_YOU_TO_IGNORE_LIST);
            sm.addCharName(partner);
            player.sendPacket(sm);
            return;
        }
        if (player.calculateDistance(partner, true, false) > 150.0) {
            player.sendPacket(SystemMessageId.TARGET_TOO_FAR);
            return;
        }
        player.onTransactionRequest(partner);
        partner.sendPacket(new SendTradeRequest(player.getObjectId()));
        sm = SystemMessage.getSystemMessage(SystemMessageId.REQUEST_C1_FOR_TRADE);
        sm.addString(partner.getName());
        player.sendPacket(sm);
    }

    @Override
    public String getType() {
        return "[C] 1A TradeRequest";
    }
}

