/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.GetOnVehicle;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatePosition
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatePosition.class);
    private static final String _C__59_VALIDATEPOSITION = "[C] 59 ValidatePosition";
    private int _x;
    private int _y;
    private int _z;
    private int _heading;
    private int _data;

    @Override
    protected void readImpl() {
        this._x = this.readD();
        this._y = this.readD();
        this._z = this.readD();
        this._heading = this.readD();
        this._data = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null || activeChar.isTeleporting() || activeChar.inObserverMode()) {
            return;
        }
        int realX = activeChar.getX();
        int realY = activeChar.getY();
        int realZ = activeChar.getZ();
        if (Configuration.general().developer()) {
            LOG.debug("Client pos: {} {} {} head {}", this._x, this._y, this._z, this._heading);
            LOG.debug("Server pos: {} {} {} head {}", realX, realY, realZ, activeChar.getHeading());
        }
        if (this._x == 0 && this._y == 0 && realX != 0) {
            return;
        }
        if (activeChar.isInBoat()) {
            int dy;
            int dx;
            double diffSq;
            if (Configuration.geodata().getCoordSynchronize() == 2 && (diffSq = (double)((dx = this._x - activeChar.getInVehiclePosition().getX()) * dx + (dy = this._y - activeChar.getInVehiclePosition().getY()) * dy)) > 250000.0) {
                this.sendPacket(new GetOnVehicle(activeChar.getObjectId(), this._data, activeChar.getInVehiclePosition()));
            }
            return;
        }
        if (activeChar.isInAirShip()) {
            return;
        }
        if (activeChar.isFalling(this._z)) {
            return;
        }
        int dx = this._x - realX;
        int dy = this._y - realY;
        int dz = this._z - realZ;
        double diffSq = dx * dx + dy * dy;
        if (activeChar.isFlyingMounted() && this._x > -166168) {
            activeChar.untransform();
        }
        if (activeChar.isFlying() || activeChar.isInsideZone(ZoneId.WATER)) {
            activeChar.setXYZ(realX, realY, this._z);
            if (diffSq > 90000.0) {
                activeChar.sendPacket(new ValidateLocation(activeChar));
            }
        } else if (diffSq < 360000.0) {
            if (Configuration.geodata().getCoordSynchronize() == -1) {
                activeChar.setXYZ(realX, realY, this._z);
                return;
            }
            if (Configuration.geodata().getCoordSynchronize() == 1) {
                if (!activeChar.isMoving() || !activeChar.validateMovementHeading(this._heading)) {
                    if (diffSq < 2500.0) {
                        activeChar.setXYZ(realX, realY, this._z);
                    } else {
                        activeChar.setXYZ(this._x, this._y, this._z);
                    }
                } else {
                    activeChar.setXYZ(realX, realY, this._z);
                }
                activeChar.setHeading(this._heading);
                return;
            }
            if (diffSq > 250000.0 || Math.abs(dz) > 200) {
                if (Math.abs(dz) > 200 && Math.abs(dz) < 1500 && Math.abs(this._z - activeChar.getClientZ()) < 800) {
                    activeChar.setXYZ(realX, realY, this._z);
                    realZ = this._z;
                } else {
                    if (Configuration.general().developer()) {
                        LOG.info("{}: Synchronizing position Server --> Client", (Object)activeChar.getName());
                    }
                    activeChar.sendPacket(new ValidateLocation(activeChar));
                }
            }
        }
        activeChar.setClientX(this._x);
        activeChar.setClientY(this._y);
        activeChar.setClientZ(this._z);
        activeChar.setClientHeading(this._heading);
        activeChar.setLastServerPosition(realX, realY, realZ);
    }

    @Override
    public String getType() {
        return _C__59_VALIDATEPOSITION;
    }
}

