/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.AcquireSkillType;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.LinkedList;
import java.util.List;

public class AcquireSkillInfo
extends L2GameServerPacket {
    private final AcquireSkillType type;
    private final int id;
    private final int level;
    private final int cost;
    private final List<Requirements> requirements;

    public AcquireSkillInfo(L2PcInstance player, AcquireSkillType skillType, L2SkillLearn skillLearn) {
        this.id = skillLearn.getSkillId();
        this.level = skillLearn.getSkillLevel();
        this.cost = skillLearn.getCalculatedLevelUpSp(player.getClassId(), player.getLearningClass());
        this.type = skillType;
        this.requirements = new LinkedList<Requirements>();
        if (skillType != AcquireSkillType.PLEDGE || Configuration.character().lifeCrystalNeeded()) {
            for (ItemHolder item : skillLearn.getRequiredItems()) {
                if (!Configuration.character().divineInspirationSpBookNeeded() && this.id == CommonSkill.DIVINE_INSPIRATION.getId()) continue;
                this.requirements.add(new Requirements(99, item.getId(), item.getCount(), 50));
            }
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(145);
        this.writeD(this.id);
        this.writeD(this.level);
        this.writeD(this.cost);
        this.writeD(this.type.ordinal());
        this.writeD(this.requirements.size());
        for (Requirements requirement : this.requirements) {
            this.writeD(requirement.type);
            this.writeD(requirement.id);
            this.writeQ(requirement.count);
            this.writeD(requirement.unk);
        }
    }

    private record Requirements(int type, int id, long count, int unk) {
    }
}

