/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.Hit;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Attack
extends L2GameServerPacket {
    private final int _attackerObjId;
    private final boolean _soulshot;
    private final int _ssGrade;
    private final Location _attackerLoc;
    private final Location _targetLoc;
    private final List<Hit> _hits = new ArrayList<Hit>();

    public Attack(L2Character attacker, L2Character target, boolean useShots, int ssGrade) {
        this._attackerObjId = attacker.getObjectId();
        this._soulshot = useShots;
        this._ssGrade = ssGrade;
        this._attackerLoc = new Location(attacker);
        this._targetLoc = new Location(target);
    }

    public void addHit(L2Character target, int damage, boolean miss, boolean crit, byte shld) {
        this._hits.add(new Hit(target, damage, miss, crit, shld, this._soulshot, this._ssGrade));
    }

    public boolean hasHits() {
        return !this._hits.isEmpty();
    }

    public boolean hasSoulshot() {
        return this._soulshot;
    }

    private void writeHit(Hit hit) {
        this.writeD(hit.getTargetId());
        this.writeD(hit.getDamage());
        this.writeC(hit.getFlags());
    }

    @Override
    protected final void writeImpl() {
        Iterator<Hit> it = this._hits.iterator();
        this.writeC(51);
        this.writeD(this._attackerObjId);
        this.writeHit(it.next());
        this.writeLoc(this._attackerLoc);
        this.writeH(this._hits.size() - 1);
        while (it.hasNext()) {
            this.writeHit(it.next());
        }
        this.writeLoc(this._targetLoc);
    }
}

