/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.cleft.CleftMatch;
import com.l2jserver.gameserver.model.cleft.CleftParticipant;
import com.l2jserver.gameserver.model.cleft.CleftTeam;
import com.l2jserver.gameserver.model.cleft.CleftTowerType;
import com.l2jserver.gameserver.network.serverpackets.AbstractExCleftPacket;
import java.util.Map;
import java.util.Objects;

public abstract class ExCleftState
extends AbstractExCleftPacket {
    private final CleftStateUpdate _state;

    private ExCleftState(CleftStateUpdate state) {
        Objects.requireNonNull(state);
        this._state = state;
    }

    protected void writeRemaining(CleftMatch match) {
        this.writeD(match.getRemainingSeconds());
    }

    protected void writeTeamPoints(CleftMatch match) {
        this.writeD(match.getBlueTeam().getPoints());
        this.writeD(match.getRedTeam().getPoints());
    }

    protected void writeRemainingAndTeamPoints(CleftMatch match) {
        this.writeRemaining(match);
        this.writeTeamPoints(match);
    }

    protected void writeParticipantPerformance(CleftParticipant participant) {
        Objects.requireNonNull(participant);
        this.writeD(participant.getPlayer().getObjectId());
        this.writeD(participant.getKills());
        this.writeD(participant.getDeaths());
        this.writeD(participant.getTowers());
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(149);
        this.writeD(this._state.ordinal());
    }

    private static enum CleftStateUpdate {
        TOTAL,
        TOWER_DESTROY,
        COMBAT_AERIAL_TARGET_UPDATE,
        RESULT,
        PVP_KILL;

    }

    public static final class PvpKill
    extends ExCleftState {
        private final CleftMatch _match;
        private final CleftParticipant _killer;
        private final CleftParticipant _killed;

        public PvpKill(CleftMatch match, CleftParticipant killer, CleftParticipant killed) {
            super(CleftStateUpdate.RESULT);
            Objects.requireNonNull(match);
            Objects.requireNonNull(killer);
            Objects.requireNonNull(killed);
            this._match = match;
            this._killer = killer;
            this._killed = killed;
        }

        @Override
        protected void writeImpl() {
            super.writeImpl();
            this.writeRemainingAndTeamPoints(this._match);
            this.writeTeamId(this._killer.getTeam());
            this.writeParticipantPerformance(this._killer);
            this.writeTeamId(this._killed.getTeam());
            this.writeParticipantPerformance(this._killed);
        }
    }

    public static final class Result
    extends ExCleftState {
        private final CleftTeam _winTeam;
        private final CleftTeam _loseTeam;

        public Result(CleftTeam winTeam, CleftTeam loseTeam) {
            super(CleftStateUpdate.RESULT);
            Objects.requireNonNull(winTeam);
            Objects.requireNonNull(loseTeam);
            this._winTeam = winTeam;
            this._loseTeam = loseTeam;
        }

        @Override
        protected void writeImpl() {
            super.writeImpl();
            this.writeTeamId(this._winTeam);
            this.writeTeamId(this._loseTeam);
        }
    }

    public static final class CombatAerialTargetUpdate
    extends ExCleftState {
        private final CleftMatch _match;
        private final CleftTeam _team;

        public CombatAerialTargetUpdate(CleftMatch match, CleftTeam team) {
            super(CleftStateUpdate.COMBAT_AERIAL_TARGET_UPDATE);
            Objects.requireNonNull(match);
            Objects.requireNonNull(team);
            this._match = match;
            this._team = team;
        }

        @Override
        protected void writeImpl() {
            super.writeImpl();
            this.writeRemaining(this._match);
            this.writeTeamId(this._team);
            this.writeD(this._team.getCombatAerialTarget().getId());
            this.writeS(this._team.getCombatAerialTarget().getName());
        }
    }

    public static final class TowerDestroy
    extends ExCleftState {
        private final CleftMatch _match;
        private final CleftParticipant _destroyer;
        private final CleftTowerType _towerType;

        public TowerDestroy(CleftMatch match, CleftParticipant destroyer, CleftTowerType towerType) {
            super(CleftStateUpdate.TOWER_DESTROY);
            Objects.requireNonNull(match);
            Objects.requireNonNull(destroyer);
            Objects.requireNonNull(towerType);
            this._match = match;
            this._destroyer = destroyer;
            this._towerType = towerType;
        }

        @Override
        protected void writeImpl() {
            super.writeImpl();
            this.writeRemainingAndTeamPoints(this._match);
            this.writeTeamId(this._destroyer.getTeam());
            this.writeD(this._towerType.ordinal());
            this.writeParticipantPerformance(this._destroyer);
        }
    }

    public static final class Total
    extends ExCleftState {
        private final CleftMatch _match;

        public Total(CleftMatch match) {
            super(CleftStateUpdate.TOTAL);
            Objects.requireNonNull(match);
            this._match = match;
        }

        private void writeTeam(CleftTeam team) {
            Map<Integer, CleftParticipant> participants = team.getParticipants();
            this.writeD(participants.size());
            for (Map.Entry<Integer, CleftParticipant> participant : participants.entrySet()) {
                this.writeParticipantPerformance(participant.getValue());
            }
        }

        @Override
        protected void writeImpl() {
            super.writeImpl();
            this.writeRemainingAndTeamPoints(this._match);
            this.writeD(this._match.getBlueTeam().getCombatAerialTarget().getId());
            this.writeD(this._match.getRedTeam().getCombatAerialTarget().getId());
            this.writeS(this._match.getBlueTeam().getCombatAerialTarget().getName());
            this.writeS(this._match.getRedTeam().getCombatAerialTarget().getName());
            this.writeTeam(this._match.getBlueTeam());
            this.writeTeam(this._match.getRedTeam());
        }
    }
}

